/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.jar.JarFile;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.PropsModuleFactory;

@ThreadSafe
public final class JarModuleFactory
extends PropsModuleFactory {
    private final File jar;

    private static Properties getProperties(File jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        return JarModuleFactory.readAndClose(jarFile.getInputStream(jarFile.getEntry("META-INF/openConcertoModule.properties")));
    }

    public JarModuleFactory(File jar) throws IOException {
        super(JarModuleFactory.getProperties(jar));
        this.jar = jar;
    }

    protected final URL[] getClassPath() {
        try {
            return new URL[]{this.jar.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ClassLoader getRsrcClassLoader() {
        return new URLClassLoader(this.getClassPath()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException(String.valueOf(name) + " is hidden from this loader, it only loads properties");
            }
        };
    }

    @Override
    public AbstractModule createModule(File moduleDir, Map<Object, AbstractModule> alreadyCreated) throws Exception {
        return this.createModule(new ModuleClassLoader(moduleDir, alreadyCreated).loadClass(this.getMainClass()), moduleDir);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " from " + this.jar;
    }

    private final class ModuleClassLoader
    extends URLClassLoader {
        private final List<Permission> perms;
        private final ClassLoader[] dependencies;

        public ModuleClassLoader(File moduleDir, Map<Object, AbstractModule> alreadyCreated) {
            super(JarModuleFactory.this.getClassPath(), JarModuleFactory.class.getClassLoader());
            this.perms = new ArrayList<Permission>();
            this.perms.add(new PropertyPermission("*", "read"));
            String absolutePath = moduleDir.getAbsolutePath().endsWith(File.separator) ? moduleDir.getAbsolutePath() : String.valueOf(moduleDir.getAbsolutePath()) + File.separator;
            this.perms.add(new FilePermission(String.valueOf(absolutePath) + "-", "read,write,delete"));
            this.perms.add(new AWTPermission("showWindowWithoutWarningBanner"));
            ClassLoader current = this.getParent();
            while (current != null) {
                this.loadPerms(current);
                current = current.getParent();
            }
            this.dependencies = new ClassLoader[JarModuleFactory.this.getDependencies().size()];
            int i = 0;
            for (Object requiredID : JarModuleFactory.this.getDependencies().keySet()) {
                AbstractModule m = alreadyCreated.get(requiredID);
                if (m == null) {
                    throw new IllegalStateException("Missing required module : " + requiredID);
                }
                this.dependencies[i++] = m.getClass().getClassLoader();
            }
        }

        private final void loadPerms(ClassLoader cl) {
            if (cl instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)cl).getURLs();
                int n = uRLArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    Enumeration<Permission> permissions = super.getPermissions(new CodeSource(url, null)).elements();
                    while (permissions.hasMoreElements()) {
                        this.perms.add(permissions.nextElement());
                    }
                    ++n2;
                }
            } else {
                Log.get().warning("Unknown type of class loader : " + cl + ", cannot be sure that this protection domain will be allowed to read resources from it");
            }
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection res = super.getPermissions(codesource);
            for (Permission perm : this.perms) {
                res.add(perm);
            }
            return res;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException var3_3) {
                var6_5 = this.dependencies;
                var5_6 = this.dependencies.length;
                var4_7 = 0;
                ** while (var4_7 < var5_6)
            }
lbl-1000:
            // 1 sources

            {
                cl = var6_5[var4_7];
                try {
                    res = cl.loadClass(name);
                    if (resolve) {
                        this.resolveClass(res);
                    }
                    return res;
                }
                catch (ClassNotFoundException var7_8) {
                    ++var4_7;
                }
                continue;
            }
lbl17:
            // 1 sources

            throw new ClassNotFoundException(name);
        }
    }
}

