/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.InstallationState;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

@ThreadSafe
public class DepSolverResultMM
extends DepSolverResult
implements ModulesStateChange {
    static final ITransformer<DepSolverResult, ValidState> VALID_PRED = new ITransformer<DepSolverResult, ValidState>(){

        @Override
        public ValidState transformChecked(DepSolverResult input) {
            DepSolverResultMM res = (DepSolverResultMM)input;
            return res.getInstallValidity().and(res.getUninstallValidity());
        }
    };
    private ModuleManager mngr;
    private InstallationState installState = null;
    private ModuleManager.NoChoicePredicate noChoice = null;
    private Set<ModuleReference> refs;
    private ChangeAndValidity toAdd = null;
    private ChangeAndValidity toRemove = null;

    private static final ChangeAndValidity createError(String error) {
        return new ChangeAndValidity(ValidState.createCached(false, error), null);
    }

    private static final ChangeAndValidity createOK(Set<ModuleReference> toChange) {
        if (toChange == null) {
            throw new NullPointerException("Null set");
        }
        return new ChangeAndValidity(ValidState.getTrueInstance(), toChange);
    }

    public DepSolverResultMM(DepSolverResultMM parent, int tryCount, String error, DepSolverGraph graph) {
        super(parent, tryCount, error, graph);
    }

    final void init(ModuleManager mngr, InstallationState installState) {
        this.init(mngr, installState, null, null);
    }

    final synchronized void init(ModuleManager mngr, InstallationState installState, ModuleManager.NoChoicePredicate s, Collection<ModuleReference> refs) {
        if (this.isInited()) {
            throw new IllegalStateException("Already set : " + this.installState);
        }
        if (mngr == null) {
            throw new NullPointerException("Null manager");
        }
        this.mngr = mngr;
        this.setInstallState(installState);
        this.noChoice = s;
        this.refs = refs == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ModuleReference>(refs));
    }

    private final synchronized boolean isInited() {
        return this.installState != null;
    }

    private final synchronized void setInstallState(InstallationState installState) {
        if (installState == null) {
            throw new NullPointerException();
        }
        this.installState = installState;
    }

    public final synchronized ModuleManager getManager() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.mngr;
    }

    @Override
    public final synchronized InstallationState getInstallState() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.installState;
    }

    public final synchronized ModuleManager.NoChoicePredicate getNoChoiceSolution() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.noChoice;
    }

    @Override
    public final synchronized Set<ModuleReference> getUserReferencesToInstall() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.refs;
    }

    @Override
    public final Set<ModuleReference> getReferencesToInstall() {
        return this.getToInstall().toChange;
    }

    @Override
    public final Set<String> getIDsToInstall() {
        return this.getToInstall().toChangeIDs;
    }

    private final synchronized ChangeAndValidity getToInstall() {
        if (this.toAdd == null) {
            this.toAdd = this.computeReferencesToInstall();
            assert (this.toAdd != null);
        }
        return this.toAdd;
    }

    public final ValidState getInstallValidity() {
        return this.getToInstall().validity;
    }

    private final ChangeAndValidity computeReferencesToInstall() {
        Set<ModuleReference> localAndRemote = this.getInstallState().getLocalAndRemote();
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        HashSet<ModuleReference> toInstall = new HashSet<ModuleReference>(factories.size());
        for (ModuleFactory f : factories) {
            if (localAndRemote.contains(f.getReference())) continue;
            toInstall.add(f.getReference());
        }
        ModuleManager.NoChoicePredicate s = this.getNoChoiceSolution();
        if (s == ModuleManager.NoChoicePredicate.NO_CHANGE && toInstall.size() > 0) {
            return DepSolverResultMM.createError((Object)((Object)s) + " required but would install " + toInstall);
        }
        if (s == ModuleManager.NoChoicePredicate.ONLY_INSTALL_ARGUMENTS && !this.getUserReferencesToInstall().containsAll(toInstall)) {
            return DepSolverResultMM.createError((Object)((Object)s) + " required but would install " + CollectionUtils.subtract(toInstall, this.getUserReferencesToInstall()) + "\nin addition to " + this.getUserReferencesToInstall());
        }
        for (ModuleReference toInst : toInstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.INSTALL, toInst, this.getInstallState())) continue;
            return DepSolverResultMM.createError("Current user cannot install " + toInst);
        }
        return DepSolverResultMM.createOK(Collections.unmodifiableSet(toInstall));
    }

    @Override
    public final Set<ModuleReference> getReferencesToRemove() {
        return this.getToUninstall().toChange;
    }

    private final synchronized ChangeAndValidity getToUninstall() {
        if (this.toRemove == null) {
            this.toRemove = this.computeReferencesToRemove();
            assert (this.toRemove != null);
        }
        return this.toRemove;
    }

    public final ValidState getUninstallValidity() {
        return this.getToUninstall().validity;
    }

    @Override
    public boolean forceRemove() {
        return false;
    }

    private final ChangeAndValidity computeReferencesToRemove() {
        LinkedHashSet<ModuleReference> toUninstall;
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        Collection<ModuleFactory> installedFactories = this.getInstallState().getInstalledFactories().values();
        HashSet<ModuleReference> conflicts = new HashSet<ModuleReference>();
        for (ModuleFactory f : installedFactories) {
            if (!f.conflictsWith(factories)) continue;
            conflicts.add(f.getReference());
        }
        try {
            toUninstall = this.getManager().getAllOrderedDependentModulesRecursively(conflicts);
        }
        catch (Exception e) {
            throw new IllegalStateException("couldn't find needing modules for " + conflicts, e);
        }
        ChangeAndValidity okRes = DepSolverResultMM.createOK(Collections.unmodifiableSet(toUninstall));
        if (this.getNoChoiceSolution() != null) {
            Set<String> toInstallIDs = this.getIDsToInstall();
            if (toInstallIDs == null) {
                return DepSolverResultMM.createError((Object)((Object)this.getNoChoiceSolution()) + " required but install is invalid : " + this.getInstallValidity());
            }
            if (!toInstallIDs.containsAll(okRes.toChangeIDs)) {
                return DepSolverResultMM.createError((Object)((Object)this.getNoChoiceSolution()) + " required but would uninstall " + CollectionUtils.subtract(toInstallIDs, okRes.toChangeIDs));
            }
        }
        for (ModuleReference toInst : toUninstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.UNINSTALL, toInst, this.getInstallState())) continue;
            return DepSolverResultMM.createError("Current user cannot uninstall " + toInst);
        }
        return okRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ChangeAndValidity uninstalls;
        ChangeAndValidity installs;
        DepSolverResultMM depSolverResultMM = this;
        synchronized (depSolverResultMM) {
            installs = this.toAdd;
            uninstalls = this.toRemove;
        }
        String installString = this.toString(installs, ", to install");
        String uninstallString = this.toString(uninstalls, ", to remove");
        return String.valueOf(super.toString()) + installString + uninstallString;
    }

    private final String toString(ChangeAndValidity ch, String label) {
        return ch == null ? "" : (ch.validity.isValid() ? String.valueOf(label) + " : " + ch.toChange : " " + ch.validity);
    }

    @Immutable
    private static final class ChangeAndValidity {
        private final Set<ModuleReference> toChange;
        private final Set<String> toChangeIDs;
        private final ValidState validity;

        private ChangeAndValidity(ValidState validity, Set<ModuleReference> toChange) {
            this.validity = validity;
            this.toChange = toChange;
            assert (this.toChange != null == this.validity.isValid());
            this.toChangeIDs = this.toChange == null ? null : Collections.unmodifiableSet(ModuleReference.getIDs(this.toChange));
        }
    }
}

