/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;

public class GenerationMvtSaisieVenteFacture
extends GenerationEcritures
implements Runnable {
    public static final String ID = "accounting.records.invoice.sales";
    private static final String source = "SAISIE_VENTE_FACTURE";
    public static final Integer journal = 3;
    private int idSaisieVenteFacture;
    private boolean useComptePCEVente;
    private static final SQLTable saisieVFTable = base.getTable("SAISIE_VENTE_FACTURE");
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private static final SQLTable ecrTable = base.getTable("ECRITURE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private final boolean genereReglement;

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente, boolean genereReglement) {
        this(idSaisieVenteFacture, idMvt, useComptePCEVente, genereReglement, false);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente, boolean genereReglement, boolean threadSafe) {
        System.err.println("********* init GeneRation");
        this.idMvt = idMvt;
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        this.useComptePCEVente = useComptePCEVente;
        this.genereReglement = genereReglement;
        if (!threadSafe) {
            SheetXml.submitInQueue(this);
        }
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente) {
        this(idSaisieVenteFacture, idMvt, useComptePCEVente, true);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt) {
        this(idSaisieVenteFacture, idMvt, false, true);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture) {
        this(idSaisieVenteFacture, false);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, boolean threadSafe) {
        this(idSaisieVenteFacture, 1, false, true, threadSafe);
    }

    public final void genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = saisieVFTable.getRow(this.idSaisieVenteFacture);
        this.setRowAnalytiqueSource(saisieRow);
        SQLRow clientRow = saisieRow.getForeignRow("ID_CLIENT");
        PrixTTC prixTTC = new PrixTTC(((Long)saisieRow.getObject("T_TTC")).longValue());
        long montantAcompteTTC = 0L;
        int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
        Boolean acompte = saisieRow.getBoolean("ACOMPTE");
        this.nom = acompte != null && acompte != false ? "Fact. acompte client" + saisieRow.getObject("NUMERO").toString() : "Fact. vente " + saisieRow.getObject("NUMERO").toString();
        this.nom = String.valueOf(this.nom) + " " + StringUtils.limitLength(clientRow.getString("NOM"), 20);
        this.putValue("NOM", this.nom);
        this.date = (Date)saisieRow.getObject("DATE");
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        provider.putLabel(saisieRow, this.mEcritures);
        this.putValue("DATE", this.date);
        this.putValue("ID_JOURNAL", journal);
        this.putValue("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(saisieRow, rowValsPiece);
            this.getNewMouvement(source, this.idSaisieVenteFacture, 1, rowValsPiece);
        } else {
            this.putValue("ID_MOUVEMENT", this.idMvt);
            rowValsPiece = mvtTable.getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(saisieRow, rowValsPiece);
            rowValsPiece.update();
        }
        SQLTable tableEchantillon = null;
        BigDecimal portHT = BigDecimal.valueOf(saisieRow.getLong("PORT_HT")).movePointLeft(2);
        TotalCalculator calc = clientRow.getTable().contains("ID_COMPTE_PCE_PRODUIT") && !clientRow.isForeignEmpty("ID_COMPTE_PCE_PRODUIT") ? this.getValuesFromElement(false, false, "T_PV_HT", saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), portHT, saisieRow.getForeign("ID_TAXE_PORT"), tableEchantillon, clientRow.getForeign("ID_COMPTE_PCE_PRODUIT")) : this.getValuesFromElement(saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), portHT, saisieRow.getForeign("ID_TAXE_PORT"), tableEchantillon);
        long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
        if (acompte == null || !acompte.booleanValue()) {
            Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> taxeCompl = calc.getMapHtTaxeCompl();
            for (SQLRowAccessor row : calc.getMapHt().keySet()) {
                long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                if (b == 0L) continue;
                long taxe = 0L;
                if (taxeCompl.containsKey(row)) {
                    Map<SQLRowAccessor, BigDecimal> compl = taxeCompl.get(row);
                    for (SQLRowAccessor rowCompl : compl.keySet()) {
                        if (compl.get(rowCompl) == null) continue;
                        long taxeC = compl.get(rowCompl).multiply(rowCompl.getBigDecimal("POURCENT").movePointLeft(2)).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                        this.putValue("ID_COMPTE_PCE", rowCompl.getForeignID("ID_COMPTE_PCE"));
                        this.putValue("DEBIT", 0L);
                        this.putValue("CREDIT", taxeC);
                        this.ajoutEcriture();
                        taxe += taxeC;
                    }
                }
                Integer idComptePCE = this.useComptePCEVente ? Integer.valueOf(saisieRow.getInt("ID_COMPTE_PCE_VENTE")) : Integer.valueOf(row.getID());
                this.putValue("ID_COMPTE_PCE", idComptePCE);
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", b - taxe);
                this.ajoutEcriture();
            }
            Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
            for (SQLRowAccessor rowAc : tvaMap.keySet()) {
                long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                if (longValue == 0L) continue;
                this.putValue("ID_COMPTE_PCE", rowAc.getID());
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", longValue);
                this.ajoutEcriture();
            }
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            this.putValue("ID_COMPTE_PCE", idCompteClient);
            if (ecrTable.contains("CODE_CLIENT")) {
                this.putValue("CODE_CLIENT", clientRow.getString("CODE"));
            }
            this.putValue("DEBIT", ttcLongValue);
            this.putValue("CREDIT", 0L);
            this.ajoutEcriture();
        }
        SQLRowValues valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("DATE_REGLEMENT", null);
        valSasieVF.update(this.idSaisieVenteFacture);
        if (this.genereReglement) {
            SQLRow modeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
            SQLRow typeRegRow = modeRegl.getForeignRow("ID_TYPE_REGLEMENT");
            String label = String.valueOf(this.nom) + " (" + typeRegRow.getString("NOM") + ") " + StringUtils.limitLength(clientRow.getString("NOM"), 20);
            int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
            if (idAvoir > 1) {
                long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
                prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
            }
            if ((prixTTC = new PrixTTC(saisieRow.getLong("NET_A_PAYER"))).getLongValue() > 0L) {
                new GenerationReglementVenteNG(label.trim(), clientRow, prixTTC, this.date, modeRegl, saisieRow, mvtTable.getRow(this.idMvt));
            }
        }
        valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valSasieVF.getInvalid() == null) {
            valSasieVF.update(this.idSaisieVenteFacture);
            this.displayMvtNumber();
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

