/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public final class AnalytiqueCache {
    private final transient Map<Integer, SQLRowAccessor> mapPoste = new HashMap<Integer, SQLRowAccessor>();
    private final List<SQLRow> axes;
    private static AnalytiqueCache instance;
    private transient Map<Integer, SQLRow> defaultPoste = new HashMap<Integer, SQLRow>();

    private static final SQLSelect getSelPoste() {
        DBRoot root = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        SQLTable table = root.getTable("POSTE_ANALYTIQUE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getKey());
        sel.addSelect(table.getField("NOM"));
        sel.addSelect(table.getField("ID_AXE_ANALYTIQUE"));
        sel.addSelect(table.getField("DEFAULT"));
        return sel;
    }

    private static final SQLSelect getSelAxe() {
        DBRoot root = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        SQLTable table = root.getTable("AXE_ANALYTIQUE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getKey());
        sel.addSelect(table.getField("NOM"));
        return sel;
    }

    private AnalytiqueCache() {
        SQLSelect sel = AnalytiqueCache.getSelPoste();
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapPoste.put(sqlRow.getID(), sqlRow);
            if (!sqlRow.getBoolean("DEFAULT").booleanValue()) continue;
            this.defaultPoste.put(sqlRow.getForeignID("ID_AXE_ANALYTIQUE"), sqlRow);
        }
        this.axes = new ArrayList<SQLRow>();
        sel = AnalytiqueCache.getSelAxe();
        l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.axes.add(sqlRow);
        }
    }

    public Collection<SQLRow> getAxes() {
        return Collections.unmodifiableCollection(this.axes);
    }

    public static synchronized AnalytiqueCache getCache() {
        if (instance == null) {
            instance = new AnalytiqueCache();
        }
        return instance;
    }

    public SQLRowAccessor getPosteFromId(int id) {
        return this.mapPoste.get(id);
    }

    public SQLRow getDefaultPoste(int idAxe) {
        return this.defaultPoste.get(idAxe);
    }
}

