/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;

public class OOXMLCache {
    private ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> postProcess = null;
    private Map<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>> cacheReferent = new HashMap<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>>();
    private Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();

    public void setPostProcess(ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> postProcess) {
        this.postProcess = postProcess;
    }

    protected SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = this.cacheForeign.get(field.getName());
        if (row.getObject(field.getName()) == null) {
            return null;
        }
        int i = row.getForeignID(field.getName());
        if (c != null && c.get(i) != null) {
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            this.cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    public List<? extends SQLRowAccessor> getReferentRows(List<? extends SQLRowAccessor> row, SQLTable tableForeign) {
        return this.getReferentRows(row, tableForeign, null, null, false, null, false);
    }

    /*
     * WARNING - void declaration
     */
    protected List<? extends SQLRowAccessor> getReferentRows(List<? extends SQLRowAccessor> row, final SQLTable tableForeign, String groupBy, final String orderBy, boolean expandNomenclature, String foreignField, boolean excludeQteZero) {
        List<SQLRowAccessor> list;
        Map<SQLTable, List<SQLRowAccessor>> c = this.cacheReferent.get(row.get(0));
        if (c != null && c.get(tableForeign) != null) {
            System.err.println("get referent rows From Cache ");
            return c.get(tableForeign);
        }
        if (row.isEmpty() || row.size() > 0 && row.get(0).isUndefined()) {
            list = new ArrayList<SQLRowAccessor>();
        } else if (row.size() > 0 && (groupBy == null || groupBy.trim().length() == 0)) {
            list = new ArrayList();
            SQLRowValues rowValsToFetch = new SQLRowValues(tableForeign);
            rowValsToFetch.putNulls(tableForeign.getFieldsName());
            if (tableForeign.getFieldsName().contains("ID_ARTICLE")) {
                SQLRowValues rowValsToFetchArt = new SQLRowValues(tableForeign.getForeignTable("ID_ARTICLE"));
                rowValsToFetchArt.putNulls(rowValsToFetchArt.getTable().getFieldsName());
                rowValsToFetch.put("ID_ARTICLE", (Object)rowValsToFetchArt);
            }
            Where w = null;
            if (foreignField != null && foreignField.trim().length() > 0) {
                for (SQLRowAccessor sQLRowAccessor : row) {
                    if (sQLRowAccessor == null || sQLRowAccessor.isUndefined()) continue;
                    w = w == null ? new Where((FieldRef)tableForeign.getField(foreignField), "=", sQLRowAccessor.getID()) : w.or(new Where((FieldRef)tableForeign.getField(foreignField), "=", sQLRowAccessor.getID()));
                }
            } else {
                for (SQLRowAccessor sQLRowAccessor : row) {
                    if (sQLRowAccessor == null || sQLRowAccessor.isUndefined()) continue;
                    w = w == null ? new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()) : w.or(new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()));
                }
            }
            if (excludeQteZero) {
                w = w.and(new Where((FieldRef)tableForeign.getField("QTE"), "!=", 0));
            }
            final Where where = w;
            SQLRowValuesListFetcher sQLRowValuesListFetcher = SQLRowValuesListFetcher.create(rowValsToFetch);
            sQLRowValuesListFetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect sel) {
                    sel.setWhere(where);
                    OOXMLCache.this.addSelectOrder(tableForeign, orderBy, sel);
                    System.err.println(sel.asString());
                    return sel;
                }
            });
            list.addAll(sQLRowValuesListFetcher.fetch());
        } else {
            void var12_26;
            void var12_24;
            List<String> params = SQLRow.toList(groupBy);
            SQLSelect sel = new SQLSelect();
            sel.addSelect(tableForeign.getKey());
            boolean bl = false;
            while (var12_24 < params.size()) {
                sel.addSelect(tableForeign.getField(params.get((int)var12_24)));
                ++var12_24;
            }
            Object var12_25 = null;
            for (SQLRowAccessor sQLRowAccessor : row) {
                if (var12_26 == null) {
                    Where where = new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID());
                    continue;
                }
                Where where = var12_26.or(new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()));
            }
            sel.setWhere((Where)var12_26);
            this.addSelectOrder(tableForeign, orderBy, sel);
            System.err.println(sel.asString());
            List<SQLRow> list2 = SQLRowListRSH.execute(sel);
            list = new ArrayList();
            HashMap<Integer, SQLRowValues> m = new HashMap<Integer, SQLRowValues>();
            for (SQLRow sqlRow : list2) {
                SQLRowValues rowVals;
                Integer object = sqlRow.getInt(params.get(0));
                if (m.get(object) == null || object == 1) {
                    rowVals = sqlRow.asRowValues();
                    m.put(object, rowVals);
                    list.add(rowVals);
                    continue;
                }
                rowVals = (SQLRowValues)m.get(object);
                this.cumulRows(params, sqlRow, rowVals);
            }
        }
        if (expandNomenclature) {
            list = this.expandNomenclature(list);
        }
        if (this.postProcess != null) {
            list = this.postProcess.transformChecked(list);
        }
        if (c == null) {
            HashMap<SQLTable, ArrayList<SQLRowAccessor>> map = new HashMap<SQLTable, ArrayList<SQLRowAccessor>>();
            map.put(tableForeign, (ArrayList<SQLRowAccessor>)list);
            this.cacheReferent.put(row.get(0), map);
        } else {
            c.put(tableForeign, list);
        }
        if (orderBy != null && orderBy.trim().length() > 0 && !orderBy.contains(".")) {
            Collections.sort(list, new Comparator<SQLRowAccessor>(){

                @Override
                public int compare(SQLRowAccessor o1, SQLRowAccessor o2) {
                    return CompareUtils.compare(o1.getObject(orderBy), o2.getObject(orderBy));
                }
            });
        }
        return list;
    }

    private List<SQLRowAccessor> expandNomenclature(List<SQLRowAccessor> list) {
        final ArrayList<Integer> idsArt = new ArrayList<Integer>(list.size());
        DBRoot root = null;
        SQLTable table = null;
        for (SQLRowAccessor r : list) {
            root = r.getTable().getDBRoot();
            table = r.getTable();
            if (r.isForeignEmpty("ID_ARTICLE")) continue;
            idsArt.add(r.getForeignID("ID_ARTICLE"));
        }
        ArrayList<SQLRowAccessor> result = new ArrayList<SQLRowAccessor>();
        if (root != null) {
            Map<String, Integer> style = Configuration.getInstance().getDirectory().getElement(StyleSQLElement.class).getAllStyleByName();
            final SQLTable tableArtElt = root.getTable("ARTICLE_ELEMENT");
            SQLRowValues rowVals = new SQLRowValues(tableArtElt);
            rowVals.putNulls("QTE", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE_PARENT");
            rowVals.putRowValues("ID_ARTICLE").setAllToNull();
            SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
            fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where(input.getAlias(tableArtElt.getField("ID_ARTICLE_PARENT")), idsArt));
                    return input;
                }
            });
            List<SQLRowValues> l = fetch.fetch();
            ListMap<Integer, SQLRowValues> map = new ListMap<Integer, SQLRowValues>();
            for (SQLRowValues sqlRowValues : l) {
                SQLRowValues rowInj = new SQLRowValues(table);
                SQLRowAccessor foreignArt = sqlRowValues.getForeign("ID_ARTICLE");
                rowInj.put("ID_ARTICLE", (Object)foreignArt.asRowValues());
                rowInj.put("QTE", sqlRowValues.getInt("QTE"));
                rowInj.put("NOM", foreignArt.getObject("NOM"));
                rowInj.put("CODE", foreignArt.getObject("CODE"));
                rowInj.put("QTE_UNITAIRE", sqlRowValues.getObject("QTE_UNITAIRE"));
                rowInj.put("ID_UNITE_VENTE", sqlRowValues.getObject("ID_UNITE_VENTE"));
                rowInj.put("PV_HT", BigDecimal.ZERO);
                rowInj.put("T_PV_HT", BigDecimal.ZERO);
                rowInj.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
                rowInj.put("NIVEAU", 1);
                rowInj.put("ID_STYLE", style.get("Composant"));
                map.add(sqlRowValues.getForeignID("ID_ARTICLE_PARENT"), rowInj);
            }
            int size = list.size();
            int i = 0;
            while (i < size) {
                List c;
                SQLRowAccessor sqlRowAccessor = list.get(i);
                result.add(sqlRowAccessor);
                if (!sqlRowAccessor.isForeignEmpty("ID_ARTICLE") && sqlRowAccessor.getInt("NIVEAU") == 1 && (c = (List)map.get(sqlRowAccessor.getForeignID("ID_ARTICLE"))) != null) {
                    if (i + 1 < size) {
                        SQLRowAccessor rowAccessorNext = list.get(i + 1);
                        if (rowAccessorNext.getInt("NIVEAU") == 1) {
                            for (SQLRowValues sqlRowValues : c) {
                                sqlRowValues.put("QTE", sqlRowValues.getInt("QTE") * sqlRowAccessor.getInt("QTE"));
                                result.add(sqlRowValues);
                            }
                        }
                    } else {
                        for (SQLRowValues sqlRowValues : c) {
                            sqlRowValues.put("QTE", sqlRowValues.getInt("QTE") * sqlRowAccessor.getInt("QTE"));
                            result.add(sqlRowValues);
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private void addSelectOrder(SQLTable tableForeign, String orderBy, SQLSelect sel) {
        if (orderBy != null && orderBy.contains(".")) {
            String fieldRefTable = orderBy.substring(0, orderBy.indexOf(46));
            String field = orderBy.substring(orderBy.indexOf(46) + 1, orderBy.length());
            sel.addJoin("LEFT", sel.getAlias(tableForeign).getField(fieldRefTable));
            sel.addFieldOrder(sel.getAlias(tableForeign.getForeignTable(fieldRefTable)).getField(field));
        } else {
            sel.addFieldOrder(tableForeign.getOrderField());
        }
    }

    private void cumulRows(List<String> params, SQLRow sqlRow, SQLRowValues rowVals) {
        int i = 1;
        while (i < params.size()) {
            if (rowVals.getTable().getField(params.get(i)).getType().getJavaType() == String.class) {
                String string = sqlRow.getString(params.get(i));
                if (params.get(i).equalsIgnoreCase("NOM")) {
                    string = String.valueOf(sqlRow.getInt("QTE")) + " x " + string;
                }
                rowVals.put(params.get(i), String.valueOf(rowVals.getString(params.get(i))) + ", " + string);
            } else if (!rowVals.getTable().getField(params.get(i)).isKey()) {
                Long n = rowVals.getLong(params.get(i));
                rowVals.put(params.get(i), n + sqlRow.getLong(params.get(i)));
            }
            ++i;
        }
    }

    public Map<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>> getCacheReferent() {
        return this.cacheReferent;
    }

    public void clearCache() {
        this.cacheReferent.clear();
        this.cacheForeign.clear();
    }
}

