/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.utils.ListMap;

public class StockItem {
    private double realQty;
    private double virtualQty;
    private double receiptQty;
    private double deliverQty;
    public SQLRowAccessor article;
    List<StockItemComponent> components = new ArrayList<StockItemComponent>();

    public StockItem(SQLRowAccessor article) {
        this.article = article;
        if (this.article.isForeignEmpty("ID_STOCK")) {
            this.realQty = 0.0;
            this.virtualQty = 0.0;
            this.receiptQty = 0.0;
            this.deliverQty = 0.0;
        } else {
            SQLRowAccessor row = this.article.getForeign("ID_STOCK");
            this.realQty = row.getFloat("QTE_REEL");
            this.virtualQty = row.getFloat("QTE_TH");
            this.receiptQty = row.getFloat("QTE_RECEPT_ATTENTE");
            this.deliverQty = row.getFloat("QTE_LIV_ATTENTE");
        }
    }

    public void updateQty(double qty, TypeStockMouvement t) {
        this.updateQty(qty, t, false);
    }

    public SQLRowAccessor getArticle() {
        return this.article;
    }

    public void addItemComponent(StockItemComponent item) {
        this.components.add(item);
    }

    public void updateQtyFromChildren() throws IllegalArgumentException {
        if (this.components.size() == 0) {
            throw new IllegalArgumentException("Impossible de calcul\u00e9 les quantit\u00e9s depuis les composants. Cet article n'est pas compos\u00e9!");
        }
        StockItemComponent comp = this.components.get(0);
        double real = comp.getItem().getRealQty() == 0.0 ? 0.0 : Math.ceil(comp.getItem().getRealQty() / ((double)comp.getQty() * comp.getQtyUnit().doubleValue()));
        double virtual = comp.getItem().getVirtualQty() == 0.0 ? 0.0 : Math.ceil(comp.getItem().getVirtualQty() / ((double)comp.getQty() * comp.getQtyUnit().doubleValue()));
        for (StockItemComponent stockItemComponent : this.components) {
            real = Math.min(real, stockItemComponent.getItem().getRealQty() == 0.0 ? 0.0 : Math.ceil(stockItemComponent.getItem().getRealQty() / ((double)stockItemComponent.getQty() * stockItemComponent.getQtyUnit().doubleValue())));
            virtual = Math.min(virtual, stockItemComponent.getItem().getVirtualQty() == 0.0 ? 0.0 : Math.ceil(stockItemComponent.getItem().getVirtualQty() / ((double)stockItemComponent.getQty() * stockItemComponent.getQtyUnit().doubleValue())));
        }
        this.realQty = Math.max(0.0, real);
        this.virtualQty = Math.max(0.0, virtual);
    }

    public void fillCommandeFournisseur(ListMap<SQLRow, SQLRowValues> cmd) {
        SQLPreferences prefs = new SQLPreferences(this.article.getTable().getDBRoot());
        boolean gestionStockMin = prefs.getBoolean(GestionArticleGlobalPreferencePanel.WARNING_STOCK_MIN, true);
        if (this.article.getTable().getFieldsName().contains("QTE_MIN") && gestionStockMin && this.article.getObject("QTE_MIN") != null && this.getRealQty() < (double)this.article.getInt("QTE_MIN")) {
            SQLInjector inj = SQLInjector.getInjector(this.article.getTable(), this.article.getTable().getTable("COMMANDE_ELEMENT"));
            SQLRow asRow = this.article.asRow();
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(asRow));
            rowValsElt.put("ID_STYLE", 2);
            SQLRowAccessor unite = this.article.getForeign("ID_UNITE_VENTE");
            double qteElt = (double)this.article.getInt("QTE_MIN") - this.getRealQty();
            if (unite.isUndefined() || unite.getBoolean("A_LA_PIECE").booleanValue()) {
                rowValsElt.put("QTE", Math.round(qteElt));
                rowValsElt.put("QTE_UNITAIRE", BigDecimal.ONE);
            } else {
                rowValsElt.put("QTE", 1);
                rowValsElt.put("QTE_UNITAIRE", new BigDecimal(qteElt));
            }
            rowValsElt.put("ID_TAXE", rowValsElt.getObject("ID_TAXE"));
            rowValsElt.put("T_POIDS", (double)rowValsElt.getLong("POIDS") * qteElt);
            rowValsElt.put("T_PA_HT", (double)rowValsElt.getLong("PA_HT") * qteElt);
            rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
            cmd.add(asRow.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
    }

    public void updateQty(double qty, TypeStockMouvement t, boolean archive) {
        double qteNvlle;
        double qteOrigin;
        if (t == TypeStockMouvement.REEL || t == TypeStockMouvement.REEL_THEORIQUE || t == TypeStockMouvement.RETOUR) {
            qteOrigin = this.realQty;
            if (archive) {
                qteNvlle = qteOrigin - qty;
                if (t != TypeStockMouvement.RETOUR) {
                    if (qty > 0.0) {
                        this.receiptQty += qty;
                    } else {
                        this.deliverQty -= qty;
                    }
                }
            } else {
                qteNvlle = qteOrigin + qty;
                if (t != TypeStockMouvement.RETOUR) {
                    if (qty > 0.0) {
                        this.receiptQty -= qty;
                    } else {
                        this.deliverQty += qty;
                    }
                }
            }
            this.realQty = qteNvlle;
        }
        if (t == TypeStockMouvement.THEORIQUE || t == TypeStockMouvement.REEL_THEORIQUE || t == TypeStockMouvement.RETOUR) {
            qteOrigin = this.virtualQty;
            if (archive) {
                qteNvlle = qteOrigin - qty;
                if (t != TypeStockMouvement.RETOUR) {
                    if (qty > 0.0) {
                        this.receiptQty -= qty;
                    } else {
                        this.deliverQty += qty;
                    }
                }
            } else {
                qteNvlle = qteOrigin + qty;
                if (t != TypeStockMouvement.RETOUR) {
                    if (qty > 0.0) {
                        this.receiptQty += qty;
                    } else {
                        this.deliverQty -= qty;
                    }
                }
            }
            this.virtualQty = qteNvlle;
        }
    }

    public double getDeliverQty() {
        return this.deliverQty;
    }

    public double getRealQty() {
        return this.realQty;
    }

    public double getReceiptQty() {
        return this.receiptQty;
    }

    public double getVirtualQty() {
        return this.virtualQty;
    }

    public boolean isStockInit() {
        return !this.article.isForeignEmpty("ID_STOCK");
    }

    public void clearStockValues() {
        this.realQty = 0.0;
        this.deliverQty = 0.0;
        this.receiptQty = 0.0;
        this.virtualQty = 0.0;
    }

    public String getUpdateRequest() {
        SQLTable stockTable = this.article.getTable().getForeignTable("ID_STOCK");
        UpdateBuilder update = new UpdateBuilder(stockTable);
        update.setWhere(new Where((FieldRef)stockTable.getKey(), "=", this.getArticle().getForeign("ID_STOCK").getID()));
        update.setObject("QTE_REEL", (Object)this.getRealQty());
        update.setObject("QTE_TH", (Object)this.getVirtualQty());
        update.setObject("QTE_LIV_ATTENTE", (Object)this.getDeliverQty());
        update.setObject("QTE_RECEPT_ATTENTE", (Object)this.getReceiptQty());
        return update.asString();
    }

    public static enum TypeStockMouvement {
        REEL,
        THEORIQUE,
        REEL_THEORIQUE,
        RETOUR;

    }
}

