/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.ui;

import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;

public class EtatDevisRenderer
extends DefaultTableCellRenderer {
    public static final Color couleurBeige = new Color(253, 243, 204);
    public static final Color couleurVert = new Color(225, 254, 207);
    public static final Color couleurRed = new Color(255, 232, 245);
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(this, table, isSelected);
        if (table.getColumnClass(column) == Long.class || table.getColumnClass(column) == BigInteger.class) {
            if (value.getClass() == Long.class || value.getClass() == BigInteger.class) {
                this.setText(GestionDevise.currencyToString((Long)value));
            }
        } else if (value != null && (table.getColumnClass(column) == Date.class || table.getColumnClass(column) == java.sql.Date.class)) {
            this.setText(this.dateFormat.format((Date)value));
        }
        if (!isSelected) {
            SQLRowValues rowElt = ITableModel.getLine(table.getModel(), row).getRow();
            switch (this.getEtat(rowElt)) {
                case 2: {
                    this.setBackground(couleurBeige);
                    break;
                }
                case 4: {
                    this.setBackground(Color.WHITE);
                    break;
                }
                case 3: {
                    this.setBackground(couleurRed);
                    break;
                }
            }
        }
        return this;
    }

    protected int getEtat(SQLRowValues rowElt) {
        return rowElt.getInt("ID_ETAT_DEVIS");
    }
}

