/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.erp.core.common.ui.AcompteRowItemView;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AddressChoiceUI;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.DevisItemTable;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.map.ui.ITextComboVilleViewer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.ui.RadioButtons;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class DevisSQLComponent
extends BaseSQLComponent {
    private AbstractArticleItemTable table;
    private JUniqueTextField numeroUniqueDevis;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea();
    private final RadioButtons radioEtat = new RadioButtons("NOM");
    private JTextField textPourcentRemise;
    private JTextField textPoidsTotal;
    private DeviseField textRemiseHT;
    private DeviseField fieldHT;
    private PanelOOSQLComponent panelOO;
    final JTextField telSite = new JTextField(20);
    final ITextComboVilleViewer villeSite = new ITextComboVilleViewer();
    final JTextField faxSite = new JTextField(20);
    final JTextField telPSite = new JTextField(20);
    final JTextField mailSite = new JTextField(20);
    final JTextField contactSite = new JTextField(20);
    final JTextField desSite = new JTextField(20);
    final ITextArea adrSite = new ITextArea();
    final JTextField telDonneur = new JTextField(20);
    final JTextField sirenDonneur = new JTextField(20);
    final ITextComboVilleViewer villeDonneur = new ITextComboVilleViewer();
    final JTextField faxDonneur = new JTextField(20);
    final JTextField telPDonneur = new JTextField(20);
    final JTextField mailDonneur = new JTextField(20);
    final JTextField contactDonneur = new JTextField(20);
    final JTextField desDonneur = new JTextField(20);
    final ITextArea adrDonneur = new ITextArea();
    private final boolean displayDpt;
    private final ElementComboBox comboDpt = new ElementComboBox(false, 25);
    private final JDate dateDevis = new JDate(true);
    private ValidState validStateContact = ValidState.getTrueInstance();

    public DevisSQLComponent(SQLElement elt) {
        super(elt);
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        this.displayDpt = prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false);
    }

    public AbstractArticleItemTable getRowValuesTable() {
        return this.table;
    }

    @Override
    public Set<String> getPartialResetNames() {
        HashSet<String> s = new HashSet<String>();
        s.add("OBJET");
        s.add("NUMERO");
        return s;
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNumero = new JLabel(this.getLabelFor("NUMERO"));
        labelNumero.setHorizontalAlignment(4);
        this.add((Component)labelNumero, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.numeroUniqueDevis = new JUniqueTextField(15){

            @Override
            public String getAutoRefreshNumber() {
                if (DevisSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(DevisSQLComponent.this.getElement().getClass(), DevisSQLComponent.this.dateDevis.getDate());
                }
                return null;
            }
        };
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueDevis);
        DefaultGridBagConstraints.lockMaximumSize(this.numeroUniqueDevis);
        this.add((Component)this.numeroUniqueDevis, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.dateDevis, c);
        this.dateDevis.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!DevisSQLComponent.this.isFilling() && DevisSQLComponent.this.dateDevis.getValue() != null) {
                    DevisSQLComponent.this.table.setDateDevise(DevisSQLComponent.this.dateDevis.getValue());
                }
            }
        });
        this.radioEtat.setLayout(new VFlowLayout());
        this.radioEtat.setBorder(BorderFactory.createTitledBorder(this.getLabelFor("ID_ETAT_DEVIS")));
        c.gridwidth = 0;
        c.gridheight = 5;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.gridx += 2;
        this.radioEtat.initLocalization((ITransformer<? super String, String>)new ITransformer<String, String>(){

            @Override
            public String transformChecked(String id) {
                return id;
            }
        });
        this.add((Component)this.radioEtat, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 0.0;
        JLabel labelObjet = new JLabel(this.getLabelFor("OBJET"));
        labelObjet.setHorizontalAlignment(4);
        this.add((Component)labelObjet, c);
        SQLTextCombo textObjet = new SQLTextCombo();
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 1;
        this.add((Component)textObjet, c);
        String field = "ID_COMMERCIAL";
        JLabel labelCommercial = new JLabel(this.getLabelFor(field));
        labelCommercial.setHorizontalAlignment(4);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)labelCommercial, c);
        final ElementComboBox comboCommercial = new ElementComboBox(false, 25);
        comboCommercial.setListIconVisible(false);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)comboCommercial, c);
        this.addRequiredSQLObject(comboCommercial, field);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"));
        labelClient.setHorizontalAlignment(4);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)labelClient, c);
        final ElementComboBox comboClient = new ElementComboBox();
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)comboClient, c);
        this.addRequiredSQLObject(comboClient, "ID_CLIENT");
        comboClient.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRow rowClient;
                int wantedID = comboClient.getWantedID();
                if (wantedID != -1 && wantedID >= 0 && !(rowClient = DevisSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID)).isForeignEmpty("ID_COMMERCIAL")) {
                    comboCommercial.setValue(rowClient.getForeignID("ID_COMMERCIAL"));
                }
            }
        });
        if (this.displayDpt) {
            ++c.gridx;
            c.gridwidth = 1;
            JLabel labelDpt = new JLabel(this.getLabelFor("ID_CLIENT_DEPARTEMENT"));
            labelDpt.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelDpt, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)this.comboDpt, c);
            DefaultGridBagConstraints.lockMinimumSize(this.comboDpt);
            this.addSQLObject(this.comboDpt, "ID_CLIENT_DEPARTEMENT");
            comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = comboClient.getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = DevisSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        DevisSQLComponent.this.comboDpt.getRequest().setWhere(new Where((FieldRef)DevisSQLComponent.this.comboDpt.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", rowClient.getID()));
                    } else {
                        DevisSQLComponent.this.comboDpt.getRequest().setWhere(null);
                    }
                }
            });
        }
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        final ElementComboBox boxTarif = new ElementComboBox();
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ADDRESS_SPEC, true)) {
            final SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
            final AddressChoiceUI addressUI = new AddressChoiceUI();
            addressUI.addToUI(this, c);
            comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        addressUI.getComboAdrF().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                        addressUI.getComboAdrL().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                    } else {
                        addressUI.getComboAdrF().getRequest().setWhere(Where.FALSE);
                        addressUI.getComboAdrL().getRequest().setWhere(Where.FALSE);
                    }
                }
            });
        }
        if (this.getTable().contains("ID_CONTACT")) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"));
            labelContact.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelContact, c);
            final ElementComboBox comboContact = new ElementComboBox();
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)comboContact, c);
            final SQLElement contactElement = this.getElement().getForeignElement("ID_CONTACT");
            comboContact.init(contactElement, contactElement.getComboRequest(true));
            comboContact.getRequest().setWhere(Where.FALSE);
            DefaultGridBagConstraints.lockMinimumSize(comboContact);
            this.addView(comboContact, "ID_CONTACT");
            comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = DevisSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        int idClient = rowClient.getID();
                        comboContact.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_CLIENT"), "=", idClient));
                    } else {
                        comboContact.getRequest().setWhere(Where.FALSE);
                        DevisSQLComponent.this.table.setTarif(null, false);
                    }
                }
            });
        }
        if (this.getTable().getFieldsName().contains("DATE_VALIDITE")) {
            ++c.gridx;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("DATE_VALIDITE"), 4), c);
            c.fill = 0;
            ++c.gridx;
            JDate dateValidite = new JDate();
            this.add((Component)dateValidite, c);
            this.addView(dateValidite, "DATE_VALIDITE");
        }
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            JLabel comp = new JLabel(this.getLabelFor("ID_TARIF"), 4);
            this.add((Component)comp, c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            DefaultGridBagConstraints.lockMinimumSize(boxTarif);
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    DevisSQLComponent.this.table.setTarif(selectedRow, !DevisSQLComponent.this.isFilling());
                }
            });
            if (this.getTable().getFieldsName().contains("DUNNING_DATE")) {
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 2;
                this.add((Component)new JLabel(this.getLabelFor("DUNNING_DATE"), 4), c);
                ++c.gridx;
                c.fill = 0;
                JDate dateRelance = new JDate();
                this.add((Component)dateRelance, c);
                if (this.getTable().getDBRoot().contains("TARIF_AGENCE")) {
                    this.addView(dateRelance, "DUNNING_DATE", (Object)"required");
                } else {
                    this.addView(dateRelance, "DUNNING_DATE");
                }
            }
        }
        this.table = new DevisItemTable();
        final AcompteField acompteField = new AcompteField();
        acompteField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                Acompte a = acompteField.getValue();
                ((DevisItemTable)DevisSQLComponent.this.table).calculPourcentage(a, AbstractVenteArticleItemTable.TypeCalcul.CALCUL_REMISE);
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JLabel comp = new JLabel(this.getLabelFor("MONTANT_REMISE"), 4);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.addView(new AcompteRowItemView(acompteField), "MONTANT_REMISE,POURCENT_REMISE", null);
        c.fill = 1;
        c.gridx = 0;
        c.gridy += 5;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.table, c);
        this.addView(this.table.getRowValuesTable(), "");
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cBottom = new DefaultGridBagConstraints();
        cBottom.weightx = 1.0;
        bottomPanel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), cBottom);
        ++cBottom.gridy;
        cBottom.fill = 1;
        cBottom.weighty = 0.0;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        bottomPanel.add((Component)scrollPane, cBottom);
        JPanel panel = new JPanel(new GridBagLayout());
        this.textPoidsTotal = new JTextField(8);
        this.textPoidsTotal.setText("0.0");
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel(this.getLabelFor("T_POIDS")), cPanel);
        cPanel.weightx = 0.0;
        ++cPanel.gridx;
        panel.add((Component)this.textPoidsTotal, cPanel);
        this.textPoidsTotal.setEnabled(false);
        this.textPoidsTotal.setEditable(false);
        this.textPoidsTotal.setHorizontalAlignment(4);
        this.textPoidsTotal.setDisabledTextColor(Color.BLACK);
        DeviseField textPortHT = new DeviseField();
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            cPanel.gridx = 0;
            ++cPanel.gridy;
            panel.add((Component)labelPortHT, cPanel);
            ++cPanel.gridx;
            panel.add((Component)textPortHT, cPanel);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cPanel.gridx = 0;
            ++cPanel.gridy;
            panel.add((Component)labelTaxeHT, cPanel);
            ++cPanel.gridx;
            panel.add((Component)boxTaxePort, cPanel);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
        }
        final JRadioButton radioEuros = new JRadioButton("en \u20ac");
        JRadioButton radioPourCent = new JRadioButton("en %");
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(radioEuros);
        radioGroup.add(radioPourCent);
        radioEuros.setSelected(true);
        JPanel panelRemise = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cRemise = new DefaultGridBagConstraints();
        cRemise.insets = new Insets(0, 0, 1, 0);
        JLabel labelRemise = new JLabel(this.getLabelFor("REMISE_HT"));
        panelRemise.add((Component)labelRemise, cRemise);
        ++cRemise.gridx;
        cRemise.weightx = 0.0;
        this.textRemiseHT = new DeviseField();
        panelRemise.add((Component)this.textRemiseHT, cRemise);
        this.textRemiseHT.setMinimumSize(new Dimension(150, this.textRemiseHT.getMinimumSize().height));
        this.textRemiseHT.setPreferredSize(new Dimension(150, this.textRemiseHT.getPreferredSize().height));
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            ++cRemise.gridy;
            cRemise.gridx = 0;
            cRemise.weightx = 0.0;
            cRemise.weighty = 0.0;
            cRemise.gridwidth = 1;
            JLabel compAcompte = new JLabel(this.getLabelFor("T_ACOMPTE"), 4);
            panelRemise.add((Component)compAcompte, cRemise);
            ++cRemise.gridx;
            cRemise.gridwidth = 0;
            DeviseField fieldAcompte = new DeviseField();
            fieldAcompte.setEnabled(false);
            cRemise.weightx = 1.0;
            panelRemise.add((Component)fieldAcompte, cRemise);
            this.addView(fieldAcompte, "T_ACOMPTE");
        }
        this.textPourcentRemise = new JTextField(5);
        cPanel.gridx = 0;
        ++cPanel.gridy;
        cPanel.gridwidth = 2;
        panel.add((Component)panelRemise, cPanel);
        cBottom.gridy = 0;
        ++cBottom.gridx;
        cBottom.weighty = 0.0;
        cBottom.weightx = 1.0;
        cBottom.gridheight = 2;
        cBottom.fill = 2;
        cBottom.anchor = 12;
        DefaultGridBagConstraints.lockMinimumSize(panel);
        bottomPanel.add((Component)panel, cBottom);
        this.addSQLObject(this.textRemiseHT, "REMISE_HT");
        this.addSQLObject(textPortHT, "PORT_HT");
        this.fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        this.fieldHT.setEditable(false);
        fieldTVA.setEditable(false);
        fieldTTC.setEditable(false);
        fieldService.setEditable(false);
        fieldEco.setEditable(false);
        this.addSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(this.fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        JTextField poids = new JTextField();
        DeviseField fieldHA = new DeviseField();
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.addSQLObject(fieldHA, "T_HA");
        }
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldEco, this.fieldHT, fieldTVA, fieldTTC, textPortHT, this.textRemiseHT, fieldService, fieldHA, fieldDevise, poids, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null, null);
        cBottom.gridy = 0;
        cBottom.gridx += 2;
        cBottom.gridheight = 2;
        cBottom.gridwidth = 1;
        cBottom.fill = 0;
        cBottom.weightx = 0.0;
        cBottom.anchor = 12;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        bottomPanel.add((Component)totalTTC, cBottom);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 0;
        this.add((Component)bottomPanel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 14;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        boxTaxePort.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                totalTTC.updateTotal();
            }
        });
        textPortHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.textRemiseHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.textPourcentRemise.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                DevisSQLComponent.this.calculPourcentage();
            }
        });
        radioEuros.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DevisSQLComponent.this.textRemiseHT.setEnabled(radioEuros.isSelected());
                DevisSQLComponent.this.textPourcentRemise.setEnabled(!radioEuros.isSelected());
            }
        });
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DevisSQLComponent.this.textPoidsTotal.setText(String.valueOf(DevisSQLComponent.this.table.getPoidsTotal()));
            }
        });
        this.addSQLObject(textObjet, "OBJET");
        this.addSQLObject(this.textPoidsTotal, "T_POIDS");
        this.addRequiredSQLObject(this.dateDevis, "DATE");
        this.addRequiredSQLObject(this.radioEtat, "ID_ETAT_DEVIS");
        this.addRequiredSQLObject(this.numeroUniqueDevis, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        comboClient.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Integer id;
                if (!DevisSQLComponent.this.isFilling() && (id = Integer.valueOf(comboClient.getWantedID())) > 1) {
                    SQLRow row = comboClient.getElement().getTable().getRow(id);
                    if (comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        DefaultGridBagConstraints.lockMinimumSize(comboCommercial);
        DefaultGridBagConstraints.lockMinimumSize(comboClient);
    }

    @Override
    public synchronized ValidState getValidState() {
        assert (SwingUtilities.isEventDispatchThread());
        return super.getValidState().and(this.validStateContact);
    }

    private JPanel createGestionSaisieRapport() {
        DefaultGridBagConstraints cTabSite = new DefaultGridBagConstraints();
        JPanel tabSite = new JPanel(new GridBagLayout());
        if (this.getTable().contains("RAPPORT_A_SAISIR")) {
            cTabSite.gridx = 0;
            ++cTabSite.gridy;
            cTabSite.gridheight = 1;
            cTabSite.fill = 2;
            cTabSite.weightx = 0.0;
            cTabSite.gridx = 0;
            cTabSite.gridwidth = 2;
            cTabSite.weightx = 0.0;
            JCheckBox boxAsaisir = new JCheckBox("Rapport \u00e0 saisir");
            tabSite.add((Component)boxAsaisir, cTabSite);
            JLabel labelRapport = new JLabel(this.getLabelFor("TYPE_RAPPORT"));
            cTabSite.gridx = 2;
            tabSite.add((Component)labelRapport, cTabSite);
            SQLTextCombo comboType = new SQLTextCombo();
            cTabSite.gridwidth = 0;
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            tabSite.add((Component)comboType, cTabSite);
            cTabSite.gridwidth = 1;
            cTabSite.gridx = 0;
            ++cTabSite.gridy;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)new JLabel(this.getLabelFor("NB_RAPPORT_A_SAISIR")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            JTextField fieldNbRapportASaisir = new JTextField(5);
            tabSite.add((Component)fieldNbRapportASaisir, cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)new JLabel(this.getLabelFor("DATE_DEMANDE_SAISIE")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 0.0;
            JDate dateDmdSaisie = new JDate();
            tabSite.add((Component)dateDmdSaisie, cTabSite);
            ++cTabSite.gridx;
            cTabSite.gridwidth = 2;
            cTabSite.weightx = 0.0;
            JCheckBox boxAcceptSaisie = new JCheckBox("Accept\u00e9 en saisie");
            tabSite.add((Component)boxAcceptSaisie, cTabSite);
            cTabSite.gridwidth = 1;
            ++cTabSite.gridy;
            cTabSite.gridx = 0;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)new JLabel(this.getLabelFor("NB_RAPPORT_SAISI")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            JTextField fieldNbRapportSaisi = new JTextField(5);
            tabSite.add((Component)fieldNbRapportSaisi, cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)new JLabel(this.getLabelFor("DATE_SAISIE")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 0.0;
            JDate dateSaisie = new JDate();
            tabSite.add((Component)dateSaisie, cTabSite);
            if (!UserRightsManager.getCurrentUserRights().haveRight("VOIR_DEVIS_4_SEMAINES")) {
                ++cTabSite.gridx;
                cTabSite.weightx = 0.0;
                tabSite.add((Component)new JLabel(this.getLabelFor("DATE_SAISIE_REELLE")), cTabSite);
                ++cTabSite.gridx;
                cTabSite.weightx = 0.0;
                JDate dateSaisieR = new JDate();
                tabSite.add((Component)dateSaisieR, cTabSite);
                this.addView(dateSaisieR, "DATE_SAISIE_REELLE");
            }
            ++cTabSite.gridy;
            cTabSite.weightx = 0.0;
            cTabSite.gridx = 0;
            tabSite.add((Component)new JLabel(this.getLabelFor("TEMPS_SAISIE")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            JTextField fieldTpsSaisi = new JTextField(5);
            tabSite.add((Component)fieldTpsSaisi, cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)new JLabel(this.getLabelFor("ID_USER_COMMON_SAISIE")), cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            SQLRequestComboBox boxUserSaisi = new SQLRequestComboBox();
            tabSite.add((Component)boxUserSaisi, cTabSite);
            this.addView(fieldNbRapportASaisir, "NB_RAPPORT_A_SAISIR");
            this.addView(fieldNbRapportSaisi, "NB_RAPPORT_SAISI");
            this.addView(dateDmdSaisie, "DATE_DEMANDE_SAISIE");
            this.addView(comboType, "TYPE_RAPPORT");
            this.addView(dateSaisie, "DATE_SAISIE");
            this.addView(boxAcceptSaisie, "ACCEPTE_EN_SAISIE");
            this.addView(boxAsaisir, "RAPPORT_A_SAISIR");
            this.addView(boxUserSaisi, "ID_USER_COMMON_SAISIE");
            this.addView(fieldTpsSaisi, "TEMPS_SAISIE");
        }
        return tabSite;
    }

    private JPanel createPanelDiff(final Type_Diff type) {
        DefaultGridBagConstraints cTabSite = new DefaultGridBagConstraints();
        JPanel tabSite = new JPanel(new GridBagLayout());
        cTabSite.weightx = 1.0;
        cTabSite.fill = 2;
        cTabSite.gridwidth = 2;
        String name = type.getName();
        final JCheckBox boxSiteDiff = new JCheckBox(this.getLabelFor(String.valueOf(name) + "_DIFF"));
        tabSite.add((Component)boxSiteDiff, cTabSite);
        this.addView(boxSiteDiff, String.valueOf(name) + "_DIFF");
        String fieldSiren = "SIREN_" + name;
        if (this.getTable().contains(fieldSiren)) {
            JLabel labelSrenSite = new JLabel(this.getLabelFor(fieldSiren));
            labelSrenSite.setHorizontalAlignment(4);
            cTabSite.gridwidth = 1;
            cTabSite.gridx = 2;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)labelSrenSite, cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            if (type == Type_Diff.SITE) {
                throw new IllegalArgumentException("Le siren n'est pas \u00e0 renseign\u00e9 pour le site");
            }
            JTextField siren = this.sirenDonneur;
            tabSite.add((Component)siren, cTabSite);
            this.addView(siren, fieldSiren);
            DefaultGridBagConstraints.lockMinimumSize(siren);
        }
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        cTabSite.fill = 2;
        cTabSite.gridwidth = 1;
        JLabel labelSiteDes = new JLabel(this.getLabelFor("DESIGNATION_" + name));
        labelSiteDes.setHorizontalAlignment(4);
        tabSite.add((Component)labelSiteDes, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField designation = type == Type_Diff.SITE ? this.desSite : this.desDonneur;
        tabSite.add((Component)designation, cTabSite);
        this.addView(designation, "DESIGNATION_" + name);
        DefaultGridBagConstraints.lockMinimumSize(designation);
        JLabel labelTelSite = new JLabel(this.getLabelFor("TEL_" + name));
        labelTelSite.setHorizontalAlignment(4);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelTelSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField tel = type == Type_Diff.SITE ? this.telSite : this.telDonneur;
        tabSite.add((Component)tel, cTabSite);
        this.addView(tel, "TEL_" + name);
        DefaultGridBagConstraints.lockMinimumSize(tel);
        JLabel labelSiteAdr = new JLabel(this.getLabelFor("ADRESSE_" + name));
        labelSiteAdr.setHorizontalAlignment(4);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelSiteAdr, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        ITextArea adresse = type == Type_Diff.SITE ? this.adrSite : this.adrDonneur;
        tabSite.add((Component)adresse, cTabSite);
        this.addView(adresse, "ADRESSE_" + name);
        DefaultGridBagConstraints.lockMinimumSize(adresse);
        JLabel labelTelPSite = new JLabel(this.getLabelFor("TEL_P_" + name));
        labelTelPSite.setHorizontalAlignment(4);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelTelPSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField telP = type == Type_Diff.SITE ? this.telPSite : this.telPDonneur;
        tabSite.add((Component)telP, cTabSite);
        this.addView(telP, "TEL_P_" + name);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        JLabel labelVilleAdr = new JLabel(this.getLabelFor("VILLE_" + name));
        labelVilleAdr.setHorizontalAlignment(4);
        tabSite.add((Component)labelVilleAdr, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        ITextComboVilleViewer ville = type == Type_Diff.SITE ? this.villeSite : this.villeDonneur;
        tabSite.add((Component)ville, cTabSite);
        this.addView((JComponent)ville, "VILLE_" + name);
        DefaultGridBagConstraints.lockMinimumSize((JComponent)ville);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        JLabel labelFaxSite = new JLabel(this.getLabelFor("FAX_" + name));
        labelFaxSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelFaxSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField fax = type == Type_Diff.SITE ? this.faxSite : this.faxDonneur;
        tabSite.add((Component)fax, cTabSite);
        this.addView(fax, "FAX_" + name);
        DefaultGridBagConstraints.lockMinimumSize(fax);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        JLabel labelContactSite = new JLabel(this.getLabelFor("CONTACT_" + name));
        labelContactSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelContactSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField contact = type == Type_Diff.SITE ? this.contactSite : this.contactDonneur;
        tabSite.add((Component)contact, cTabSite);
        this.addView(contact, "CONTACT_" + name);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        JLabel labelMailSite = new JLabel(this.getLabelFor("MAIL_" + name));
        labelMailSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelMailSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField mail = type == Type_Diff.SITE ? this.mailSite : this.mailDonneur;
        tabSite.add((Component)mail, cTabSite);
        this.addView(mail, "MAIL_" + name);
        boxSiteDiff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = boxSiteDiff.isSelected();
                DevisSQLComponent.this.setSiteEnabled(selected, type);
                if (!selected) {
                    DevisSQLComponent.this.clearFieldDiff(type);
                }
            }
        });
        return tabSite;
    }

    private void clearFieldDiff(Type_Diff type) {
        if (type == Type_Diff.SITE) {
            this.desSite.setText("");
            this.adrSite.setText("");
            this.villeSite.setValue(null);
            this.telPSite.setText("");
            this.telSite.setText("");
            this.mailSite.setText("");
            this.contactSite.setText("");
            this.faxSite.setText("");
        } else {
            this.sirenDonneur.setText("");
            this.desDonneur.setText("");
            this.adrDonneur.setText("");
            this.villeDonneur.setValue(null);
            this.telPDonneur.setText("");
            this.telDonneur.setText("");
            this.mailDonneur.setText("");
            this.contactDonneur.setText("");
            this.faxDonneur.setText("");
        }
    }

    private void setSiteEnabled(boolean b, Type_Diff type) {
        if (type == Type_Diff.SITE) {
            this.desSite.setEditable(b);
            this.adrSite.setEditable(b);
            this.villeSite.setEnabled(b);
            this.telPSite.setEditable(b);
            this.telSite.setEditable(b);
            this.mailSite.setEditable(b);
            this.contactSite.setEditable(b);
            this.faxSite.setEditable(b);
        } else {
            b = false;
            this.sirenDonneur.setEditable(b);
            this.desDonneur.setEditable(b);
            this.adrDonneur.setEditable(b);
            this.villeDonneur.setEnabled(b);
            this.telPDonneur.setEditable(b);
            this.telDonneur.setEditable(b);
            this.mailDonneur.setEditable(b);
            this.contactDonneur.setEditable(b);
            this.faxDonneur.setEditable(b);
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        System.err.println("Create defaults");
        this.setSiteEnabled(false, Type_Diff.DONNEUR_ORDRE);
        this.setSiteEnabled(false, Type_Diff.SITE);
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        if (this.getTable().getUndefinedID() == -1) {
            rowVals.put("ID_ETAT_DEVIS", 2);
        } else {
            SQLRowValues foreign = UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.getTable());
            if (foreign != null && !foreign.isUndefined() && !foreign.isForeignEmpty("ID_ETAT_DEVIS")) {
                rowVals.put("ID_ETAT_DEVIS", foreign.getForeignID("ID_ETAT_DEVIS"));
            } else {
                rowVals.put("ID_ETAT_DEVIS", 2);
            }
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_TTC", 0L);
        if (this.getTable().contains("ID_TAXE_PORT")) {
            SQLRow taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        if (this.getTable().getFieldsName().contains("DATE_VALIDITE")) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, 1);
            rowVals.put("DATE_VALIDITE", new Date(cal.getTimeInMillis()));
        }
        return rowVals;
    }

    private void calculPourcentage() {
        String remiseP = this.textPourcentRemise.getText().replace(',', '.');
        Long totalHT = this.fieldHT.getValue();
        Long remiseHT = this.textRemiseHT.getValue();
        totalHT = totalHT == null ? Long.valueOf(0L) : totalHT;
        remiseHT = remiseHT == null ? Long.valueOf(0L) : remiseHT;
        try {
            int valueRemise = Integer.valueOf(remiseP);
            long remise = (long)valueRemise * (totalHT + remiseHT) / 100L;
            if (remiseHT != remise) {
                this.textRemiseHT.setValue(remise);
            }
        }
        catch (NumberFormatException e) {
            ExceptionHandler.handle("Erreur durant le calcul de la remise", e);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int idDevis;
        String num;
        int attempt = 0;
        if (!this.numeroUniqueDevis.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.dateDevis.getDate());
                this.numeroUniqueDevis.setText(num);
                ++attempt;
                if (this.numeroUniqueDevis.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.numeroUniqueDevis.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idDevis = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            idDevis = super.insert(order);
            this.table.updateField("ID_DEVIS", idDevis);
            this.table.createArticle(idDevis, this.getElement());
            try {
                DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(idDevis));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
            }
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.numeroUniqueDevis.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                    }
                });
            }
        }
        return idDevis;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues().deepCopy();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (r != null) {
            this.table.insertFrom("ID_DEVIS", r.getID());
            if (this.getTable().contains("SITE_DIFF")) {
                this.setSiteEnabled(r.getBoolean("SITE_DIFF"), Type_Diff.SITE);
            }
            if (this.getTable().contains("DONNEUR_DIFF")) {
                this.setSiteEnabled(r.getBoolean("DONNEUR_DIFF"), Type_Diff.DONNEUR_ORDRE);
            }
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueDevis.checkValidation()) {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_DEVIS", this.getSelectedID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        try {
            DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(this.getSelectedID()));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
        }
    }

    public void loadDevisExistant(int idDevis) {
        Collection myListItem;
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLRow row = devis.getTable().getRow(idDevis);
            SQLRowValues rowVals = new SQLRowValues(devis.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
            this.select(rowVals);
        }
        if ((myListItem = devis.getTable().getRow(idDevis).getReferentRows(devisElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.table.getModel().addRow(rowVals);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }

    private static enum Type_Diff {
        SITE("SITE"),
        DONNEUR_ORDRE("DONNEUR");

        private final String name;

        private Type_Diff(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

