/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class ArticleManager {
    private static ArticleManager instance;
    private List cacheCode;
    private final SQLTable table = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("ARTICLE");

    private ArticleManager() {
    }

    public static synchronized ArticleManager getInstance() {
        if (instance == null) {
            instance = new ArticleManager();
        }
        return instance;
    }

    public void clearCache() {
        this.cacheCode = null;
    }

    public void insertOrUpdate(String code, String nom, long prixAchatHT) {
        if (this.cacheCode == null) {
            this.fillCache();
        }
        code = code.toLowerCase().trim();
        nom = nom.toLowerCase().trim();
        SQLRowValues rowParDefaut = new SQLRowValues(this.table);
        boolean update = false;
        int i = 0;
        while (i < this.cacheCode.size()) {
            Map m = (Map)this.cacheCode.get(i);
            String c = (String)m.get("CODE_BARRE");
            String n = (String)m.get("NOM");
            if (code.length() > 0 && c.toLowerCase().trim().equals(code) || n.toLowerCase().trim().equals(nom)) {
                int idAUpdater = ((Number)m.get("ID")).intValue();
                rowParDefaut.loadAbsolutelyAll(this.table.getRow(idAUpdater));
                update = true;
                break;
            }
            ++i;
        }
        if (!update) {
            Configuration.getInstance().getDirectory().getElement(this.table).loadAllSafe(rowParDefaut, this.table.getRow(this.table.getUndefinedID()));
            rowParDefaut.put("NOM", nom);
            rowParDefaut.put("CODE_BARRE", code);
        }
        rowParDefaut.put("PA_HT", new Long(prixAchatHT));
        rowParDefaut.put("PV_HT", new Long(this.prixDeVente(prixAchatHT)));
        try {
            if (update) {
                rowParDefaut.update();
            } else {
                rowParDefaut.insert();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public long prixDeVente(long prixAchatHT) {
        double pVTTC = (double)prixAchatHT * 1.6;
        long pi = Math.round(pVTTC);
        double pV = (double)(pi * 100L) / 1.196;
        return Math.round(pV);
    }

    private void fillCache() {
        this.cacheCode = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getDataSource().execute("SELECT ID,NOM,CODE_BARRE FROM ARTICLE");
    }
}

