/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class TicketPrinterConfigPanel
extends JPanel {
    private final JComboBox comboType = new JComboBox<String>(new String[]{"Imprimante standard ESCP", "Imprimante s\u00e9rie ESCP", "Imprimante JavaPOS"});
    private final JSpinner printWidth;
    private final JSpinner copyCountSpinner;
    private JLabel labelPort;
    private final JTextField textPort;
    private final JButton selectPortButton;
    private final JTextField textLibJPOS;
    private TicketPrinterConfiguration configuration;

    public TicketPrinterConfigPanel() {
        this.comboType.setSelectedIndex(0);
        this.textPort = new JTextField(10);
        this.selectPortButton = new JButton("S\u00e9lectionner");
        this.textLibJPOS = new JTextField(24);
        this.textLibJPOS.setEnabled(false);
        this.printWidth = new JSpinner(new SpinnerNumberModel(42, 10, 320, 1));
        this.printWidth.setOpaque(false);
        this.copyCountSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.copyCountSpinner.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Largeur (en caract\u00e8res)", 4), c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.printWidth, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Nombre de tickets", 4), c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.copyCountSpinner, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Type", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.comboType, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.labelPort = new JLabel("Nom", 4);
        this.add((Component)this.labelPort, c);
        ++c.gridx;
        this.add((Component)this.textPort, c);
        ++c.gridx;
        this.selectPortButton.setOpaque(false);
        this.add((Component)this.selectPortButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Dossier JavaPOS", 4), c);
        ++c.gridx;
        this.add((Component)this.textLibJPOS, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 0;
        JButton buttonPrint = new JButton("Imprimer un ticket de test");
        buttonPrint.setOpaque(false);
        this.add((Component)buttonPrint, c);
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketPrinterConfigPanel.this.textPort.getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(TicketPrinterConfigPanel.this, "Port/Imprimante manquant");
                    return;
                }
                TicketPrinterConfigPanel.this.commitValues();
                TicketPrinter prt = TicketPrinterConfigPanel.this.configuration.createTicketPrinter();
                try {
                    String str = "";
                    int w = ((Number)TicketPrinterConfigPanel.this.printWidth.getValue()).intValue();
                    int i = 0;
                    while (i < w) {
                        str = String.valueOf(str) + i % 10;
                        ++i;
                    }
                    prt.addToBuffer("Test");
                    prt.addToBuffer(TicketPrinterConfigPanel.this.configuration.getType());
                    prt.addToBuffer(TicketPrinterConfigPanel.this.configuration.getName());
                    prt.addToBuffer("" + w);
                    prt.addToBuffer(str);
                    prt.addToBuffer("OK");
                    prt.printBuffer();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur d'impression", e1);
                }
            }
        });
        this.selectPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                String title;
                ArrayList<String> choices = new ArrayList<String>();
                if (TicketPrinterConfigPanel.this.comboType.getSelectedIndex() == 0) {
                    PrintService[] printServices;
                    PrintService[] printServiceArray = printServices = PrintServiceLookup.lookupPrintServices(null, null);
                    int n = printServices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintService printer = printServiceArray[n2];
                        choices.add(printer.getName());
                        ++n2;
                    }
                    title = "Imprimante ticket";
                    message = "Choisissez l'imprimante ticket \u00e0 utiliser";
                } else if (TicketPrinterConfigPanel.this.comboType.getSelectedIndex() == 1) {
                    choices.addAll(ESCSerialPrinter.getSerialPortNames());
                    title = "Port s\u00e9rie";
                    message = "Choisissez le port s\u00e9rie li\u00e9 \u00e0 l'imprimante ticket";
                } else {
                    return;
                }
                if (choices.isEmpty()) {
                    return;
                }
                String s = (String)JOptionPane.showInputDialog(TicketPrinterConfigPanel.this, message, title, -1, null, choices.toArray(), choices.get(0));
                if (s != null && s.length() > 0) {
                    TicketPrinterConfigPanel.this.textPort.setText(s);
                }
            }
        });
        this.comboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketPrinterConfigPanel.this.commitValues();
                TicketPrinterConfigPanel.this.setConfiguration(TicketPrinterConfigPanel.this.configuration);
            }
        });
    }

    public void setConfiguration(TicketPrinterConfiguration conf) {
        this.configuration = conf;
        this.printWidth.setValue(conf.getTicketWidth());
        this.copyCountSpinner.setValue(conf.getCopyCount());
        this.textPort.setText(conf.getName());
        this.textLibJPOS.setText(conf.getFolder());
        if ("serial".equals(conf.getType())) {
            this.comboType.setSelectedIndex(1);
            this.labelPort.setText("Port s\u00e9rie");
            this.textLibJPOS.setEnabled(false);
        } else if ("jpos".equals(conf.getType())) {
            this.comboType.setSelectedIndex(2);
            this.labelPort.setText("Imprimante JavaPOS");
            this.textLibJPOS.setEnabled(true);
        } else {
            this.comboType.setSelectedIndex(0);
            this.labelPort.setText("Nom de l'imprimante");
            this.textLibJPOS.setEnabled(false);
        }
    }

    public void commitValues() {
        if (this.comboType.getSelectedIndex() == 1) {
            this.configuration.setType("serial");
        } else if (this.comboType.getSelectedIndex() == 2) {
            this.configuration.setType("jpos");
        } else {
            this.configuration.setType("std");
        }
        this.configuration.setTicketWidth(((Number)this.printWidth.getValue()).intValue());
        this.configuration.setCopyCount(((Number)this.copyCountSpinner.getValue()).intValue());
        this.configuration.setName(this.textPort.getText());
        this.configuration.setFolder(this.textLibJPOS.getText());
    }
}

