/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.RoundingMode;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.DetailClientPanel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;

public class ListeDesClientsPanel
extends JPanel {
    private ScrollableList clientList;
    private DefaultListModel ticketLlistModel;

    ListeDesClientsPanel(final CaisseFrame caisseFrame) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        StatusBar p = new StatusBar();
        p.setTitle("Liste des clients");
        p.setLayout(new FlowLayout(2));
        POSButton bBack = new POSButton("Fermer");
        p.add(bBack);
        this.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 2;
        this.ticketLlistModel = new DefaultListModel();
        this.ticketLlistModel.addAll(new Vector<Client>(POSConfiguration.getInstance().allClients()));
        final Font f = new Font("Arial", 0, 24);
        this.clientList = new ScrollableList(this.ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Client client = (Client)object;
                String label = client.getFullName();
                int soldeInCents = client.getSolde().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                String euro = String.valueOf(TicketCellRenderer.centsToString(soldeInCents)) + "\u20ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                g.drawString(label, 10, posY + 24);
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 24);
                String addr = client.getAddr();
                if (addr != null) {
                    g.drawString(addr, 10, posY + 48);
                }
            }
        };
        this.add((Component)this.clientList, c);
        c.fill = 1;
        ++c.gridx;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        final DetailClientPanel detailClientPanel = new DetailClientPanel(caisseFrame);
        this.add((Component)detailClientPanel, c);
        this.clientList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Client selectedValue = (Client)ListeDesClientsPanel.this.clientList.getSelectedValue();
                detailClientPanel.setSelectedClient(selectedValue);
            }
        });
        bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.showCaisse();
            }
        });
    }

    public void setSelectedClient(Object selectedValue) {
        this.clientList.setSelectedValue(selectedValue, true);
    }
}

