/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.component.TransfertGroupSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.order.component.CommandeClientSQLComponent;
import org.openconcerto.erp.core.sales.order.element.StockCommande;
import org.openconcerto.erp.core.sales.order.element.TransfertCommandeAutoUtils;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.cc.ITransformer;

public class CommandeClientSQLElement
extends ComptaSQLConfElement {
    public CommandeClientSQLElement() {
        super("COMMANDE_CLIENT", "une commande client", "commandes clients");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ORDER_PACKAGING_MANAGEMENT, true)) {
            EtatCommandeClient[] etatCommandeClientArray = EtatCommandeClient.values();
            int n = etatCommandeClientArray.length;
            int n2 = 0;
            while (n2 < n) {
                final EtatCommandeClient etat = etatCommandeClientArray[n2];
                RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction(etat.getTranslation()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommandeClientSQLElement.this.changeStateOfRows(IListe.get(e).getSelectedRows(), etat);
                    }
                }, false);
                action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
                action.setPath(Arrays.asList("Etat", "Etat", "Etat"));
                this.getRowActions().add(action);
                ++n2;
            }
            RowAction.PredicateRowAction actionTransfertBL = new RowAction.PredicateRowAction(new AbstractAction("Transfert automatique vers BL"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransfertCommandeAutoUtils transfert = new TransfertCommandeAutoUtils(CommandeClientSQLElement.this.getTable());
                    transfert.transfertMultiBL(IListe.get(e).getSelectedRows());
                }
            }, false);
            actionTransfertBL.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(actionTransfertBL);
            RowAction.PredicateRowAction actionStock = new RowAction.PredicateRowAction(new AbstractAction("V\u00e9rification des stocks"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread("Check Commande To Ship"){

                        @Override
                        public void run() {
                            try {
                                CommandeClientSQLElement.this.checkCommandeToShip();
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle("Erreur pendant la v\u00e9rification du statut des commandes", e);
                            }
                        }
                    }.start();
                }
            }, false);
            actionStock.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(actionStock);
            RowAction.PredicateRowAction actionFacture = new RowAction.PredicateRowAction(new AbstractAction("Transfert automatique en facture"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransfertCommandeAutoUtils transfert = new TransfertCommandeAutoUtils(CommandeClientSQLElement.this.getTable());
                    transfert.transfertFacture(IListe.get(e).getSelectedRows());
                }
            }, false);
            actionFacture.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(actionFacture);
        }
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeClientSQLElement.this.transfertBonLivraisonClient(IListe.get(e).getSelectedRows());
            }
        }, true, "sales.order.create.deliverynote");
        RowAction factureAction = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeClientSQLElement.this.transfertFactureClient(IListe.get(e).getSelectedRows());
            }
        }, true, "sales.order.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty()) {
                    return false;
                }
                if (selection.size() > 1) {
                    return true;
                }
                BigDecimal d = CommandeClientSQLElement.this.getAvancement(selection.get(0));
                return d.signum() == 0;
            }
        };
        RowAction acompteAction = new RowAction(new AbstractAction("Cr\u00e9er une facture interm\u00e9diaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeClientSQLElement.this.transfertAcompteClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.account"){
            BigDecimal cent;
            {
                this.cent = BigDecimal.ONE.movePointRight(2);
            }

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty() || selection.size() > 1) {
                    return false;
                }
                BigDecimal d = CommandeClientSQLElement.this.getAvancement(selection.get(0));
                return NumberUtils.compare(d, this.cent) != 0;
            }
        };
        RowAction soldeAction = new RowAction(new AbstractAction("Facturer le solde"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeClientSQLElement.this.transfertSoldeClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.account.solde"){
            BigDecimal cent;
            {
                this.cent = BigDecimal.ONE.movePointRight(2);
            }

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty() || selection.size() > 1) {
                    return false;
                }
                BigDecimal d = CommandeClientSQLElement.this.getAvancement(selection.get(0));
                return NumberUtils.compare(d, this.cent) != 0 && NumberUtils.compare(d, BigDecimal.ZERO) != 0;
            }
        };
        RowAction.PredicateRowAction cmdAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int selectedId = IListe.get(e).getSelectedId();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
                        elt.transfertCommande(selectedId, true);
                    }
                });
            }
        }, false, "sales.order.create.supplier.order");
        cmdAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(CommandeClientXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        allowedActions.add(bonAction);
        allowedActions.add(factureAction);
        allowedActions.add(acompteAction);
        allowedActions.add(soldeAction);
        allowedActions.add(cmdAction);
        allowedActions.addAll(mouseSheetXmlListeListener.getRowActions());
        this.getRowActions().addAll(allowedActions);
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_FACT")) {
            links.get("ID_ADRESSE_FACT").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    public SQLRow getNextCommandeToPrepare() {
        SQLTable tableCmd = this.getTable();
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableCmd.getKey());
        sel.addSelect(tableCmd.getField("NUMERO"));
        sel.addSelect(tableCmd.getField("DATE"));
        sel.addSelect(tableCmd.getField("T_HT"));
        sel.addSelect(tableCmd.getField("T_TVA"));
        sel.addSelect(tableCmd.getField("T_TTC"));
        sel.addSelect(tableCmd.getField("PORT_HT"));
        sel.addSelect(tableCmd.getField("REMISE_HT"));
        sel.addSelect(tableCmd.getField("ID_TAXE_PORT"));
        sel.addSelect(tableCmd.getField("ID_CLIENT"));
        Where w = new Where((FieldRef)tableCmd.getField("ETAT_COMMANDE"), "=", EtatCommandeClient.A_PREPARER.getId());
        sel.setWhere(w);
        sel.clearOrder();
        sel.addFieldOrder(sel.getAlias(tableCmd.getField("DATE")));
        sel.addFieldOrder(sel.getAlias(tableCmd.getField("T_HT")));
        List<SQLRow> result = SQLRowListRSH.execute(sel);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public int getNbCommandeAPreparer() {
        SQLTable tableCmd = this.getTable();
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableCmd.getKey(), "COUNT");
        Where w = new Where((FieldRef)tableCmd.getField("ETAT_COMMANDE"), "=", EtatCommandeClient.A_PREPARER.getId());
        sel.setWhere(w);
        Object r = this.getTable().getDBSystemRoot().getDataSource().executeScalar(sel.asString());
        int nb = 0;
        if (r != null) {
            nb = ((Number)r).intValue();
        }
        return nb;
    }

    public void checkCommandeToShip() throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException, IOException {
                final SQLTable tableCmd = CommandeClientSQLElement.this.getTable();
                SQLRowValues rowVals = new SQLRowValues(tableCmd);
                rowVals.put(tableCmd.getKey().getName(), null);
                rowVals.put("NUMERO", null);
                SQLTable tableCmdElt = tableCmd.getTable("COMMANDE_CLIENT_ELEMENT");
                SQLRowValues rowValsElt = new SQLRowValues(tableCmdElt);
                rowValsElt.put("QTE", null);
                rowValsElt.put("QTE_UNITAIRE", null);
                rowValsElt.put("ID_COMMANDE_CLIENT", (Object)rowVals);
                SQLRowValues rowValsArt = new SQLRowValues(tableCmd.getTable("ARTICLE"));
                rowValsArt.putRowValues("ID_STOCK").putNulls("QTE_REEL", "QTE_TH");
                rowValsElt.put("ID_ARTICLE", (Object)rowValsArt);
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
                fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(input.getAlias(tableCmd).getField("ETAT_COMMANDE"), "=", EtatCommandeClient.A_PREPARER.getId());
                        w = w.or(new Where(input.getAlias(tableCmd).getField("ETAT_COMMANDE"), "=", EtatCommandeClient.RUPTURE.getId()));
                        input.setWhere(w);
                        input.clearOrder();
                        input.addFieldOrder(input.getAlias(tableCmd.getField("ETAT_COMMANDE")));
                        input.addFieldOrder(input.getAlias(tableCmd.getField("T_HT")));
                        System.err.println(input.asString());
                        return input;
                    }
                });
                List<SQLRowValues> result = fetcher.fetch();
                ArrayList<Integer> cmdStockOK = new ArrayList<Integer>();
                ArrayList<Integer> cmdNoStock = new ArrayList<Integer>();
                StockCommande stockGlobalUsed = new StockCommande();
                int i = result.size() - 1;
                while (i >= 0) {
                    SQLRowValues sqlRowValues = result.get(i);
                    boolean inStock = true;
                    StockCommande stockCmd = new StockCommande();
                    for (SQLRowValues item : sqlRowValues.getReferentRows(tableCmdElt)) {
                        int foreignID = item.getForeignID("ID_ARTICLE");
                        BigDecimal stock = BigDecimal.ZERO;
                        if (!item.getForeign("ID_ARTICLE").isForeignEmpty("ID_STOCK")) {
                            stock = new BigDecimal(item.getForeign("ID_ARTICLE").getForeign("ID_STOCK").getFloat("QTE_REEL"));
                        }
                        stock = stock.subtract(stockCmd.getQty(foreignID)).subtract(stockGlobalUsed.getQty(foreignID));
                        BigDecimal needQty = item.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(item.getInt("QTE")), DecimalUtils.HIGH_PRECISION);
                        stockCmd.addQty(foreignID, needQty);
                        boolean bl = inStock = CompareUtils.compare(stock, needQty) >= 0;
                        if (!inStock) break;
                    }
                    if (inStock) {
                        Map<Integer, BigDecimal> m = stockCmd.getMap();
                        for (Integer id : m.keySet()) {
                            stockGlobalUsed.addQty(id, m.get(id));
                        }
                        cmdStockOK.add(sqlRowValues.getID());
                    } else {
                        cmdNoStock.add(sqlRowValues.getID());
                    }
                    --i;
                }
                ArrayList<String> reqs = new ArrayList<String>(2);
                if (cmdStockOK.size() > 0) {
                    UpdateBuilder builderStockOK = new UpdateBuilder(tableCmd);
                    builderStockOK.setObject("ETAT_COMMANDE", (Object)EtatCommandeClient.A_PREPARER.getId());
                    builderStockOK.setWhere(new Where(CommandeClientSQLElement.this.getTable().getKey(), cmdStockOK));
                    reqs.add(builderStockOK.asString());
                }
                if (cmdNoStock.size() > 0) {
                    UpdateBuilder builderNoStock = new UpdateBuilder(tableCmd);
                    builderNoStock.setObject("ETAT_COMMANDE", (Object)EtatCommandeClient.RUPTURE.getId());
                    builderNoStock.setWhere(new Where(CommandeClientSQLElement.this.getTable().getKey(), cmdNoStock));
                    reqs.add(builderNoStock.asString());
                }
                if (reqs.size() > 0) {
                    ArrayList<Object> handlers = new ArrayList<Object>(reqs.size());
                    for (String s : reqs) {
                        handlers.add(null);
                    }
                    SQLUtils.executeMultiple(tableCmd.getDBSystemRoot(), reqs, handlers);
                    tableCmd.fireTableModified(-1);
                }
                return null;
            }
        });
    }

    private void changeStateOfRows(List<SQLRowValues> l, EtatCommandeClient etat) {
        ArrayList<Integer> ids = new ArrayList<Integer>(l.size());
        for (SQLRowValues sqlRowValues : l) {
            ids.add(sqlRowValues.getID());
        }
        UpdateBuilder builder = new UpdateBuilder(this.getTable());
        builder.setObject("ETAT_COMMANDE", (Object)etat.getId());
        builder.setWhere(new Where(this.getTable().getKey(), ids));
        this.getTable().getDBSystemRoot().getDataSource().execute(builder.asString());
        this.getTable().fireTableModified(-1);
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        if (this.getTable().contains("DATE_LIVRAISON_PREV")) {
            l.add("DATE_LIVRAISON_PREV");
        }
        l.add("ID_CLIENT");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("NOM");
        l.add("INFOS");
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ORDER_PACKAGING_MANAGEMENT, true)) {
            l.add("NUMERO_EXPEDITION");
            l.add("ETAT_COMMANDE");
        }
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("ID_DEVIS");
        return s;
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource source) {
        SQLTableModelColumn col;
        super._initTableSource(source);
        source.init();
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ORDER_PACKAGING_MANAGEMENT, true) && (col = source.getColumn(this.getTable().getField("ETAT_COMMANDE"))) != null) {
            col.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value != null) {
                        EtatCommandeClient fromID = EtatCommandeClient.fromID((Integer)value);
                        if (fromID != null) {
                            comp.setText(fromID.getTranslation());
                        } else {
                            comp.setText("");
                        }
                    }
                    return comp;
                }
            });
        }
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeClientSQLComponent();
    }

    public void transfertCommande(int commandeID, boolean useCommandeEnCours) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        SQLRow rowCmd = this.getTable().getRow(commandeID);
        Collection rows = rowCmd.getReferentRows(elt.getTable());
        ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
        for (SQLRow sqlRow : rows) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
            if (rowArticleFind == null || rowArticleFind.isUndefined()) continue;
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
            rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
            rowValsElt.put("QTE", sqlRow.getObject("QTE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE")), DecimalUtils.HIGH_PRECISION));
            rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
            rowValsElt.put("ID_DEVISE", rowCmd.getForeignRow("ID_TARIF").getForeignID("ID_DEVISE"));
            map.add(rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        MouvementStockSQLElement.createCommandeF(map, rowCmd.getForeignRow("ID_TARIF").getForeignRow("ID_DEVISE"), String.valueOf(rowCmd.getString("NUMERO")) + " - " + rowCmd.getString("NOM"), useCommandeEnCours);
    }

    public void transfertBonLivraisonClient(final List<SQLRowValues> rows) {
        BonDeLivraisonSQLComponent comp = (BonDeLivraisonSQLComponent)TransfertBaseSQLComponent.openTransfertFrame(rows, "BON_DE_LIVRAISON").getSQLComponent();
        final SQLTable tableElt = comp.getElement().getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLRowValues rowVals = new SQLRowValues(tableElt);
        rowVals.put("QTE_UNITAIRE", null);
        rowVals.put("QTE", null);
        rowVals.put("QTE_LIVREE", null);
        rowVals.put("ID_ARTICLE", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                ArrayList<Integer> ids = new ArrayList<Integer>(rows.size());
                for (SQLRowValues sqlRowValues : rows) {
                    ids.add(sqlRowValues.getID());
                }
                SQLSelectJoin joinBR = input.addJoin("RIGHT", tableElt.getTable("BON_DE_LIVRAISON_ELEMENT").getField("ID_BON_DE_LIVRAISON"));
                SQLSelectJoin joinTR = input.addBackwardJoin("RIGHT", tableElt.getTable("TR_COMMANDE_CLIENT").getField("ID_BON_DE_LIVRAISON"), joinBR.getJoinedTable().getAlias());
                joinTR.setWhere(new Where(joinTR.getJoinedTable().getField("ID_COMMANDE_CLIENT"), ids));
                System.err.println(input.asString());
                return input;
            }
        });
        comp.loadQuantity(fetcher.fetch());
    }

    public EditFrame transfertFactureClient(List<SQLRowValues> rows) {
        return TransfertBaseSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE");
    }

    public EditFrame transfertAcompteClient(List<SQLRowValues> rows) {
        return TransfertGroupSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE", "sales.invoice.partial");
    }

    public EditFrame transfertSoldeClient(List<SQLRowValues> rows) {
        return TransfertGroupSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE", "sales.invoice.partial.balance");
    }

    public BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_COMMANDE_CLIENT"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            Long l = rowFact.getLong("T_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }
}

