/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.finance.payment.element.SDDMessageSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.erp.core.sales.invoice.ui.ListeFactureRenderer;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.i18n.Grammar_fr;

public class ListeDesVentesPanel
extends JPanel {
    private ListeGestCommEltPanel listeFact;
    private JLabelBold textField = new JLabelBold("0");
    private JLabelBold textField2 = new JLabelBold("0");

    public ListeDesVentesPanel() {
        SQLElement elementVF;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JTabbedPane tabbedPane = new JTabbedPane();
        SQLElement eltFacture = elementVF = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLTableModelSourceOnline src = eltFacture.getTableSource(true);
        Where wPrev = new Where((FieldRef)eltFacture.getTable().getField("PREVISIONNELLE"), "=", (Object)Boolean.FALSE);
        if (src.getReq().getWhere() != null) {
            wPrev = wPrev.and(src.getReq().getWhere());
        }
        src.getReq().setWhere(wPrev);
        ListeFactureRenderer rend = new ListeFactureRenderer();
        for (SQLTableModelColumn column : src.getColumns()) {
            if (column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) {
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
            if (column.getName().startsWith("Avancement")) continue;
            column.setRenderer(rend);
        }
        SQLTableModelColumn dateEnvoiCol = src.getColumn(eltFacture.getTable().getField("DATE_ENVOI"));
        ((SQLTableModelColumnPath)dateEnvoiCol).setEditable(true);
        SQLTableModelColumn dateReglCol = src.getColumn(eltFacture.getTable().getField("DATE_REGLEMENT"));
        if (dateReglCol != null) {
            ((SQLTableModelColumnPath)dateReglCol).setEditable(true);
        }
        dateEnvoiCol.setColumnInstaller(new IClosure<TableColumn>(){

            @Override
            public void executeChecked(TableColumn columnDateEnvoi) {
                TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
                cellEditor.setAllowNull(true);
                columnDateEnvoi.setCellEditor(cellEditor);
                columnDateEnvoi.setCellRenderer(new DateEnvoiRenderer());
            }
        });
        if (dateReglCol != null) {
            dateReglCol.setColumnInstaller(new IClosure<TableColumn>(){

                @Override
                public void executeChecked(TableColumn columnDateReglement) {
                    TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
                    cellEditor.setAllowNull(true);
                    columnDateReglement.setCellEditor(cellEditor);
                    columnDateReglement.setCellRenderer(new DateEnvoiRenderer());
                }
            });
        }
        src.getColumns().add(new SQLTableModelColumnPath(new FieldPath((Path)new Path(eltFacture.getTable()).addForeignField("ID_SDD_MESSAGE"), "MessageIdentification")));
        this.listeFact = new ListeGestCommEltPanel(eltFacture, new IListe(src), true);
        final SDDMessageSQLElement sepaMsgElem = eltFacture.getDirectory().getElement(SDDMessageSQLElement.class);
        final String aMessageLabel = sepaMsgElem.getName().getVariant(Grammar_fr.INDEFINITE_ARTICLE_SINGULAR);
        this.listeFact.getListe().addIListeAction(new RowAction.PredicateRowAction((Action)new AbstractAction("G\u00e9n\u00e9rer " + aMessageLabel, null){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe l = IListe.get(e);
                final List<Integer> selectedIDs = l.getSelection().getSelectedIDs();
                new SwingWorker<SDDMessageSQLElement.GenerationResult, Object>(){

                    @Override
                    protected SDDMessageSQLElement.GenerationResult doInBackground() throws Exception {
                        return sepaMsgElem.generateXML(selectedIDs);
                    }

                    @Override
                    protected void done() {
                        SDDMessageSQLElement.GenerationResult genRes;
                        try {
                            genRes = (SDDMessageSQLElement.GenerationResult)this.get();
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(l, "Impossible de g\u00e9n\u00e9rer " + aMessageLabel, e);
                            return;
                        }
                        int includedInvoicesCount = genRes.getIncludedInvoicesCount();
                        HashMap<String, Object> tmMap = new HashMap<String, Object>();
                        tmMap.put("msgElem", sepaMsgElem.getName());
                        tmMap.put("invoiceElem", elementVF.getName());
                        tmMap.put("invoiceElemCount", includedInvoicesCount);
                        if (genRes.getDDInvoicesWithoutMessage().isEmpty()) {
                            JOptionPane.showMessageDialog(l, TM.getTM().trM("sddMessage.generation.noneNeeded", tmMap));
                        } else if (genRes.getIgnoredInvoices().isEmpty()) {
                            JOptionPane.showMessageDialog(l, TM.getTM().trM("sddMessage.generation.noneIgnored", tmMap));
                        } else {
                            int futureCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.TOO_FAR_IN_FUTURE)).size();
                            int duplicateCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.DUPLICATE_MANDATE)).size();
                            int missingInfoCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.MISSING_INFO)).size();
                            tmMap.put("futureCount", futureCount);
                            tmMap.put("duplicateCount", duplicateCount);
                            tmMap.put("missingInfoCount", missingInfoCount);
                            StringBuilder msg = new StringBuilder(256);
                            msg.append(TM.getTM().trM("sddMessage.generation.someIgnored", tmMap));
                            msg.append('\n');
                            if (futureCount > 0) {
                                msg.append("- ");
                                msg.append(TM.getTM().trM("sddMessage.generation.someIgnored.future", tmMap));
                            }
                            if (duplicateCount > 0) {
                                msg.append("- ");
                                msg.append(TM.getTM().trM("sddMessage.generation.someIgnored.duplicateMandate", tmMap));
                            }
                            if (missingInfoCount > 0) {
                                msg.append("- ");
                                msg.append(TM.getTM().trM("sddMessage.generation.someIgnored.missingInfo", tmMap));
                            }
                            int messageType = duplicateCount == 0 ? 2 : 0;
                            JOptionPane.showMessageDialog(l, msg.toString(), null, messageType);
                        }
                        if (genRes.getInsertedMessage() != null) {
                            sepaMsgElem.exportXML(l, Collections.singletonList(genRes.getInsertedMessage()));
                        }
                    }
                }.execute();
            }
        }, false, true).setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate()));
        this.listeFact.setOpaque(false);
        this.listeFact.getListe().setModificationAllowed(true);
        JTable tableFact = this.listeFact.getListe().getJTable();
        SQLTableModelColumn numeroCol = src.getColumn(eltFacture.getTable().getField("NUMERO"));
        ((TableSorter)tableFact.getModel()).setSortingStatus(src.getColumns().indexOf(numeroCol), 1);
        JPanel panelFacture = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFacture = new DefaultGridBagConstraints();
        ++cFacture.gridy;
        cFacture.gridx = 0;
        cFacture.weighty = 1.0;
        cFacture.weightx = 1.0;
        cFacture.gridwidth = 0;
        cFacture.fill = 1;
        panelFacture.add((Component)this.listeFact, cFacture);
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        if (this.listeFact.getListe().getSource().getColumn(eltFacture.getTable().getField("T_HA")) != null) {
            l.add(eltFacture.getTable().getField("T_HA"));
        }
        l.add(eltFacture.getTable().getField("T_HT"));
        l.add(eltFacture.getTable().getField("T_TTC"));
        IListTotalPanel total = new IListTotalPanel(this.listeFact.getListe(), l);
        cFacture.weighty = 0.0;
        cFacture.fill = 0;
        ++cFacture.gridy;
        cFacture.anchor = 13;
        total.setOpaque(false);
        panelFacture.add((Component)total, cFacture);
        IListFilterDatePanel filterDate = new IListFilterDatePanel(this.listeFact.getListe(), eltFacture.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cFacture.weighty = 0.0;
        cFacture.fill = 2;
        ++cFacture.gridy;
        filterDate.setOpaque(false);
        panelFacture.add((Component)filterDate, cFacture);
        tabbedPane.add("Ventes avec facture", panelFacture);
        RowAction.PredicateRowAction actionRegle = new RowAction.PredicateRowAction(new AbstractAction("Facture r\u00e9gl\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                    SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                    rowVals.put("DATE_REGLEMENT", new Date());
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Modification impossible", e1);
                    }
                }
            }
        }, true);
        actionRegle.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.listeFact.getListe().addIListeAction(actionRegle);
        RowAction.PredicateRowAction actionEnvoye = new RowAction.PredicateRowAction(new AbstractAction("Facture envoy\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                    SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                    rowVals.put("DATE_ENVOI", new Date());
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Modification impossible", e1);
                    }
                }
            }
        }, true);
        actionEnvoye.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.listeFact.getListe().addIListeAction(actionEnvoye);
        ListeViewPanel panelTicket = new ListeViewPanel(Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE")){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonModifier) {
                    new PanelFrame(new TextAreaTicketPanel(this.getListe().fetchSelectedRow()), "Ticket").setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        cc.fill = 1;
        panel.add((Component)panelTicket, cc);
        ArrayList<SQLField> l2 = new ArrayList<SQLField>();
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_HT"));
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_TTC"));
        IListTotalPanel total2 = new IListTotalPanel(panelTicket.getListe(), l2);
        cc.weighty = 0.0;
        cc.fill = 0;
        ++cc.gridy;
        cc.anchor = 13;
        total2.setOpaque(false);
        panel.add((Component)total2, cc);
        IListFilterDatePanel filterDate2 = new IListFilterDatePanel(panelTicket.getListe(), panelTicket.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc.weighty = 0.0;
        cc.fill = 2;
        ++cc.gridy;
        filterDate2.setOpaque(false);
        panel.add((Component)filterDate2, cc);
        tabbedPane.add("Ventes caisse", panel);
        ListeGestCommEltPanel listeVC = new ListeGestCommEltPanel(Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_COMPTOIR"), true);
        listeVC.getListe().setModificationAllowed(false);
        listeVC.setOpaque(false);
        JTable table = listeVC.getListe().getJTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumnClass(i) == Long.class || table.getColumnClass(i) == BigInteger.class) {
                table.getColumnModel().getColumn(i).setCellRenderer(rend);
            }
            ++i;
        }
        JPanel panelComptoir = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cc2 = new DefaultGridBagConstraints();
        cc2.weightx = 1.0;
        cc2.weighty = 1.0;
        cc2.fill = 1;
        panelComptoir.add((Component)listeVC, cc2);
        ArrayList<SQLField> l22 = new ArrayList<SQLField>();
        l22.add(listeVC.getElement().getTable().getField("MONTANT_HT"));
        l22.add(listeVC.getElement().getTable().getField("MONTANT_TTC"));
        IListTotalPanel total22 = new IListTotalPanel(listeVC.getListe(), l22);
        cc2.weighty = 0.0;
        cc2.fill = 0;
        ++cc2.gridy;
        cc2.anchor = 13;
        total22.setOpaque(false);
        panelComptoir.add((Component)total22, cc2);
        IListFilterDatePanel filterDate22 = new IListFilterDatePanel(listeVC.getListe(), listeVC.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc2.weighty = 0.0;
        cc2.fill = 2;
        ++cc2.gridy;
        filterDate22.setOpaque(false);
        panelComptoir.add((Component)filterDate22, cc2);
        tabbedPane.add("Ventes comptoir", panelComptoir);
        this.add((Component)tabbedPane, c);
    }
}

