/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JProgressBar;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ReportingVenteXmlSheet
extends AbstractListeSheetXml {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    public static final String TEMPLATE_ID = "ReportingVentes";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Date du;
    private Date au;
    private Date date;
    private JProgressBar bar;
    private SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
    private SQLElement eltFactItem = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
    private List<Integer> idS;

    public ReportingVenteXmlSheet(List<Integer> idS, Date du, Date au, JProgressBar bar, boolean commande) {
        this.eltFact = Configuration.getInstance().getDirectory().getElement(commande ? "COMMANDE_CLIENT" : "SAISIE_VENTE_FACTURE");
        this.eltFactItem = Configuration.getInstance().getDirectory().getElement(commande ? "COMMANDE_CLIENT_ELEMENT" : "SAISIE_VENTE_FACTURE_ELEMENT");
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.du = du;
        this.au = au;
        this.bar = bar;
        this.idS = idS;
    }

    @Override
    public String getStoragePathP() {
        return "Autres";
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return TEMPLATE_ID + this.date.getTime();
    }

    @Override
    protected void createListeValues() {
        SQLSelect sel = new SQLSelect();
        sel.addRawSelect("SUM(\"QTE\"*\"QTE_UNITAIRE\")", "q");
        SQLTable tableItemFact = this.eltFactItem.getTable();
        sel.addSelect(tableItemFact.getField("T_PA_HT"), "SUM");
        sel.addSelect(tableItemFact.getField("T_PV_HT"), "SUM");
        sel.addSelect(tableItemFact.getField("T_PV_TTC"), "SUM");
        SQLTable tableArt = this.eltFactItem.getForeignElement("ID_ARTICLE").getTable();
        sel.addSelect(tableItemFact.getField("ID_ARTICLE"));
        SQLSelectJoin joinFact = sel.addJoin("LEFT", tableItemFact.getField("ID_" + this.eltFact.getTable().getName()));
        Where wA = new Where((FieldRef)tableArt.getKey(), "=", tableItemFact.getField("ID_ARTICLE"));
        Where w = new Where(joinFact.getJoinedTable().getField("DATE"), this.du, (Object)this.au);
        if (this.idS != null && this.idS.size() > 0) {
            sel.addSelect(joinFact.getJoinedTable().getField("ID_COMMERCIAL"));
            sel.addGroupBy(joinFact.getJoinedTable().getField("ID_COMMERCIAL"));
            w = w.and(new Where(joinFact.getJoinedTable().getField("ID_COMMERCIAL"), this.idS));
        }
        sel.setWhere(wA.and(w));
        sel.addGroupBy(tableItemFact.getField("ID_ARTICLE"));
        List result = this.eltFact.getTable().getDBSystemRoot().getDataSource().executeA(sel.asString());
        SQLSelect selCom = new SQLSelect();
        SQLTable tableCom = this.eltFact.getTable().getTable("COMMERCIAL");
        selCom.addSelect(tableCom.getKey());
        selCom.addSelect(tableCom.getField("NOM"));
        selCom.addSelect(tableCom.getField("PRENOM"));
        List<SQLRow> coms = SQLRowListRSH.execute(selCom);
        HashMap<Integer, SQLRow> mapCom = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : coms) {
            mapCom.put(sqlRow.getID(), sqlRow);
        }
        SQLSelect selArt = new SQLSelect();
        selArt.addSelect(tableArt.getKey());
        selArt.addSelect(tableArt.getField("NOM"));
        selArt.addSelect(tableArt.getField("CODE"));
        selArt.addSelect(tableArt.getField("ID_FAMILLE_ARTICLE"));
        List<SQLRow> art = SQLRowListRSH.execute(selArt);
        HashMap<Integer, SQLRow> mapA = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : art) {
            mapA.put(sqlRow.getID(), sqlRow);
        }
        SQLTable tableF = this.eltFactItem.getTable().getTable("FAMILLE_ARTICLE");
        SQLSelect selFam = new SQLSelect();
        selFam.addSelect(tableF.getKey());
        selFam.addSelect(tableF.getField("NOM"));
        selFam.addSelect(tableF.getField("ID_FAMILLE_ARTICLE_PERE"));
        List<SQLRow> fam = SQLRowListRSH.execute(selFam);
        HashMap<Integer, SQLRow> mapF = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : fam) {
            mapF.put(sqlRow.getID(), sqlRow);
        }
        HashMap<String, Line> linesFamilles = new HashMap<String, Line>();
        HashMap<String, Line> linesCommercial = new HashMap<String, Line>();
        TreeMap myValues = new TreeMap();
        Line lineTotal = new Line("Total", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        for (Object[] vals : result) {
            Map mapSF;
            Map mapCommercial;
            String commercial;
            String idRowF;
            Line lineSF;
            Line lineF;
            BigDecimal qte = (BigDecimal)vals[0];
            BigDecimal ha = (BigDecimal)vals[1];
            BigDecimal ht = (BigDecimal)vals[2];
            BigDecimal ttc = (BigDecimal)vals[3];
            int idArt = (Integer)vals[4];
            SQLRow rowArt = (SQLRow)mapA.get(idArt);
            int idFamille = rowArt.getForeignID("ID_FAMILLE_ARTICLE");
            SQLRow rowF = (SQLRow)mapF.get(idFamille);
            Line lineArt = new Line(rowArt.getString("NOM"), rowArt.getString("CODE"), ha, ttc, ht, qte);
            if (rowF == null) {
                if (!linesFamilles.containsKey("Undef")) {
                    linesFamilles.put("Undef", new Line("Sans famille", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                    linesFamilles.put("Undef-Undef", new Line("", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                lineF = (Line)linesFamilles.get("Undef");
                lineSF = (Line)linesFamilles.get("Undef-Undef");
            } else if (rowF.getObject("ID_FAMILLE_ARTICLE_PERE") == null || rowF.isForeignEmpty("ID_FAMILLE_ARTICLE_PERE")) {
                idRowF = String.valueOf(rowF.getID());
                if (!linesFamilles.containsKey(idRowF)) {
                    linesFamilles.put(idRowF, new Line(rowF.getString("NOM"), "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                    linesFamilles.put(String.valueOf(idRowF) + "-Undef", new Line("", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                lineF = (Line)linesFamilles.get(idRowF);
                if (!linesFamilles.containsKey(String.valueOf(idRowF) + "-Undef")) {
                    linesFamilles.put(String.valueOf(idRowF) + "-Undef", new Line("", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                if ((lineSF = (Line)linesFamilles.get(String.valueOf(idRowF) + "-Undef")) == null) {
                    System.err.println("null SF");
                }
                if (lineF == null) {
                    System.err.println("null F");
                }
            } else {
                idRowF = String.valueOf(rowF.getID());
                if (!linesFamilles.containsKey(idRowF)) {
                    linesFamilles.put(idRowF, new Line(rowF.getString("NOM"), "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                if (!linesFamilles.containsKey(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")))) {
                    SQLRow rowSF = (SQLRow)mapF.get(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE"));
                    linesFamilles.put(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")), new Line(rowSF.getString("NOM"), "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                lineF = (Line)linesFamilles.get(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")));
                lineSF = (Line)linesFamilles.get(idRowF);
                if (lineSF == null) {
                    System.err.println("null SF");
                }
                if (lineF == null) {
                    System.err.println("null F");
                }
            }
            if (this.idS != null && this.idS.size() > 0) {
                SQLRow rowCom = (SQLRow)mapCom.get(vals[5]);
                commercial = String.valueOf(rowCom.getString("PRENOM")) + " " + rowCom.getString("NOM");
                if (!linesCommercial.containsKey(commercial)) {
                    linesCommercial.put(commercial, new Line(commercial, "COMMERCIAL", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                ((Line)linesCommercial.get(commercial)).add(lineArt);
            } else {
                commercial = "";
            }
            if (!myValues.containsKey(commercial)) {
                myValues.put(commercial, new TreeMap(new Comparator<Line>(){

                    @Override
                    public int compare(Line o1, Line o2) {
                        return o1.getNomArt().compareTo(o2.getNomArt());
                    }
                }));
            }
            if (!(mapCommercial = (Map)myValues.get(commercial)).containsKey(lineF)) {
                mapCommercial.put(lineF, new TreeMap(new Comparator<Line>(){

                    @Override
                    public int compare(Line o1, Line o2) {
                        return o1.getNomArt().compareTo(o2.getNomArt());
                    }
                }));
                ((Map)mapCommercial.get(lineF)).put(lineSF, new ArrayList());
            }
            if (!(mapSF = (Map)mapCommercial.get(lineF)).containsKey(lineSF)) {
                mapSF.put(lineSF, new ArrayList());
            }
            List lines = (List)mapSF.get(lineSF);
            lines.add(lineArt);
            lineTotal.add(lineArt);
            lineF.add(lineArt);
            lineSF.add(lineArt);
        }
        ArrayList<Map<String, Object>> listValues = new ArrayList<Map<String, Object>>();
        for (Map.Entry commercial : myValues.entrySet()) {
            if (linesCommercial.get(commercial.getKey()) != null) {
                listValues.add(((Line)linesCommercial.get(commercial.getKey())).getMapXMLSheet());
                style.put(style.keySet().size(), "Titre 1");
            }
            for (Line f : ((Map)commercial.getValue()).keySet()) {
                listValues.add(f.getMapXMLSheet());
                style.put(style.keySet().size(), "Titre 1");
                Map sfs = (Map)((Map)commercial.getValue()).get(f);
                for (Line sf : sfs.keySet()) {
                    listValues.add(sf.getMapXMLSheet());
                    style.put(style.keySet().size(), "Titre 2");
                    List vals = (List)sfs.get(sf);
                    Collections.sort(vals, new Comparator<Line>(){

                        @Override
                        public int compare(Line o1, Line o2) {
                            return o1.getNomArt().compareTo(o2.getNomArt());
                        }
                    });
                    for (Line line : vals) {
                        if (line.getQte().signum() <= 0) continue;
                        listValues.add(line.getMapXMLSheet());
                        style.put(style.keySet().size(), "Normal");
                    }
                }
            }
        }
        listValues.add(lineTotal.getMapXMLSheet());
        style.put(style.keySet().size(), "Titre 1");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("DATE", "Du " + this.dateFormat.format(this.du) + " au " + this.dateFormat.format(this.au));
        values.put("NOM", "Reporting des " + (this.eltFact.getTable().getName().startsWith("COMMANDE") ? "commandes" : "factures"));
        this.listAllSheetValues.put(0, listValues);
        this.styleAllSheetValues.put(0, style);
        this.mapAllSheetValues.put(0, values);
    }

    class Line {
        private final String nomArt;
        private final String codeArt;
        private BigDecimal totalTTC;
        private BigDecimal totalHT;
        private BigDecimal qte;
        private BigDecimal totalHA;

        public Line(String nomArt, String codeArt, BigDecimal totalHA, BigDecimal totalTTC, BigDecimal totalHT, BigDecimal qte) {
            this.nomArt = nomArt;
            this.codeArt = codeArt;
            this.totalHA = totalHA;
            this.totalHT = totalHT;
            this.totalTTC = totalTTC;
            this.qte = qte;
        }

        public BigDecimal getTotalHA() {
            return this.totalHA;
        }

        public BigDecimal getQte() {
            return this.qte;
        }

        public String getCodeArt() {
            return this.codeArt;
        }

        public String getNomArt() {
            return this.nomArt;
        }

        public BigDecimal getTotalHT() {
            return this.totalHT;
        }

        public BigDecimal getTotalTTC() {
            return this.totalTTC;
        }

        public void add(Line l) {
            this.qte = this.qte.add(l.getQte());
            this.totalHA = this.totalHA.add(l.getTotalHA());
            this.totalHT = this.totalHT.add(l.getTotalHT());
            this.totalTTC = this.totalTTC.add(l.getTotalTTC());
        }

        public Map<String, Object> getMapXMLSheet() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("CODE", this.getCodeArt());
            m.put("NOM", this.getNomArt());
            m.put("QTE", this.getQte());
            m.put("TOTAL_HA", this.getTotalHA());
            m.put("TOTAL_HT", this.getTotalHT());
            m.put("TOTAL_TTC", this.getTotalTTC());
            return m;
        }
    }
}

