/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.ui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ProfilPayeModel
extends AbstractTableModel {
    private int idProfil;
    private static final SQLTable TABLE_PROFIL = Configuration.getInstance().getBase().getTable("PROFIL_PAYE_ELEMENT");
    private final List<SQLRowValues> vectRowElt = new ArrayList<SQLRowValues>();

    public ProfilPayeModel(int idProfil) {
        this.doSelectID(idProfil);
    }

    @Override
    public int getRowCount() {
        return this.vectRowElt.size();
    }

    @Override
    public String getColumnName(int column) {
        return "Nom";
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.vectRowElt.get(rowIndex).getString("NOM");
    }

    public void addRowAt(SQLRow rowRubrique, int rowIndex) {
        SQLRowValues rowVals = new SQLRowValues(TABLE_PROFIL);
        rowVals.put("NOM", rowRubrique.getString("NOM"));
        rowVals.put("SOURCE", rowRubrique.getTable().getName());
        rowVals.put("IDSOURCE", rowRubrique.getID());
        if (rowIndex > 0 && rowIndex < this.vectRowElt.size()) {
            this.vectRowElt.add(rowIndex, rowVals);
        } else {
            this.vectRowElt.add(rowVals);
        }
        this.fireTableDataChanged();
    }

    public void updateFields(int idProfil) {
        int i = 0;
        while (i < this.vectRowElt.size()) {
            SQLRowValues rowVals = this.vectRowElt.get(i);
            rowVals.put("ID_PROFIL_PAYE", idProfil);
            rowVals.put("POSITION", i);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void selectID(int idProfil) {
        if (this.idProfil != idProfil) {
            this.doSelectID(idProfil);
            this.fireTableDataChanged();
        }
    }

    private void doSelectID(int idProfil) {
        this.idProfil = idProfil;
        this.vectRowElt.clear();
        SQLSelect selAllIDProfilElt = new SQLSelect(Configuration.getInstance().getBase());
        selAllIDProfilElt.addSelect(TABLE_PROFIL.getField("ID"));
        selAllIDProfilElt.addSelect(TABLE_PROFIL.getField("POSITION"));
        selAllIDProfilElt.setWhere(new Where((FieldRef)TABLE_PROFIL.getField("ID_PROFIL_PAYE"), "=", this.idProfil));
        selAllIDProfilElt.addRawOrder("\"PROFIL_PAYE_ELEMENT\".\"POSITION\"");
        String reqAllIDProfilElt = selAllIDProfilElt.asString();
        Object[] objIDProfilElt = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllIDProfilElt, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objIDProfilElt.length) {
            SQLRow rowTmp = TABLE_PROFIL.getRow(Integer.parseInt(((Object[])objIDProfilElt[i])[0].toString()));
            SQLRowValues rowValsTmp = new SQLRowValues(TABLE_PROFIL);
            rowValsTmp.loadAbsolutelyAll(rowTmp);
            this.vectRowElt.add(rowValsTmp);
            ++i;
        }
    }

    public int upRow(int rowIndex) {
        if (this.vectRowElt.size() > 1 && rowIndex > 0) {
            System.err.println("UP");
            SQLRowValues tmp = this.vectRowElt.get(rowIndex);
            this.vectRowElt.set(rowIndex, this.vectRowElt.get(rowIndex - 1));
            this.vectRowElt.set(rowIndex - 1, tmp);
            this.fireTableDataChanged();
            return rowIndex - 1;
        }
        System.err.println("can't up!!");
        return rowIndex;
    }

    public int downRow(int rowIndex) {
        if (rowIndex >= 0 && this.vectRowElt.size() > 1 && rowIndex + 1 < this.vectRowElt.size()) {
            System.err.println("DOWN");
            SQLRowValues tmp = this.vectRowElt.get(rowIndex);
            this.vectRowElt.set(rowIndex, this.vectRowElt.get(rowIndex + 1));
            this.vectRowElt.set(rowIndex + 1, tmp);
            this.fireTableDataChanged();
            return rowIndex + 1;
        }
        System.err.println("can't down!!!");
        return rowIndex;
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0) {
            SQLRowValues rowVals = this.vectRowElt.remove(rowIndex);
            if (rowVals.getID() != -1) {
                rowVals.put("ARCHIVE", 1);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.fireTableDataChanged();
        }
    }
}

