/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.humanresources.payroll.report.LignePayeSimplifiee;
import org.openconcerto.utils.i18n.TranslationManager;

public enum GroupePayeSimplifiee {
    SANTE("sante", true, Arrays.asList(LignePayeSimplifiee.SANTE_SECURITE, LignePayeSimplifiee.SANTE_COMPLEMENAIRE_DECES, LignePayeSimplifiee.SANTE_COMPLEMENAIRE_SANTE)),
    ACCIDENT_TRAVAIL("accident", false, Arrays.asList(LignePayeSimplifiee.ACCIDENTS_TRAVAIL)),
    RETRAITE_NON_CADRE("retraite.noncadre", true, Arrays.asList(LignePayeSimplifiee.RETRAITE_SECURITE_PLAF, LignePayeSimplifiee.RETRAITE_SECURITE_NON_PLAF, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_T1, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_T2, LignePayeSimplifiee.RETRAITE_SUPPLEMENTAIRE)),
    RETRAITE_CADRE("retraite.cadre", true, Arrays.asList(LignePayeSimplifiee.RETRAITE_SECURITE_PLAF, LignePayeSimplifiee.RETRAITE_SECURITE_NON_PLAF, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_TA, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_GMP, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_TB, LignePayeSimplifiee.RETRAITE_COMPLEMENTAIRE_TC, LignePayeSimplifiee.RETRAITE_SUPPLEMENTAIRE)),
    FAMILLE("famille", false, Arrays.asList(LignePayeSimplifiee.FAMILLE_ALLOCATIONS)),
    CHOMAGE_NON_CADRE("chomage.noncadre", false, Arrays.asList(LignePayeSimplifiee.ASSURANCE_CHOMAGE_CHOMAGE)),
    CHOMAGE_CADRE("chomage.cadre", true, Arrays.asList(LignePayeSimplifiee.ASSURANCE_CHOMAGE_CHOMAGE, LignePayeSimplifiee.ASSURANCE_CHOMAGE_APEC)),
    AUTRES_CONTRIBUTIONS("autres", false, Arrays.asList(LignePayeSimplifiee.AUTRES_CONTRIBUTIONS)),
    COTISATIONS_CONVENTION("cotisations.convention", false, Arrays.asList(LignePayeSimplifiee.COTISATIONS_STATUAIRES)),
    CSG_NON_IMP("csg.nonimp", false, Arrays.asList(LignePayeSimplifiee.CSG_NON_IMP)),
    CSG_IMP("csg.imp", false, Arrays.asList(LignePayeSimplifiee.CSG_IMP)),
    ALLEGEMENT("allegement", false, Arrays.asList(LignePayeSimplifiee.ALLEGEMENT_COTISATIONS));

    public final String id;
    public final List<LignePayeSimplifiee> children;
    public final boolean showChildren;
    private static final Map<String, GroupePayeSimplifiee> idToEnum;

    static {
        idToEnum = new HashMap<String, GroupePayeSimplifiee>();
        GroupePayeSimplifiee[] groupePayeSimplifieeArray = GroupePayeSimplifiee.values();
        int n = groupePayeSimplifieeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GroupePayeSimplifiee e = groupePayeSimplifieeArray[n2];
            idToEnum.put(e.getId(), e);
            ++n2;
        }
    }

    private GroupePayeSimplifiee(String id, boolean showChildren, List<LignePayeSimplifiee> children) {
        this.children = children;
        this.showChildren = showChildren;
        this.id = id;
    }

    public boolean isShowChildren() {
        return this.showChildren;
    }

    public List<LignePayeSimplifiee> getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslation() {
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.getId());
        return translationForItem == null || translationForItem.trim().length() == 0 ? this.getId() : translationForItem;
    }

    public static GroupePayeSimplifiee fromID(int id) {
        return idToEnum.get(id);
    }

    public String toString() {
        return this.getTranslation();
    }
}

