/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.employe.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.humanresources.employe.report.N4DSSalarie;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringUtils;

public class N4DS {
    private DateFormat format = new SimpleDateFormat("ddMMyyyy");
    private ComptaPropsConfiguration conf = (ComptaPropsConfiguration)Configuration.getInstance();
    private double masseSalarialeBrute;
    private static final byte[] retour = "'\n".getBytes();
    private PrintStream stream = null;
    DecimalFormat decimalFormat = new DecimalFormat("0.00");
    Date dateDebut;
    Date dateFin;
    private int nbRubrique = 0;

    public N4DS() {
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        symbol.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(symbol);
    }

    public File createDocument() {
        this.masseSalarialeBrute = 0.0;
        File dir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("FichePayeSimplifiee");
        dir.mkdirs();
        File f = new File(dir, "N4DS_" + this.format.format(new Date()) + ".txt");
        try {
            try {
                this.stream = new PrintStream(f, "ISO-8859-1");
                SQLElement eltSalarie = this.conf.getDirectory().getElement("SALARIE");
                SQLRow rowSociete = this.conf.getRowSociete();
                this.writeS10(this.stream, rowSociete);
                this.writeS20(this.stream, rowSociete);
                SQLSelect sel = new SQLSelect();
                sel.addSelect(eltSalarie.getTable().getKey());
                SQLElement infosElt = eltSalarie.getForeignElement("ID_INFOS_SALARIE_PAYE");
                Date d2 = new Date(116, 11, 31);
                Where w = new Where((FieldRef)infosElt.getTable().getKey(), "=", eltSalarie.getTable().getField("ID_INFOS_SALARIE_PAYE"));
                w = w.and(new Where((FieldRef)infosElt.getTable().getField("DATE_ARRIVE"), "<=", (Object)d2));
                w = w.and(new Where((FieldRef)infosElt.getTable().getField("DATE_SORTIE"), "=", (Object)null).or(new Where((FieldRef)infosElt.getTable().getField("DATE_SORTIE"), "<=", (Object)d2)));
                sel.setWhere(w);
                List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltSalarie.getTable()));
                for (SQLRow row : l) {
                    N4DSSalarie s = new N4DSSalarie(this);
                    s.write(row, rowSociete);
                }
                this.writeS80(this.stream, rowSociete);
                this.writeS90(this.stream);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.stream != null) {
                    this.stream.close();
                }
            }
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        return f;
    }

    private void writeS80(PrintStream stream, SQLRow rowSociete) throws IOException {
        String[] sVoies;
        String siret = rowSociete.getString("NUM_SIRET").replaceAll(" ", "");
        String siren = StringUtils.limitLength(siret, 9);
        String nic = siret.substring(siren.length(), siret.length());
        this.write("S80.G01.00.001.002", nic);
        SQLRow rowAdr = rowSociete.getForeignRow("ID_ADRESSE_COMMON");
        String voie = rowAdr.getString("RUE");
        if (voie.contains("\n") && (sVoies = voie.split("\n")).length > 0) {
            voie = sVoies[0];
            String complement = "";
            int i = 1;
            while (i < sVoies.length) {
                complement = String.valueOf(complement) + sVoies[i].trim() + " ";
                ++i;
            }
            if (complement.length() > 0) {
                complement = complement.substring(0, complement.length() - 1);
            }
            this.write("S80.G01.00.003.001", N4DS.normalizeString2(complement));
        }
        this.write("S80.G01.00.003.006", N4DS.normalizeString2(voie));
        this.write("S80.G01.00.003.010", rowAdr.getString("CODE_POSTAL"));
        this.write("S80.G01.00.003.012", N4DS.normalizeString2(rowAdr.getString("VILLE")));
        this.write("S80.G01.00.004.001", String.valueOf(this.getEffectifDeclare()));
        this.write("S80.G01.00.005", "01");
        this.write("S80.G01.00.006", rowSociete.getString("NUM_APE"));
        this.write("S80.G01.00.007.001", "04");
        this.write("S80.G62.00.001", "01");
        double totalApprentissage = this.masseSalarialeBrute * 0.0068;
        System.err.println(this.masseSalarialeBrute);
        this.write("S80.G62.00.002", this.decimalFormat.format(totalApprentissage));
        this.write("S80.G62.00.003", "02");
        this.write("S80.G62.00.005", "01");
        double totalFormation = this.masseSalarialeBrute * 0.0055;
        this.write("S80.G62.00.007", this.decimalFormat.format(totalFormation));
        this.write("S80.G62.00.008", "02");
    }

    private void writeS90(PrintStream stream) throws IOException {
        this.write("S90.G01.00.001", String.valueOf(this.nbRubrique + 2));
        this.write("S90.G01.00.002", String.valueOf(1));
    }

    public void write(String rubriqueName, String value) throws IOException {
        String tmp = String.valueOf(rubriqueName) + ",'";
        this.stream.write(tmp.getBytes());
        this.stream.write(value.getBytes());
        this.stream.write(retour);
        ++this.nbRubrique;
    }

    private int getEffectifDeclare() {
        SQLElement eltSalarie = this.conf.getDirectory().getElement("SALARIE");
        SQLElement eltInfos = this.conf.getDirectory().getElement("INFOS_SALARIE_PAYE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(eltSalarie.getTable().getKey());
        Date d2 = new Date(116, 11, 31);
        Where w = new Where((FieldRef)eltSalarie.getTable().getField("ID_INFOS_SALARIE_PAYE"), "=", eltInfos.getTable().getKey());
        w = w.and(new Where((FieldRef)eltInfos.getTable().getField("DATE_SORTIE"), "=", (Object)null).or(new Where((FieldRef)eltInfos.getTable().getField("DATE_SORTIE"), "<=", (Object)d2)));
        w = w.and(new Where((FieldRef)eltInfos.getTable().getField("DATE_ARRIVE"), "=", (Object)null).or(new Where((FieldRef)eltInfos.getTable().getField("DATE_ARRIVE"), "<=", (Object)d2)));
        sel.setWhere(w);
        System.err.println(sel.asString());
        List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltSalarie.getTable()));
        return l == null ? 0 : l.size();
    }

    public static String normalizeString2(String s) {
        s = s.toUpperCase();
        String temp = Normalizer.normalize(s, Normalizer.Form.NFC);
        temp = temp.replaceAll("-", " ");
        temp = temp.replaceAll("\u00e9", "e");
        temp = temp.replaceAll("\u00e8", "e");
        temp = temp.replaceAll("\u00ea", "e");
        temp = temp.replaceAll(",", "");
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    private void writeS20(PrintStream stream, SQLRow rowSociete) throws IOException {
        String[] sVoies;
        String siret = rowSociete.getString("NUM_SIRET").replaceAll(" ", "");
        String siren = StringUtils.limitLength(siret, 9);
        String nic = siret.substring(siren.length(), siret.length());
        this.write("S20.G01.00.001", siren);
        this.write("S20.G01.00.002", N4DS.normalizeString2(rowSociete.getString("NOM")));
        this.write("S20.G01.00.003.001", "01012016");
        this.write("S20.G01.00.003.002", "31122016");
        this.write("S20.G01.00.004.001", "01");
        this.write("S20.G01.00.004.002", "51");
        this.write("S20.G01.00.005", "11");
        this.write("S20.G01.00.007", "01");
        this.write("S20.G01.00.008", nic);
        SQLRow rowAdr = rowSociete.getForeignRow("ID_ADRESSE_COMMON");
        String voie = rowAdr.getString("RUE");
        if (voie.contains("\n") && (sVoies = voie.split("\n")).length > 0) {
            voie = sVoies[0];
            String complement = "";
            int i = 1;
            while (i < sVoies.length) {
                complement = String.valueOf(complement) + sVoies[i].trim() + " ";
                ++i;
            }
            if (complement.length() > 0) {
                complement = complement.substring(0, complement.length() - 1);
            }
            this.write("S20.G01.00.009.001", N4DS.normalizeString2(complement));
        }
        this.write("S20.G01.00.009.006", N4DS.normalizeString2(voie));
        this.write("S20.G01.00.009.010", rowAdr.getString("CODE_POSTAL"));
        this.write("S20.G01.00.009.012", N4DS.normalizeString2(rowAdr.getString("VILLE")));
        this.write("S20.G01.00.013.002", "1");
        this.write("S20.G01.00.018", "A00");
        this.write("S20.G01.05.014.001", siren);
        this.write("S20.G01.05.014.002", nic);
        this.write("S20.G01.05.016.001", rowSociete.getString("MAIL"));
    }

    private void writeS10(PrintStream stream, SQLRow rowSociete) throws IOException {
        String[] sVoies;
        String siret = rowSociete.getString("NUM_SIRET").replaceAll(" ", "");
        String siren = StringUtils.limitLength(siret, 9);
        String nic = siret.substring(siren.length(), siret.length());
        this.write("S10.G01.00.001.001", siren);
        this.write("S10.G01.00.001.002", nic);
        this.write("S10.G01.00.002", N4DS.normalizeString2(rowSociete.getString("NOM")));
        SQLRow rowAdr = rowSociete.getForeignRow("ID_ADRESSE_COMMON");
        String voie = rowAdr.getString("RUE");
        if (voie.contains("\n") && (sVoies = voie.split("\n")).length > 0) {
            voie = sVoies[0];
            String complement = "";
            int i = 1;
            while (i < sVoies.length) {
                complement = String.valueOf(complement) + sVoies[i] + " ";
                ++i;
            }
            if (complement.length() > 0) {
                complement = complement.substring(0, complement.length() - 1);
            }
            this.write("S10.G01.00.003.001", N4DS.normalizeString2(complement));
        }
        this.write("S10.G01.00.003.006", N4DS.normalizeString2(voie));
        this.write("S10.G01.00.003.009", N4DS.normalizeString2(rowAdr.getString("VILLE")));
        this.write("S10.G01.00.003.010", rowAdr.getString("CODE_POSTAL"));
        this.write("S10.G01.00.003.012", N4DS.normalizeString2(rowAdr.getString("VILLE")));
        this.write("S10.G01.00.004,'", "1");
        this.write("S10.G01.00.005", "OpenConcerto");
        this.write("S10.G01.00.006", "ILM Informatique");
        this.write("S10.G01.00.007", ProductInfo.getInstance().getVersion());
        this.write("S10.G01.00.009", "40");
        this.write("S10.G01.00.010", "02");
        this.write("S10.G01.00.011", "V01X11");
        this.write("S10.G01.00.012", "01");
        this.write("S10.G01.01.001.001", "01");
        SQLTable table = Configuration.getInstance().getRoot().findTable("CONTACT_ADMINISTRATIF");
        SQLSelect selContact = new SQLSelect(table.getBase());
        selContact.addSelectStar(table);
        selContact.setWhere(new Where((FieldRef)table.getField("N4DS"), "=", (Object)Boolean.TRUE));
        List<SQLRow> l = SQLRowListRSH.execute(selContact);
        if (l.size() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Aucun contact administratif pour la N4DS. Veuillez en d\u00e9finir un.");
                }
            });
        } else {
            SQLRow rowContact = l.get(0);
            this.write("S10.G01.01.001.002", String.valueOf(rowContact.getString("NOM")) + " " + rowContact.getString("PRENOM"));
            this.write("S10.G01.01.002", "03");
            this.write("S10.G01.01.005", rowContact.getString("EMAIL"));
            String string = rowContact.getString("TEL_DIRECT");
            if (string.trim().length() == 0) {
                string = rowContact.getString("TEL_STANDARD");
            }
            this.write("S10.G01.01.006", string);
            this.write("S10.G01.01.007", rowContact.getString("FAX"));
        }
    }

    private String getNumeroVoie(String voie) {
        String numero = "";
        voie = voie.trim();
        int i = 0;
        while (i < voie.trim().length()) {
            char c = voie.charAt(i);
            if (c < '0' || c > '9') break;
            numero = String.valueOf(numero) + c;
            ++i;
        }
        return numero;
    }

    private String getVoieWithoutNumber(String voie) {
        voie = voie.trim();
        String resultVoie = new String(voie);
        int i = 0;
        while (i < voie.trim().length()) {
            char c = voie.charAt(i);
            if (c < '0' || c > '9') break;
            resultVoie = resultVoie.substring(1);
            ++i;
        }
        return resultVoie.trim();
    }

    public void addMasseSalarialeBrute(double baseBrute) {
        this.masseSalarialeBrute += baseBrute;
    }
}

