/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.component.EncaisserMontantSQLComponent;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.ExceptionHandler;

public class EncaisserMontantSQLElement
extends ComptaSQLConfElement {
    public EncaisserMontantSQLElement() {
        super("ENCAISSER_MONTANT", "un encaissement de montant", "encaissements de montant");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            RowAction.PredicateRowAction actionClient = new RowAction.PredicateRowAction(new AbstractAction("Annuler l'acompte"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow selRow = IListe.get(e).getSelectedRow().asRow();
                    if (selRow.getBoolean("ACOMPTE").booleanValue()) {
                        int idDevis = selRow.getForeignID("ID_DEVIS");
                        try {
                            EncaisserMontantSQLElement.this.archive(selRow.getID());
                            String up = "UPDATE " + EncaisserMontantSQLElement.this.getTable().getTable("DEVIS").getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + EncaisserMontantSQLElement.this.getTable().getSQLName().quote() + " where \"ID_DEVIS\"=" + idDevis + " AND \"ARCHIVE\"=0) where \"ID_DEVIS\"=" + idDevis;
                            EncaisserMontantSQLElement.this.getTable().getDBSystemRoot().getDataSource().execute(up);
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                            ExceptionHandler.handle("Erreur lors de l'annulation de l'acompte!", e1);
                        }
                    }
                }
            }, false);
            actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionClient);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_CLIENT");
        l.add("ID_MODE_REGLEMENT");
        l.add("MONTANT");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            l.add("ACOMPTE");
        }
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        return Collections.singleton("ID_CLIENT");
    }

    @Override
    public SQLComponent createComponent() {
        return new EncaisserMontantSQLComponent(this);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            for (SQLRow rowEncaisse : row.getReferentRows()) {
                SQLRow rowEch = rowEncaisse.getForeignRow("ID_ECHEANCE_CLIENT");
                if (rowEch.getID() > 1) {
                    SQLRowValues rowVals = rowEch.createEmptyUpdateRow();
                    rowVals.put("REGLE", Boolean.FALSE);
                    if (rowEch.getBoolean("REGLE").booleanValue()) {
                        rowVals.put("MONTANT", rowEncaisse.getLong("MONTANT_REGLE"));
                    } else {
                        rowVals.put("MONTANT", rowEch.getLong("MONTANT") + rowEncaisse.getLong("MONTANT_REGLE"));
                    }
                    rowVals.update();
                }
                Configuration.getInstance().getDirectory().getElement(rowEncaisse.getTable()).archive(rowEncaisse);
            }
            SQLSelect sel = new SQLSelect(this.getTable().getBase());
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement(tableMvt.getTable("ECRITURE"));
            sel.addSelectStar(tableMvt);
            Where w = new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)this.getTable().getName());
            w = w.and(new Where((FieldRef)tableMvt.getField("IDSOURCE"), "=", row.getID()));
            sel.setWhere(w);
            List list = (List)this.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableMvt));
            for (SQLRow sqlRow : list) {
                eltEcr.archiveMouvementProfondeur(sqlRow.getID(), true);
            }
        }
        super.archive(trees, cutLinks);
    }
}

