/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

abstract class ListeDesTraitesAbstractAction
extends CreateFrameAbstractAction {
    private final SQLTable table;
    private final SQLField echeanceField;

    public ListeDesTraitesAbstractAction(String name, String tableName, String echeanceField) {
        this.putValue("Name", name);
        this.table = Configuration.getInstance().getRoot().findTable(tableName);
        this.echeanceField = this.table.getField(echeanceField);
    }

    public final JFrame createFrame() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement(this.table);
        SQLField modeReglF = this.table.getField("ID_MODE_REGLEMENT");
        SQLTable modeReglT = this.table.getForeignTable(modeReglF.getName());
        Where wPrev = new Where((FieldRef)modeReglF, "=", modeReglT.getKey());
        wPrev = wPrev.and(new Where((FieldRef)modeReglT.getField("ID_TYPE_REGLEMENT"), ">=", 5));
        wPrev = wPrev.and(new Where((FieldRef)this.echeanceField, ">", 1));
        SQLTableModelSourceOnline src = elt.getTableSource(true);
        src.getReq().setWhere(wPrev);
        IListFrame frame = new IListFrame(new ListeViewPanel(elt, new IListe(src)));
        frame.getPanel().setAddVisible(false);
        frame.getPanel().getListe().setModificationAllowed(false);
        return frame;
    }
}

