/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openconcerto.erp.core.finance.accounting.model.AnalytiqueModel;
import org.openconcerto.erp.core.finance.accounting.ui.AjouterPosteAnalytiqueFrame;
import org.openconcerto.erp.element.objet.Poste;
import org.openconcerto.erp.element.objet.Repartition;
import org.openconcerto.erp.element.objet.RepartitionElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.CloseTableHeaderRenderer;
import org.openconcerto.ui.table.TablePopupMouseListener;
import org.openconcerto.utils.cc.ITransformer;

public class RepartitionAxeAnalytiquePanel
extends JPanel {
    private int idAxe;
    private AnalytiqueModel model;
    private JTable listeRepartitions;
    private RepartitionAxeAnalytiquePanel repPanel = this;
    private JWindow windowChangeNom;
    private JTextField text;
    private AjouterPosteAnalytiqueFrame ajoutPosteFrame = null;

    public RepartitionAxeAnalytiquePanel(int idAxe) {
        this.idAxe = idAxe;
        this.uiInit();
    }

    public List<Repartition> getRepartitions() {
        return this.model.getRepartition();
    }

    public List<RepartitionElement> getRepartitionElems() {
        return this.model.getRepartitionElem();
    }

    public List<Poste> getPostes() {
        return this.model.getPostes();
    }

    public int getIdAxe() {
        return this.idAxe;
    }

    public void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JButton boutonAjoutRep = new JButton("Ajout R\u00e9partition");
        boutonAjoutRep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RepartitionAxeAnalytiquePanel.this.model.addElement();
                System.out.println("Ajout d'une r\u00e9partiton");
            }
        });
        this.add((Component)boutonAjoutRep, c);
        JButton boutonSupprRep = new JButton("Suppr R\u00e9partition");
        boutonSupprRep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RepartitionAxeAnalytiquePanel.this.model.removeElement(RepartitionAxeAnalytiquePanel.this.listeRepartitions.getSelectedRows());
            }
        });
        ++c.gridx;
        this.add((Component)boutonSupprRep, c);
        JButton boutonAjoutPoste = new JButton("Ajout Poste");
        boutonAjoutPoste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("Ajout d'un poste");
                if (RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame == null) {
                    RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame = new AjouterPosteAnalytiqueFrame(RepartitionAxeAnalytiquePanel.this.model, RepartitionAxeAnalytiquePanel.this.repPanel);
                    RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame.pack();
                }
                RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame.setVisible(true);
            }
        });
        ++c.gridx;
        this.add((Component)boutonAjoutPoste, c);
        JButton boutonSupprPoste = new JButton("Suppr Poste");
        boutonSupprPoste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RepartitionAxeAnalytiquePanel.this.disableAffichageColonne();
                RepartitionAxeAnalytiquePanel.this.model.removePoste(RepartitionAxeAnalytiquePanel.this.listeRepartitions.getSelectedColumn());
                RepartitionAxeAnalytiquePanel.this.setAffichageColonne();
                System.out.println("Suppression d'un poste");
            }
        });
        ++c.gridx;
        this.add((Component)boutonSupprPoste, c);
        System.out.println("Creation des repartitions de l'axe " + this.idAxe);
        this.model = new AnalytiqueModel(this.idAxe);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.listeRepartitions = new JTable(this.model){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        TablePopupMouseListener.add(this.listeRepartitions, new ITransformer<MouseEvent, JPopupMenu>(){

            @Override
            public JPopupMenu transformChecked(MouseEvent input) {
                JPopupMenu res = new JPopupMenu();
                JTable table = (JTable)input.getSource();
                for (Action a : RepartitionAxeAnalytiquePanel.this.getActions(table, table.getSelectedRow())) {
                    res.add(a);
                }
                return res;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.listeRepartitions);
        this.add((Component)scrollPane, c);
        this.listeRepartitions.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                }
            }
        });
        this.setAffichageColonne();
    }

    public List<Action> getActions(JTable table, final int row) {
        AbstractAction a = new AbstractAction("Supprimer ligne " + row){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepartitionAxeAnalytiquePanel.this.model.removeElement(row);
                System.out.println("Suppression row:" + row);
            }
        };
        AbstractAction a2 = new AbstractAction("Ajouter une ligne"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepartitionAxeAnalytiquePanel.this.model.addElement();
                System.out.println("Ajout d'une ligne");
            }
        };
        return Arrays.asList(a, a2);
    }

    public void setAffichageColonne() {
        this.disableAffichageColonne();
        int i = 1;
        while (i < this.listeRepartitions.getColumnCount()) {
            final int col = i;
            Vector<AbstractAction> actions = new Vector<AbstractAction>();
            AbstractAction a = new AbstractAction("Supprimer le poste"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RepartitionAxeAnalytiquePanel.this.listeRepartitions.getColumnCount() > 2) {
                        System.out.println("Action efface colonne : " + col);
                        if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                            RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                            RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                        }
                        RepartitionAxeAnalytiquePanel.this.disableAffichageColonne();
                        RepartitionAxeAnalytiquePanel.this.model.removePoste(col);
                        RepartitionAxeAnalytiquePanel.this.setAffichageColonne();
                    }
                }
            };
            actions.add(a);
            AbstractAction a1 = new AbstractAction("Ajouter un poste"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame == null) {
                        RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame = new AjouterPosteAnalytiqueFrame(RepartitionAxeAnalytiquePanel.this.model, RepartitionAxeAnalytiquePanel.this.repPanel);
                        RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame.pack();
                    }
                    RepartitionAxeAnalytiquePanel.this.ajoutPosteFrame.setVisible(true);
                    System.out.println("Action ajout");
                    if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                        RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                        RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                    }
                }
            };
            AbstractAction a2 = new AbstractAction("Renommer le poste"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RepartitionAxeAnalytiquePanel.this.actionModifierPoste(col);
                }
            };
            actions.add(a1);
            actions.add(a2);
            this.listeRepartitions.getColumnModel().getColumn(i).setHeaderRenderer(new CloseTableHeaderRenderer(a, actions));
            ++i;
        }
    }

    public void disableAffichageColonne() {
        int j = 1;
        while (j < this.listeRepartitions.getColumnCount()) {
            System.out.println("Destroy : " + j);
            if (this.listeRepartitions.getColumnModel().getColumn(j).getHeaderRenderer() != null && this.listeRepartitions.getColumnModel().getColumn(j).getHeaderRenderer() instanceof CloseTableHeaderRenderer) {
                System.out.println("Desactivation du listenner sur " + j);
                ((CloseTableHeaderRenderer)this.listeRepartitions.getColumnModel().getColumn(j).getHeaderRenderer()).destroy();
                this.listeRepartitions.getColumnModel().getColumn(j).setHeaderRenderer(null);
            }
            ++j;
        }
    }

    public void actionModifierPoste(final int col) {
        if (col == -1) {
            return;
        }
        KeyAdapter textKL = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RepartitionAxeAnalytiquePanel.this.disableAffichageColonne();
                    RepartitionAxeAnalytiquePanel.this.model.modifierNomPoste(col, RepartitionAxeAnalytiquePanel.this.text.getText());
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                    RepartitionAxeAnalytiquePanel.this.setAffichageColonne();
                }
            }
        };
        FocusAdapter textFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (RepartitionAxeAnalytiquePanel.this.windowChangeNom != null) {
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.setVisible(false);
                    RepartitionAxeAnalytiquePanel.this.windowChangeNom.dispose();
                }
            }
        };
        JFrame frame = (JFrame)SwingUtilities.getRoot(this);
        this.windowChangeNom = new JWindow(frame);
        this.windowChangeNom.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        this.text = new JTextField(" " + this.listeRepartitions.getColumnName(col) + " ");
        this.text.setEditable(true);
        this.windowChangeNom.add((Component)this.text, c);
        this.text.setBorder(null);
        this.text.addFocusListener(textFL);
        this.text.addKeyListener(textKL);
        this.windowChangeNom.pack();
        int x = 0;
        int i = 0;
        while (i < col) {
            x += this.listeRepartitions.getColumnModel().getColumn(i).getWidth();
            ++i;
        }
        int y = this.listeRepartitions.getTableHeader().getY();
        int centreY = (this.listeRepartitions.getTableHeader().getHeight() - this.windowChangeNom.getHeight()) / 2;
        this.windowChangeNom.setLocation(this.listeRepartitions.getTableHeader().getLocationOnScreen().x + (x += 4), this.listeRepartitions.getTableHeader().getLocationOnScreen().y + y + centreY);
        this.windowChangeNom.setVisible(true);
    }
}

