/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionJournauxAction;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.element.objet.Journal;
import org.openconcerto.erp.model.LoadingTableListener;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.GestionDevise;

public class EtatJournauxPanel
extends JPanel {
    private JTabbedPane tabbedJournaux;
    private EventListenerList loadingListener = new EventListenerList();
    private final DateFormat dateFormat = new SimpleDateFormat("MMMM yyyy");
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final String baseName = ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName();
    int nbLoading = 0;

    public EtatJournauxPanel() {
        this.tabbedJournaux = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.tabbedJournaux, c);
        JButton buttonImpression = new JButton("Impression");
        JButton buttonClose = new JButton("Fermer");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonImpression, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(EtatJournauxPanel.this)).dispose();
            }
        });
        buttonImpression.addActionListener((ActionListener)((Object)new ImpressionJournauxAction()));
    }

    public void loadAsynchronous() {
        SQLTable journalTable = base.getTable("JOURNAL");
        List<SQLRow> liste = SQLBackgroundTableCache.getInstance().getCacheForTable(journalTable).getRows();
        int k = 0;
        while (k < liste.size()) {
            SQLRow row = liste.get(k);
            this.fireIsLoading(true);
            final Journal jrnlTmp = new Journal(row.getID(), row.getString("NOM"), row.getString("CODE"));
            new SwingWorker<JPanel, Object>(){

                @Override
                protected JPanel doInBackground() throws Exception {
                    JPanel initJournalPanel = EtatJournauxPanel.this.initJournalPanel(jrnlTmp);
                    return initJournalPanel;
                }

                @Override
                protected void done() {
                    try {
                        JPanel initJournalPanel = (JPanel)this.get();
                        initJournalPanel.setOpaque(false);
                        JScrollPane scroll = new JScrollPane(initJournalPanel);
                        scroll.setBorder(null);
                        scroll.setOpaque(false);
                        scroll.getViewport().setOpaque(false);
                        EtatJournauxPanel.this.tabbedJournaux.addTab(jrnlTmp.getNom(), scroll);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    EtatJournauxPanel.this.fireIsLoading(false);
                    super.done();
                }
            }.execute();
            ++k;
        }
    }

    private JPanel initJournalPanel(Journal jrnl) {
        JPanel panelTmp = new JPanel();
        long totalDebitJournal = 0L;
        long totalCreditJournal = 0L;
        panelTmp.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        String req = "SELECT DISTINCT EXTRACT(YEAR FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\"), " + "EXTRACT(MONTH FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\")," + " SUM(\"" + baseName + "\".\"ECRITURE\".\"DEBIT\"), " + "SUM(\"" + baseName + "\".\"ECRITURE\".\"CREDIT\")" + " FROM \"" + baseName + "\".\"ECRITURE\" " + "WHERE (\"" + baseName + "\".\"ECRITURE\".\"ID\" != 1) " + "AND ((\"" + baseName + "\".\"ECRITURE\".\"ARCHIVE\" = 0) " + "AND (\"" + baseName + "\".\"ECRITURE\".\"ID_JOURNAL\" = " + jrnl.getId() + ")) " + "GROUP BY EXTRACT(YEAR FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\"), " + "EXTRACT(MONTH FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\") " + "ORDER BY EXTRACT(YEAR FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\"), " + "EXTRACT(MONTH FROM \"" + baseName + "\".\"ECRITURE\".\"DATE\")";
        System.out.println(req);
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList.size() != 0) {
            int i = 0;
            while (i < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i);
                Calendar cal = Calendar.getInstance();
                cal.set(5, 1);
                int month = new Double(objTmp[1].toString()).intValue() - 1;
                System.err.println(String.valueOf(jrnl.getNom()) + " SET MONTH " + month);
                cal.set(2, month);
                System.err.println(String.valueOf(month) + " = " + cal.getTime());
                cal.set(1, new Double(objTmp[0].toString()).intValue());
                long debitMois = ((Number)objTmp[2]).longValue();
                long creditMois = ((Number)objTmp[3]).longValue();
                c.gridwidth = 0;
                JPanel creerJournalMoisPanel = this.creerJournalMoisPanel(cal.getTime(), debitMois, creditMois, jrnl);
                creerJournalMoisPanel.setOpaque(false);
                panelTmp.add((Component)creerJournalMoisPanel, c);
                ++c.gridy;
                totalDebitJournal += debitMois;
                totalCreditJournal += creditMois;
                ++i;
            }
        }
        c.gridx = 0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        JLabel label = new JLabel("Journal " + jrnl.getNom());
        label.setOpaque(false);
        panelTmp.add((Component)label, c);
        c.gridx = -1;
        panelTmp.add((Component)new JLabel(" Total d\u00e9bit : " + GestionDevise.currencyToString(totalDebitJournal)), c);
        panelTmp.add((Component)new JLabel(" Total cr\u00e9dit : " + GestionDevise.currencyToString(totalCreditJournal)), c);
        return panelTmp;
    }

    private JPanel creerJournalMoisPanel(final Date date, long debit, long credit, final Journal jrnl) {
        final JPanel panelMoisCompte = new JPanel();
        panelMoisCompte.setLayout(new GridBagLayout());
        final GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelMoisCompte.setBorder(BorderFactory.createTitledBorder(this.dateFormat.format(date)));
        panelMoisCompte.add((Component)new JLabel(this.dateFormat.format(date)), c);
        ++c.gridx;
        panelMoisCompte.add((Component)new JLabel(" d\u00e9bit : " + GestionDevise.currencyToString(debit)), c);
        ++c.gridx;
        panelMoisCompte.add((Component)new JLabel(" cr\u00e9dit : " + GestionDevise.currencyToString(credit)), c);
        JButton boutonShow = new JButton("+/-");
        boutonShow.setOpaque(false);
        boutonShow.setHorizontalAlignment(2);
        c.weightx = 0.0;
        ++c.gridx;
        panelMoisCompte.add((Component)boutonShow, c);
        boutonShow.addActionListener(new ActionListener(){
            private boolean isShow = false;
            private ListPanelEcritures listEcriture;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println(this.isShow);
                if (!this.isShow) {
                    SQLElement element = Configuration.getInstance().getDirectory().getElement("ECRITURE");
                    SQLTable ecrTable = element.getTable();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.set(5, 1);
                    Date inf = cal.getTime();
                    cal.set(5, cal.getActualMaximum(5));
                    Date sup = cal.getTime();
                    System.out.println("Inf : " + inf + " Sup : " + sup);
                    Where w = new Where((FieldRef)ecrTable.getField("ID_JOURNAL"), "=", jrnl.getId());
                    Where w2 = new Where((FieldRef)ecrTable.getField("DATE"), inf, (Object)sup);
                    if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                        w = w.and(new Where((FieldRef)ecrTable.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                    }
                    this.listEcriture = new ListPanelEcritures(element, w.and(w2));
                    this.listEcriture.setModificationVisible(false);
                    this.listEcriture.setAjoutVisible(false);
                    this.listEcriture.setSuppressionVisible(false);
                    this.listEcriture.getListe().setModificationAllowed(false);
                    Dimension d = this.listEcriture.getListe().getPreferredSize().height > 200 ? new Dimension(this.listEcriture.getListe().getPreferredSize().width, 200) : new Dimension(this.listEcriture.getListe().getPreferredSize().width, this.listEcriture.getListe().getPreferredSize().height + 30);
                    this.listEcriture.getListe().setPreferredSize(d);
                    c.gridx = 0;
                    c.gridy = 1;
                    c.gridwidth = 4;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.fill = 1;
                    this.listEcriture.getListe().setModificationAllowed(false);
                    panelMoisCompte.add((Component)this.listEcriture, c);
                    this.listEcriture.getListe().getJTable().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (e.getButton() == 3) {
                                JPopupMenu menu = new JPopupMenu();
                                menu.add(new AbstractAction("Voir la source"){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        SQLRow row = base.getTable("ECRITURE").getRow(listEcriture.getListe().getSelectedId());
                                        MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                                    }
                                });
                                menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                            }
                        }
                    });
                } else {
                    panelMoisCompte.remove(this.listEcriture);
                    System.out.println("Hide ListEcriture");
                    panelMoisCompte.repaint();
                    panelMoisCompte.revalidate();
                }
                this.isShow = !this.isShow;
                SwingUtilities.getRoot(panelMoisCompte).repaint();
            }
        });
        return panelMoisCompte;
    }

    public void fireIsLoading(boolean isLoading) {
        this.nbLoading = isLoading ? ++this.nbLoading : --this.nbLoading;
        LoadingTableListener[] loadingTableListenerArray = (LoadingTableListener[])this.loadingListener.getListeners(LoadingTableListener.class);
        int n = loadingTableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoadingTableListener l = loadingTableListenerArray[n2];
            l.isLoading(this.nbLoading > 0);
            ++n2;
        }
    }

    public void addLoadingListener(LoadingTableListener l) {
        this.loadingListener.add(LoadingTableListener.class, l);
    }
}

