/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.PdfGenerator;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class PdfGenerator_2033A
extends PdfGenerator {
    public PdfGenerator_2033A() {
        super("2033A.pdf", "result_2033A.pdf", TemplateNXProps.getInstance().getStringProperty("Location2033APDF"));
        this.setTemplateOffset(0, 0);
        this.setOffset(0, 0);
        this.setMargin(32, 32);
    }

    @Override
    public void generate() {
        this.setFontBold(14);
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.addText("NOM", String.valueOf(rowSociete.getString("TYPE")) + " " + rowSociete.getString("NOM"), 120, 776);
        this.setFontRoman(12);
        SQLRow rowAdresse = Configuration.getInstance().getBase().getTable("ADRESSE_COMMON").getRow(rowSociete.getInt("ID_ADRESSE_COMMON"));
        String ville = rowAdresse.getString("VILLE");
        Object cedex = rowAdresse.getObject("CEDEX");
        boolean hasCedex = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        String adresse = String.valueOf(rowAdresse.getString("RUE")) + ", " + rowAdresse.getString("CODE_POSTAL") + " " + ville;
        System.err.println(adresse);
        this.addText("ADRESSE", adresse, 100, 759);
        this.addSplittedText("SIRET", rowSociete.getString("NUM_SIRET").replaceAll(" ", ""), 82, 735, 17.0);
        this.addSplittedText("CLOS1", "08202006", 502, 689, 9.7);
        this.addSplittedText("DUREE1", "12", 183, 758, 14.0);
        this.setFontRoman(9);
        String cc = "Document g\u00e9n\u00e9r\u00e9 par le logiciel Bloc, (c) Front Software 2006";
        this.addText("", cc, this.getWidth() - 2, 16, 90);
        this.setFontRoman(10);
        long t = 53L;
        int yy = 0;
        int y = 652;
        int netColN = 605;
        int netColN1 = 705;
        int amortCol = 515;
        int brutCol = 415;
        y = 652;
        while (y > 390) {
            t *= (long)(y / 100);
            this.addTextRight("ACTIF1." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + (t += (long)y)), 387, y);
            this.addTextRight("ACTIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 487, y);
            this.addTextRight("ACTIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 577, y);
            this.addTextRight("ACTIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        y -= 18;
        while (y > 310) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + (t += (long)y)), 577, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        while (y > 280) {
            this.addTextRight("PASSIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t / 10000L), 459, y);
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 577, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        while (y > 140) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 577, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        while (y > 120) {
            this.addTextRight("PASSIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t / 10000L), 459, y);
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 577, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        while (y > 70) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 577, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
        while (y > 10) {
            this.addTextRight("PASSIF1." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 294, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 677, y);
            ++yy;
            y -= 18;
        }
    }
}

