/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class SommeCompte {
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private SQLRow rowAnalytique = null;
    SQLTable ecritureTable = base.getTable("ECRITURE");
    SQLTable compteTable = base.getTable("COMPTE_PCE");

    public SommeCompte() {
        this(null);
    }

    public SommeCompte(SQLRow rowAnalytique) {
        this.rowAnalytique = rowAnalytique;
    }

    private void addAnalytiqueJoin(SQLSelect sel) {
        if (this.rowAnalytique != null) {
            SQLTable tableAssoc = this.ecritureTable.getTable("ASSOCIATION_ANALYTIQUE");
            Where join = new Where((FieldRef)tableAssoc.getField("ID_ECRITURE"), "=", this.ecritureTable.getKey());
            join = join.and(new Where((FieldRef)tableAssoc.getField("ID_POSTE_ANALYTIQUE"), "=", this.rowAnalytique.getID()));
            sel.addJoin("RIGHT", this.ecritureTable.getTable("ASSOCIATION_ANALYTIQUE"), join);
        }
    }

    public long sommeCompteFils(String numero, Date dateDebut, Date dateFin) {
        long sommeDebit = 0L;
        long sommeCredit = 0L;
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(this.ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(this.ecritureTable.getField("CREDIT"), "SUM");
        sel.addJoin("LEFT", this.ecritureTable.getField("ID_COMPTE_PCE"));
        Where w2 = new Where((FieldRef)this.compteTable.getField("NUMERO"), "LIKE", (Object)(String.valueOf(numero.trim()) + "%"));
        Where w3 = new Where((FieldRef)this.ecritureTable.getField("DATE"), dateDebut, (Object)dateFin);
        sel.setWhere(w2.and(w3));
        this.addAnalytiqueJoin(sel);
        String req = sel.asString();
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList.size() != 0) {
            int i = 0;
            while (i < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i);
                if (objTmp[0] != null) {
                    sommeDebit += ((Number)objTmp[0]).longValue();
                }
                if (objTmp[1] != null) {
                    sommeCredit += ((Number)objTmp[1]).longValue();
                }
                ++i;
            }
        }
        return sommeDebit - sommeCredit;
    }

    public long soldeCompte(int numeroStart, int numeroEnd, boolean includeAllEnd, Date dateDebut, Date dateFin) {
        long sommeDebit = 0L;
        long sommeCredit = 0L;
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        sel.addJoin("LEFT", ecritureTable.getField("ID_COMPTE_PCE"));
        Where w2 = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(numeroStart)) + "%"));
        Where w4 = new Where((FieldRef)ecritureTable.getField("DATE"), dateDebut, (Object)dateFin);
        int i = numeroStart + 1;
        while (i < numeroEnd + 1) {
            Where w3 = i == numeroEnd && !includeAllEnd ? new Where((FieldRef)compteTable.getField("NUMERO"), "=", (Object)String.valueOf(i)) : new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(i)) + "%"));
            w2 = w2.or(w3);
            ++i;
        }
        sel.setWhere(w2.and(w4));
        this.addAnalytiqueJoin(sel);
        String req = sel.asString();
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList.size() != 0) {
            int i2 = 0;
            while (i2 < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i2);
                if (objTmp[0] != null) {
                    sommeDebit += ((Number)objTmp[0]).longValue();
                }
                if (objTmp[1] != null) {
                    sommeCredit += ((Number)objTmp[1]).longValue();
                }
                ++i2;
            }
        }
        return sommeDebit - sommeCredit;
    }

    public long soldeCompteDebiteur(int numeroStart, int numeroEnd, boolean includeAllEnd, Date dateDebut, Date dateFin) {
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        sel.addJoin("LEFT", ecritureTable.getField("ID_COMPTE_PCE"));
        sel.addSelect(sel.getAlias(compteTable).getField("ID"));
        sel.addSelect(sel.getAlias(compteTable).getField("NUMERO"));
        Where w2 = new Where(sel.getAlias(compteTable).getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(numeroStart)) + "%"));
        Where w4 = new Where((FieldRef)ecritureTable.getField("DATE"), dateDebut, (Object)dateFin);
        int i = numeroStart + 1;
        while (i < numeroEnd + 1) {
            Where w3 = i == numeroEnd && !includeAllEnd ? new Where(sel.getAlias(compteTable).getField("NUMERO"), "=", (Object)String.valueOf(i)) : new Where(sel.getAlias(compteTable).getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(i)) + "%"));
            w2 = w2.or(w3);
            ++i;
        }
        sel.setWhere(w2.and(w4));
        this.addAnalytiqueJoin(sel);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        long debit = 0L;
        long credit = 0L;
        long solde = 0L;
        int size = myList.size();
        int i2 = 0;
        while (i2 < size) {
            Object[] objTmp = (Object[])myList.get(i2);
            debit = ((Number)objTmp[0]).longValue();
            if (debit - (credit = ((Number)objTmp[1]).longValue()) > 0L) {
                solde += debit - credit;
            }
            ++i2;
        }
        return solde;
    }

    public long soldeCompteCrediteur(int numeroStart, int numeroEnd, boolean includeAllEnd, Date dateDebut, Date dateFin) {
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        sel.addJoin("LEFT", ecritureTable.getField("ID_COMPTE_PCE"));
        sel.addSelect(sel.getAlias(compteTable).getField("ID"));
        sel.addSelect(sel.getAlias(compteTable).getField("NUMERO"));
        Where w2 = new Where(sel.getAlias(compteTable).getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(numeroStart)) + "%"));
        Where w4 = new Where((FieldRef)ecritureTable.getField("DATE"), dateDebut, (Object)dateFin);
        int i = numeroStart + 1;
        while (i < numeroEnd + 1) {
            Where w3 = i == numeroEnd && !includeAllEnd ? new Where(sel.getAlias(compteTable).getField("NUMERO"), "=", (Object)String.valueOf(i)) : new Where(sel.getAlias(compteTable).getField("NUMERO"), "LIKE", (Object)(String.valueOf(String.valueOf(i)) + "%"));
            w2 = w2.or(w3);
            ++i;
        }
        sel.setWhere(w2.and(w4));
        this.addAnalytiqueJoin(sel);
        String req = sel.asString();
        req = String.valueOf(req) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        long debit = 0L;
        long credit = 0L;
        long solde = 0L;
        int size = myList.size();
        int i2 = 0;
        while (i2 < size) {
            Object[] objTmp = (Object[])myList.get(i2);
            debit = ((Number)objTmp[0]).longValue();
            credit = ((Number)objTmp[1]).longValue();
            if (credit - debit > 0L) {
                solde += credit - debit;
            }
            ++i2;
        }
        return solde;
    }

    public long soldeCompte(String numero) {
        long sommeDebit = 0L;
        long sommeCredit = 0L;
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        Where w = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getField("ID"));
        Where w2 = new Where((FieldRef)compteTable.getField("NUMERO"), "=", (Object)numero.trim());
        sel.setWhere(w.and(w2));
        this.addAnalytiqueJoin(sel);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        int size = myList.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myList.get(i);
            sommeDebit += ((Number)objTmp[0]).longValue();
            sommeCredit += ((Number)objTmp[1]).longValue();
            ++i;
        }
        return sommeDebit - sommeCredit;
    }
}

