/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.SaisieKmSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.ConsultationCompteFrame;
import org.openconcerto.erp.core.finance.accounting.ui.LettrageRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.ListEcritureRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.ListeDesEcrituresPanel;
import org.openconcerto.erp.core.finance.accounting.ui.PointageRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.convertor.ValueConvertor;

public class EcritureSQLElement
extends ComptaSQLConfElement {
    private static EditFrame frameSaisieKm = null;

    public EcritureSQLElement() {
        super("ECRITURE", "une \u00e9criture", "\u00e9critures");
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction("ID_MOUVEMENT").getAction(), true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
    }

    @Override
    protected String getParentFFName() {
        return "ID_MOUVEMENT";
    }

    @Override
    public List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("VALIDE");
        l.add("ID_MOUVEMENT");
        if (this.getTable().contains("NOM_PIECE")) {
            l.add("NOM_PIECE");
        }
        l.add("COMPTE_NUMERO");
        l.add("COMPTE_NOM");
        l.add("JOURNAL_NOM");
        l.add("NOM");
        l.add("DATE");
        l.add("DEBIT");
        l.add("CREDIT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("DATE");
        l.add("DEBIT");
        l.add("CREDIT");
        l.add("ID_JOURNAL");
        l.add("ID_MOUVEMENT");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("VALIDE");
    }

    public void consultationCompte(SQLRowAccessor rowCpt) {
        final ConsultationCompteFrame f = new ConsultationCompteFrame(new ListeDesEcrituresPanel(), "Consultation compte n\u00b0" + rowCpt.getString("NUMERO") + " " + rowCpt.getString("NOM"));
        f.getPanel().getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent mE) {
                if (mE.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Voir les ecritures du journal"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int id = f.getPanel().getListe().idFromIndex(f.getPanel().getListe().getJTable().rowAtPoint(mE.getPoint()));
                            SQLTable ecrTable = EcritureSQLElement.this.getTable().getTable("ECRITURE");
                            System.err.println("Ecritures ID ::: " + id);
                            SQLRow rowEcr = ecrTable.getRow(id);
                            System.err.println("Ecritures ID ::: " + id + " --> ID_JOURNAL = " + rowEcr.getInt("ID_JOURNAL"));
                            ConsultationCompteFrame f2 = new ConsultationCompteFrame(new ListeDesEcrituresPanel(), "Consultation du journal " + EcritureSQLElement.this.getTable().getTable("JOURNAL").getRow(rowEcr.getInt("ID_JOURNAL")).getString("NOM"));
                            Where w = new Where((FieldRef)ecrTable.getField("ID_JOURNAL"), "=", rowEcr.getInt("ID_JOURNAL"));
                            f2.getPanel().getListe().getRequest().setWhere(w);
                            f2.getPanel().getListe().setModificationAllowed(false);
                            f2.pack();
                            f2.setVisible(true);
                        }
                    });
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int id = f.getPanel().getListe().idFromIndex(f.getPanel().getListe().getJTable().rowAtPoint(mE.getPoint()));
                            System.err.println("ID COMPTE SELECTED " + id);
                            SQLRow rowEcr = EcritureSQLElement.this.getTable().getTable("ECRITURE").getRow(id);
                            System.out.println("MOUVEMENT VALIDE ------------->>>>>>>>>>>>>> " + MouvementSQLElement.isEditable(rowEcr.getInt("ID_MOUVEMENT")));
                            MouvementSQLElement.showSource(rowEcr.getInt("ID_MOUVEMENT"));
                            System.out.println("Mouvement Numero : " + rowEcr.getInt("ID_MOUVEMENT"));
                        }
                    });
                    menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
                }
            }
        });
        SQLTable ecrTable = this.getTable().getTable("ECRITURE");
        Where w = new Where((FieldRef)ecrTable.getField("ID_COMPTE_PCE"), "=", rowCpt.getID());
        f.getPanel().getListe().getRequest().setWhere(w);
        f.getPanel().getListe().setModificationAllowed(false);
        f.pack();
        f.setVisible(true);
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        BaseSQLTableModelColumn analytique = new BaseSQLTableModelColumn("Poste analytique", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                Collection<? extends SQLRowAccessor> assocs = r.getReferentRows(EcritureSQLElement.this.getTable().getTable("ASSOCIATION_ANALYTIQUE"));
                StringBuffer res = new StringBuffer();
                for (SQLRowAccessor sQLRowAccessor : assocs) {
                    res.append(sQLRowAccessor.getForeign("ID_POSTE_ANALYTIQUE").getString("NOM"));
                    res.append(", ");
                }
                return res.toString();
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(EcritureSQLElement.this.getTable());
                p = (Path)p.add(EcritureSQLElement.this.getTable().getTable("ASSOCIATION_ANALYTIQUE"));
                p = (Path)p.add(p.getLast().getForeignTable("ID_POSTE_ANALYTIQUE"));
                return CollectionUtils.createSet(new FieldPath(p, "NOM"));
            }
        };
        res.getColumns().add(analytique);
        for (SQLTableModelColumn col : res.getColumns()) {
            col.setRenderer(ListEcritureRenderer.UTILS.getRenderer(col.getRenderer()));
        }
    }

    public final SQLTableModelSourceOnline createPointageTableSource() {
        ArrayList<String> listEcriture = new ArrayList<String>();
        listEcriture.add("POINTEE");
        listEcriture.add("DATE_POINTEE");
        listEcriture.add("ID_MOUVEMENT");
        listEcriture.add("NOM");
        listEcriture.add("DATE");
        listEcriture.add("DEBIT");
        listEcriture.add("CREDIT");
        SQLTableModelSourceOnline res = this.instantiateTableSourceOnline(this.createListRequest(listEcriture));
        for (SQLTableModelColumn col : res.getColumns()) {
            if (col.getValueClass() == Long.class || col.getValueClass() == BigInteger.class) {
                col.setConverter(new ValueConvertor<Number, BigDecimal>(){

                    @Override
                    public BigDecimal convert(Number o) {
                        if (o == null) {
                            return BigDecimal.ZERO;
                        }
                        return new BigDecimal(o.longValue()).movePointLeft(2);
                    }

                    @Override
                    public Number unconvert(BigDecimal o) {
                        if (o == null) {
                            return 0;
                        }
                        return o.movePointRight(2);
                    }
                }, BigDecimal.class);
                col.setRenderer(CURRENCY_RENDERER);
            }
            col.setRenderer(PointageRenderer.UTILS.getRenderer(col.getRenderer()));
        }
        return this.initTableSource(res, true);
    }

    public final SQLTableModelSourceOnline createLettrageTableSource() {
        ArrayList<String> listEcriture = new ArrayList<String>();
        listEcriture.add("LETTRAGE");
        listEcriture.add("ID_COMPTE_PCE");
        listEcriture.add("ID_MOUVEMENT");
        if (this.getTable().contains("NOM_PIECE")) {
            listEcriture.add("NOM_PIECE");
        }
        listEcriture.add("NOM");
        listEcriture.add("DATE_LETTRAGE");
        listEcriture.add("DATE");
        listEcriture.add("DEBIT");
        listEcriture.add("CREDIT");
        SQLTableModelSourceOnline res = this.instantiateTableSourceOnline(this.createListRequest(listEcriture));
        for (SQLTableModelColumn col : res.getColumns()) {
            if (col.getValueClass() == Long.class || col.getValueClass() == BigInteger.class) {
                col.setConverter(new ValueConvertor<Number, BigDecimal>(){

                    @Override
                    public BigDecimal convert(Number o) {
                        if (o == null) {
                            return BigDecimal.ZERO;
                        }
                        return new BigDecimal(o.longValue()).movePointLeft(2);
                    }

                    @Override
                    public Number unconvert(BigDecimal o) {
                        if (o == null) {
                            return 0;
                        }
                        return o.movePointRight(2);
                    }
                }, BigDecimal.class);
                col.setRenderer(CURRENCY_RENDERER);
            }
            col.setRenderer(LettrageRenderer.UTILS.getRenderer(col.getRenderer()));
        }
        return this.initTableSource(res, true);
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JTextField nom;
            private DeviseField debit;
            private DeviseField credit;
            private JDate date;
            private ElementComboBox journal;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.nom = new JTextField();
                this.debit = new DeviseField();
                this.credit = new DeviseField();
                this.date = new JDate();
                this.journal = new ElementComboBox();
                JLabel labelJournal = new JLabel("Journal");
                c.gridx = 0;
                this.add((Component)labelJournal, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.journal, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                JLabel labelNom = new JLabel("Libell\u00e9");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)this.nom, c);
                c.gridwidth = 1;
                JLabel labelDebit = new JLabel("Debit");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelDebit, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.debit, c);
                this.debit.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (credit.getText().trim().length() != 0 && debit.getText().trim().length() != 0) {
                            credit.setText("");
                        }
                    }
                });
                JLabel labelCredit = new JLabel("Credit");
                ++c.gridx;
                this.add((Component)labelCredit, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.credit, c);
                this.credit.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (debit.getText().trim().length() != 0 && credit.getText().trim().length() != 0) {
                            debit.setText("");
                        }
                    }
                });
                this.addSQLObject(this.nom, "NOM");
                this.addSQLObject(this.debit, "DEBIT");
                this.addSQLObject(this.credit, "CREDIT");
                this.addRequiredSQLObject(this.date, "DATE");
                this.addRequiredSQLObject(this.journal, "ID_JOURNAL");
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null && r.getBoolean("VALIDE").booleanValue()) {
                    this.nom.setEnabled(false);
                    this.debit.setEnabled(false);
                    this.credit.setEnabled(false);
                    this.date.setInteractionMode(InteractionMode.DISABLED);
                    this.journal.setEnabled(false);
                }
            }

            @Override
            public void update() {
                SQLRow row = EcritureSQLElement.this.getTable().getRow(this.getSelectedID());
                if (row.getBoolean("VALIDE").booleanValue()) {
                    System.out.println("Impossible de modifier une ecriture valid\u00e9e");
                } else {
                    super.update();
                }
            }
        };
    }

    private static void validerMouvement(int idMvt) {
        if (idMvt == 1) {
            return;
        }
        SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLRow rowMvt = tableMvt.getRow(idMvt);
        if (rowMvt.getInt("ID_MOUVEMENT_PERE") > 1) {
            EcritureSQLElement.validerMouvement(rowMvt.getInt("ID_MOUVEMENT_PERE"));
        } else {
            EcritureSQLElement.validerMouvementProfondeur(idMvt);
        }
    }

    private static void validerMouvementProfondeur(int idMvtPere) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLSelect selectFils = new SQLSelect();
        selectFils.addSelect(tableMvt.getField("ID"));
        selectFils.setWhere(tableMvt.getField("ID_MOUVEMENT_PERE"), "=", idMvtPere);
        List l = (List)base.getDataSource().execute(selectFils.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            EcritureSQLElement.validerMouvementProfondeur(Integer.parseInt(tmp[0].toString()));
            ++i;
        }
        EcritureSQLElement.validationEcritures(idMvtPere);
    }

    public static final void validationEcritures(int idMvt) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect(base);
        selEcriture.addSelect(tableEcriture.getField("ID"));
        Where w = new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", idMvt);
        selEcriture.setWhere(w);
        String reqEcriture = selEcriture.asString();
        Object obEcriture = base.getDataSource().execute(reqEcriture, new ArrayListHandler());
        List myListEcriture = (List)obEcriture;
        if (myListEcriture.size() != 0) {
            int i = 0;
            while (i < myListEcriture.size()) {
                Object[] objTmp = (Object[])myListEcriture.get(i);
                EcritureSQLElement.valideEcriture(Integer.parseInt(objTmp[0].toString()));
                ++i;
            }
        }
    }

    public static final void validationEcrituresBefore(java.util.Date d, boolean cloture) {
        SQLRow rowSociete;
        SQLTable tableExercice;
        SQLRow rowExercice;
        java.util.Date dateCloture;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect(base);
        selEcriture.addSelect(tableEcriture.getField("ID_MOUVEMENT"));
        selEcriture.setDistinct(true);
        Where w1 = new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)d);
        Where w2 = new Where((FieldRef)tableEcriture.getField("VALIDE"), "=", (Object)Boolean.FALSE);
        selEcriture.setWhere(w1.and(w2));
        List l = (List)base.getDataSource().execute(selEcriture.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            System.err.println("Validation du mouvement " + tmp[0]);
            EcritureSQLElement.validationEcritures(Integer.parseInt(tmp[0].toString()));
            ++i;
        }
        if (cloture && ((dateCloture = (java.util.Date)(rowExercice = (tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON")).getRow((rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete()).getInt("ID_EXERCICE_COMMON"))).getObject("DATE_CLOTURE")) == null || dateCloture.before(d))) {
            SQLRowValues rowVals = new SQLRowValues(tableExercice);
            rowVals.put("DATE_CLOTURE", new Date(d.getTime()));
            try {
                rowVals.update(rowExercice.getID());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static final void valideEcriture(int id) {
        SQLTable tableEcriture = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("ECRITURE");
        SQLRowValues rowVals = new SQLRowValues(tableEcriture);
        rowVals.put("VALIDE", Boolean.TRUE);
        rowVals.put("DATE_VALIDE", new Date(new java.util.Date().getTime()));
        rowVals.put("IDUSER_VALIDE", UserManager.getInstance().getCurrentUser().getId());
        try {
            rowVals.update(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void archiveMouvement(int idMvt) {
        SQLTable tableMouvement = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLRow rowMvt = tableMouvement.getRow(idMvt);
        if (rowMvt.getInt("ID_MOUVEMENT_PERE") > 1) {
            this.archiveMouvement(rowMvt.getInt("ID_MOUVEMENT_PERE"));
        } else {
            this.archiveMouvementProfondeur(idMvt, true);
        }
    }

    public void archiveMouvementProfondeur(int idMvtPere, boolean dropPere) {
        if (idMvtPere > 1) {
            SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
            SQLSelect selectFils = new SQLSelect();
            selectFils.addSelect(tableMvt.getField("ID"));
            selectFils.setWhere(tableMvt.getField("ID_MOUVEMENT_PERE"), "=", idMvtPere);
            List l = (List)base.getDataSource().execute(selectFils.asString(), new ArrayListHandler());
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                this.archiveMouvementProfondeur(Integer.parseInt(tmp[0].toString()), true);
                ++i;
            }
            this.archiveEcritures(idMvtPere, dropPere);
        } else {
            System.err.println("Suppression du mouvement d'id 1 impossible.");
            JOptionPane.showMessageDialog(null, "Impossible d'archiver, le mouvement est ind\u00e9fini.");
        }
    }

    public synchronized void archiveEcritures(final int idMvt, boolean dropMvt) {
        final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = base.getTable("MOUVEMENT");
        final SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLRow rowMvt = tableMvt.getRow(idMvt);
        if (MouvementSQLElement.isEditable(idMvt)) {
            if (dropMvt) {
                SQLElement elt = Configuration.getInstance().getDirectory().getElement(tableMvt);
                try {
                    elt.archive(idMvt);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de la suppression du mouvement d'id [" + idMvt + "]", e);
                    e.printStackTrace();
                }
            } else {
                SQLUtils.SQLFactory<Object> sqlFactory = new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        SQLSelect selEcritures = new SQLSelect();
                        selEcritures.addSelect(tableEcriture.getField("ID"));
                        selEcritures.setWhere(tableEcriture.getField("ID_MOUVEMENT"), "=", idMvt);
                        List l = (List)base.getDataSource().execute(selEcritures.asString(), new ArrayListHandler());
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            EcritureSQLElement.this.archiveEcriture(tableEcriture.getRow(Integer.parseInt(tmp[0].toString())));
                            ++i;
                        }
                        return null;
                    }
                };
                try {
                    SQLUtils.executeAtomic(base.getDataSource(), sqlFactory);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Une erreur est survenue lors de la suppression des \u00e9critures.", e);
                }
            }
        } else {
            ExceptionHandler.handle("Impossible de supprimer le mouvement n\u00b0" + rowMvt.getInt("NUMERO") + " car il est valid\u00e9.");
        }
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            System.err.println("Archivage des \u00e9critures");
            PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(row.getInt("ID_MOUVEMENT")), "Suppression d'ecritures");
            frame.pack();
            frame.setResizable(false);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
    }

    public void archiveEcriture(SQLRow row) throws SQLException {
        if (!row.getBoolean("VALIDE").booleanValue()) {
            SQLRowValues rowVals = new SQLRowValues(this.getTable());
            rowVals.put("IDUSER_DELETE", UserManager.getInstance().getCurrentUser().getId());
            rowVals.put("ARCHIVE", 1);
            rowVals.update(row.getID());
            String codeLettrage = row.getString("LETTRAGE");
            if (codeLettrage != null && codeLettrage.trim().length() > 0) {
                UpdateBuilder builder = new UpdateBuilder(this.getTable());
                builder.setObject("LETTRAGE", (Object)"");
                builder.setObject("DATE_LETTRAGE", null);
                builder.setWhere(new Where((FieldRef)this.getTable().getField("LETTRAGE"), "=", (Object)codeLettrage));
                this.getTable().getDBSystemRoot().getDataSource().execute(builder.asString());
            }
        } else {
            System.err.println("Impossible de supprimer une ecriture valid\u00e9e");
            JOptionPane.showMessageDialog(null, "Impossible de supprimer une ecriture valid\u00e9e. \n" + row);
        }
    }

    public static void contrePassationPiece(int id) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLRow rowEcr = tableEcriture.getRow(id);
        final int idMvt = rowEcr.getInt("ID_MOUVEMENT");
        System.err.println("ID MOUVEMENT --> " + idMvt);
        if (frameSaisieKm == null) {
            frameSaisieKm = new EditFrame(Configuration.getInstance().getDirectory().getElement("SAISIE_KM"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaisieKmSQLElement.loadContrePassation(frameSaisieKm.getSQLComponent(), idMvt);
            }
        });
        frameSaisieKm.setVisible(true);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".entry.item";
    }

    public static void dupliquer(SQLRow selectedRow) {
        SQLRow foreignMvt = selectedRow.getForeign("ID_MOUVEMENT");
        if (foreignMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_KM")) {
            SQLElement elementSaisieKm = Configuration.getInstance().getDirectory().getElement("SAISIE_KM");
            SQLElement elementSaisieKmItem = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
            final EditFrame frameCloneSaisieKm = new EditFrame(elementSaisieKm);
            int idSource = foreignMvt.getInt("IDSOURCE");
            SQLRow rowKm = elementSaisieKm.getTable().getRow(idSource);
            final SQLRowValues rowVals = elementSaisieKm.createCopy(idSource);
            rowVals.put("ID_MOUVEMENT", null);
            Collection items = rowKm.getReferentRows(elementSaisieKm.getTable().getTable("SAISIE_KM_ELEMENT"));
            for (SQLRow sqlRow : items) {
                SQLRowValues sqlRowValues = elementSaisieKmItem.createCopy(sqlRow.getID());
                sqlRowValues.put("ID_ECRITURE", null);
                sqlRowValues.put("ID_SAISIE_KM", (Object)rowVals);
                System.err.println("ADD ELEMENT KM :: " + sqlRowValues.getID());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frameCloneSaisieKm.getSQLComponent().select(rowVals);
                }
            });
            frameCloneSaisieKm.setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "La duplication n'est possible que sur les saisies au kilom\u00e8tre");
                }
            });
        }
    }
}

