/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config.update;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.openconcerto.erp.config.InstallationPanel;
import org.openconcerto.erp.core.finance.payment.element.SDDMessageSQLElement;
import org.openconcerto.erp.core.finance.payment.element.SEPAMandateSQLElement;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeClient;
import org.openconcerto.erp.core.sales.pos.element.TicketCaisseSQLElement;
import org.openconcerto.sql.changer.convert.AddMDFields;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.UniqueConstraintCreatorHelper;
import org.openconcerto.utils.CollectionUtils;

public class Updater_1_5 {
    private static final String COMPTE_CLIENT_TRANSACTION = "COMPTE_CLIENT_TRANSACTION";

    public static void update(DBRoot root) throws SQLException {
        SQLTable vcT;
        SQLCreateTable createSDDMsgTable;
        SQLTable contactT;
        AlterTable alter;
        SQLTable tkmElt;
        SQLTable tableEcr;
        AlterTable t;
        SQLTable table;
        SQLTable tableDevis;
        AlterTable alterB;
        SQLTable tableFPayeElt;
        AlterTable alterB2;
        SQLTable tableDevisAcompte;
        AlterTable alterArt;
        SQLTable tableArt;
        SQLTable tableFournisseur;
        AlterTable alterArticle;
        SQLTable tableArticle;
        SQLTable tableClient;
        SQLTable tableEtatCivil;
        SQLTable tableCpaye;
        SQLTable tableFpaye;
        SQLTable tableVarSal;
        AlterTable alt;
        SQLTable tableFacturationCmd;
        AlterTable alterB3;
        SQLTable tableEtatDmdAChat;
        AlterTable alterB4;
        SQLTable tableDmdAChat;
        Object alterB5;
        SQLCreateTable createTableDmd;
        SQLRowValues rowVals;
        SQLCreateTable createTableEtat;
        SQLTable tableCmdFElt;
        SQLTable tableBRElt;
        AlterTable t2;
        SQLTable tableCmdElt;
        SQLTable tableVFElt;
        AlterTable alter2;
        SQLTable tableAttachment;
        SQLCreateTable createTable;
        SQLTable tTva;
        SQLTable tCmdClient;
        SQLTable tCompteClient;
        AlterTable alterClient;
        SQLTable tClient;
        SQLTable tableCompte = root.getTable("COMPTE_PCE");
        if (!tableCompte.contains("OBSOLETE")) {
            AlterTable alter3 = new AlterTable(tableCompte);
            alter3.addBooleanColumn("OBSOLETE", Boolean.FALSE, false);
            tableCompte.getBase().getDataSource().execute(alter3.asString());
            tableCompte.getSchema().updateVersion();
            tableCompte.fetchFields();
        }
        if (!root.contains(COMPTE_CLIENT_TRANSACTION)) {
            SQLCreateTable createTable2 = new SQLCreateTable(root, COMPTE_CLIENT_TRANSACTION);
            createTable2.addForeignColumn("CLIENT");
            createTable2.addDateAndTimeColumn("DATE");
            createTable2.addDecimalColumn("MONTANT", 16, 6, BigDecimal.valueOf(0L), false);
            createTable2.addForeignColumn("MODE_REGLEMENT");
            createTable2.addForeignColumn("MOUVEMENT");
            try {
                root.getBase().getDataSource().execute(createTable2.asString());
                InstallationPanel.insertUndef(createTable2);
                root.refetchTable(COMPTE_CLIENT_TRANSACTION);
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table COMPTE_CLIENT_TRANSACTION", ex);
            }
        }
        if (!(tClient = root.getTable("CLIENT")).contains("SOLDE_COMPTE")) {
            alterClient = new AlterTable(tClient);
            alterClient.addDecimalColumn("SOLDE_COMPTE", 16, 6, BigDecimal.valueOf(0L), false);
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tClient.contains("DATE")) {
            alterClient = new AlterTable(tClient);
            alterClient.addColumn("DATE", "date");
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tClient.contains("COMMENTAIRES")) {
            alterClient = new AlterTable(tClient);
            alterClient.addVarCharColumn("COMMENTAIRES", 2048);
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!(tCompteClient = root.getTable(COMPTE_CLIENT_TRANSACTION)).contains("ID_MOUVEMENT")) {
            AlterTable alterClient2 = new AlterTable(tCompteClient);
            alterClient2.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
            tClient.getBase().getDataSource().execute(alterClient2.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!(tCmdClient = root.getTable("COMMANDE_CLIENT")).contains("DATE_LIVRAISON_PREV")) {
            AlterTable alterCmdClient = new AlterTable(tCmdClient);
            alterCmdClient.addColumn("DATE_LIVRAISON_PREV", "date");
            tCmdClient.getBase().getDataSource().execute(alterCmdClient.asString());
            tCmdClient.getSchema().updateVersion();
            tCmdClient.fetchFields();
        }
        if (!tClient.contains("CONDITIONS_LIVRAISON")) {
            AlterTable alterClient3 = new AlterTable(tClient);
            alterClient3.addVarCharColumn("CONDITIONS_LIVRAISON", 512);
            tClient.getBase().getDataSource().execute(alterClient3.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        List<String> tablesCheque = Arrays.asList("CHEQUE_A_ENCAISSER", "CHEQUE_FOURNISSEUR");
        for (String string : tablesCheque) {
            SQLTable table2 = root.getTable(string);
            if (table2.contains("SANS_VALEUR_ENCAISSEMENT")) continue;
            AlterTable alterElt = new AlterTable(table2);
            alterElt.addBooleanColumn("SANS_VALEUR_ENCAISSEMENT", Boolean.FALSE, false);
            table2.getBase().getDataSource().execute(alterElt.asString());
            root.refetchTable(string);
            root.getSchema().updateVersion();
            UpdateBuilder upBuilder = new UpdateBuilder(table2);
            upBuilder.setObject("SANS_VALEUR_ENCAISSEMENT", (Object)Boolean.TRUE);
            table2.getBase().getDataSource().execute(upBuilder.asString());
        }
        SQLTable tableEncElt = root.getTable("ENCAISSER_MONTANT_ELEMENT");
        if (tableEncElt.getField("DATE").getType().getType() == 93) {
            AlterTable t3 = new AlterTable(tableEncElt);
            t3.alterColumn("DATE", EnumSet.allOf(SQLField.Properties.class), "date", null, Boolean.TRUE);
            tableEncElt.getBase().getDataSource().execute(t3.asString());
            root.refetchTable(tableEncElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tTva = root.getTable("TAXE")).contains("ID_COMPTE_PCE_COLLECTE_INTRA")) {
            AlterTable alterTaxe = new AlterTable(tTva);
            alterTaxe.addForeignColumn("ID_COMPTE_PCE_COLLECTE_INTRA", root.getTable("COMPTE_PCE"));
            alterTaxe.addForeignColumn("ID_COMPTE_PCE_DED_INTRA", root.getTable("COMPTE_PCE"));
            tTva.getBase().getDataSource().execute(alterTaxe.asString());
            tTva.getSchema().updateVersion();
            tTva.fetchFields();
        }
        if (!root.contains("TAXE_COMPLEMENTAIRE")) {
            createTable = new SQLCreateTable(root, "TAXE_COMPLEMENTAIRE");
            createTable.addForeignColumn("ID_COMPTE_PCE_PRODUITS", root.getTable("COMPTE_PCE"));
            createTable.addForeignColumn("ID_COMPTE_PCE", root.getTable("COMPTE_PCE"));
            createTable.addDecimalColumn("POURCENT", 16, 6, BigDecimal.valueOf(0L), false);
            createTable.addVarCharColumn("CODE", 25);
            createTable.addVarCharColumn("NOM", 256);
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                InstallationPanel.insertUndef(createTable);
                root.refetchTable("TAXE_COMPLEMENTAIRE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TAXE_COMPLEMENTAIRE", ex);
            }
            SQLTable tableArt2 = root.getTable("ARTICLE");
            AlterTable alterArt2 = new AlterTable(tableArt2);
            alterArt2.addForeignColumn("ID_TAXE_COMPLEMENTAIRE", root.getTable("TAXE_COMPLEMENTAIRE"));
            tableArt2.getBase().getDataSource().execute(alterArt2.asString());
            tableArt2.getSchema().updateVersion();
            tableArt2.fetchFields();
        }
        if (!root.contains("ATTACHMENT")) {
            createTable = new SQLCreateTable(root, "ATTACHMENT");
            createTable.addVarCharColumn("SOURCE_TABLE", 128);
            createTable.addIntegerColumn("SOURCE_ID", 0);
            createTable.addVarCharColumn("NAME", 256);
            createTable.addVarCharColumn("MIMETYPE", 256);
            createTable.addVarCharColumn("FILENAME", 256);
            createTable.addLongColumn("FILESIZE", 0L, false);
            createTable.addVarCharColumn("STORAGE_PATH", 256);
            createTable.addVarCharColumn("STORAGE_FILENAME", 256);
            createTable.addVarCharColumn("DIRECTORY", 256);
            createTable.addVarCharColumn("THUMBNAIL", 256);
            createTable.addIntegerColumn("THUMBNAIL_WIDTH", 32);
            createTable.addIntegerColumn("THUMBNAIL_HEIGHT", 32);
            createTable.addVarCharColumn("TAG", 128);
            createTable.addIntegerColumn("VERSION", 0);
            createTable.addVarCharColumn("HASH", 32);
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                InstallationPanel.insertUndef(createTable);
                root.refetchTable("ATTACHMENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ATTACHMENT", ex);
            }
        }
        if (!(tableAttachment = root.getTable("ATTACHMENT")).contains("DIRECTORY")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addVarCharColumn("STORAGE_FILENAME", 256);
            alter2.addVarCharColumn("DIRECTORY", 256);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        if (!tableAttachment.contains("ID_PARENT")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addForeignColumn("ID_PARENT", tableAttachment);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        if (!tableAttachment.contains("VERSION")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addIntegerColumn("VERSION", 0);
            alter2.addVarCharColumn("HASH", 32);
            alter2.addVarCharColumn("INFOS", 8000);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        List<String> gedTable = Arrays.asList("CLIENT", "MOUVEMENT", "FOURNISSEUR", "ARTICLE", "FACTURE_FOURNISSEUR", "SAISIE_VENTE_FACTURE", "SALARIE");
        for (String string : gedTable) {
            SQLTable tableGED = root.getTable(string);
            if (tableGED.contains("ATTACHMENTS")) continue;
            AlterTable alter4 = new AlterTable(tableGED);
            alter4.addIntegerColumn("ATTACHMENTS", 0);
            tableGED.getBase().getDataSource().execute(alter4.asString());
            tableGED.getSchema().updateVersion();
            tableGED.fetchFields();
        }
        SQLTable tableBLElt = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        if (!tableBLElt.contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            AlterTable t4 = new AlterTable(tableBLElt);
            t4.addForeignColumn("ID_COMMANDE_CLIENT_ELEMENT", root.getTable("COMMANDE_CLIENT_ELEMENT"));
            tableBLElt.getBase().getDataSource().execute(t4.asString());
            root.refetchTable(tableBLElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT")).contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            AlterTable t5 = new AlterTable(tableVFElt);
            t5.addForeignColumn("ID_COMMANDE_CLIENT_ELEMENT", root.getTable("COMMANDE_CLIENT_ELEMENT"));
            tableVFElt.getBase().getDataSource().execute(t5.asString());
            root.refetchTable(tableVFElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT")).contains("LIVRE")) {
            t2 = new AlterTable(tableCmdElt);
            t2.addBooleanColumn("LIVRE_FORCED", Boolean.FALSE, false);
            t2.addBooleanColumn("LIVRE", Boolean.FALSE, false);
            t2.addDecimalColumn("QTE_LIVREE", 16, 6, BigDecimal.ZERO, true);
            tableCmdElt.getBase().getDataSource().execute(t2.asString());
            root.refetchTable(tableCmdElt.getName());
            root.getSchema().updateVersion();
            SQLTable tableCmdCli = root.getTable("COMMANDE_CLIENT");
            SQLTable tableTR = root.getTable("TR_COMMANDE_CLIENT");
            SQLTable tableBL = root.getTable("BON_DE_LIVRAISON");
            SQLTable tableFactC = root.getTable("SAISIE_VENTE_FACTURE");
            String sel = "SELECT t.\"ID_COMMANDE_CLIENT\" FROM " + new SQLName(root.getName(), tableTR.getName()).quote() + " t ," + new SQLName(root.getName(), tableCmdCli.getName()).quote() + " c ," + new SQLName(root.getName(), tableBL.getName()).quote() + " b ," + new SQLName(root.getName(), tableFactC.getName()).quote() + " f WHERE c.\"ID\"=t.\"ID_COMMANDE_CLIENT\" AND f.\"ID\"=t.\"ID_SAISIE_VENTE_FACTURE\"" + " AND b.\"ID\"=t.\"ID_BON_DE_LIVRAISON\" AND b.\"ARCHIVE\" = 0 AND f.\"ID\" > 1 AND t.\"ID\" > 1 AND c.\"ID\" > 1 AND f.\"ARCHIVE\" = 0 AND t.\"ARCHIVE\" = 0 AND c.\"ARCHIVE\" = 0 GROUP BY t.\"ID_COMMANDE_CLIENT\" HAVING (SUM(b.\"TOTAL_HT\")>=SUM(c.\"T_HT\") OR SUM(f.\"T_HT\")>=SUM(c.\"T_HT\")) ";
            List cmd = tableTR.getDBSystemRoot().getDataSource().executeCol(sel);
            UpdateBuilder build = new UpdateBuilder(tableCmdElt);
            build.set("QTE_LIVREE", "\"QTE\"*\"QTE_UNITAIRE\"");
            build.setObject("LIVRE_FORCED", (Object)Boolean.TRUE);
            Where where = new Where(tableCmdElt.getField("ID_COMMANDE_CLIENT"), cmd);
            build.setWhere(where);
        }
        if (tableCmdElt.contains("LIVRE")) {
            t2 = new AlterTable(tableCmdElt);
            t2.alterColumnDefault("LIVRE", "false");
            tableCmdElt.getBase().getDataSource().execute(t2.asString());
            root.refetchTable(tableCmdElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableBRElt = root.getTable("BON_RECEPTION_ELEMENT")).contains("ID_COMMANDE_ELEMENT")) {
            AlterTable t6 = new AlterTable(tableBRElt);
            t6.addForeignColumn("ID_COMMANDE_ELEMENT", root.getTable("COMMANDE_ELEMENT"));
            tableBRElt.getBase().getDataSource().execute(t6.asString());
            root.refetchTable(tableBRElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableCmdFElt = root.getTable("COMMANDE_ELEMENT")).contains("RECU")) {
            AlterTable t7 = new AlterTable(tableCmdFElt);
            t7.addBooleanColumn("RECU_FORCED", Boolean.FALSE, false);
            t7.addBooleanColumn("RECU", Boolean.TRUE, false);
            t7.addDecimalColumn("QTE_RECUE", 16, 6, BigDecimal.ZERO, true);
            tableCmdFElt.getBase().getDataSource().execute(t7.asString());
            root.refetchTable(tableCmdFElt.getName());
            root.getSchema().updateVersion();
            SQLTable tableCmdCli = root.getTable("COMMANDE");
            SQLTable tableTR = root.getTable("TR_COMMANDE");
            SQLTable tableBR = root.getTable("BON_RECEPTION");
            String sel = "SELECT t.\"ID_COMMANDE\" FROM " + new SQLName(root.getName(), tableTR.getName()).quote() + " t ," + new SQLName(root.getName(), tableCmdCli.getName()).quote() + " c ," + new SQLName(root.getName(), tableBR.getName()).quote() + " b WHERE c.\"ID\"=t.\"ID_COMMANDE\"" + " AND b.\"ID\"=t.\"ID_BON_RECEPTION\" AND b.\"ARCHIVE\" = 0 AND t.\"ID\" > 1 AND c.\"ID\" > 1 AND t.\"ARCHIVE\" = 0 AND c.\"ARCHIVE\" = 0 GROUP BY t.\"ID_COMMANDE\" HAVING (SUM(b.\"TOTAL_HT\")>=SUM(c.\"T_HT\")) ";
            List cmd = tableTR.getDBSystemRoot().getDataSource().executeCol(sel);
            UpdateBuilder build = new UpdateBuilder(tableCmdFElt);
            build.set("QTE_RECUE", "\"QTE\"*\"QTE_UNITAIRE\"");
            build.setObject("RECU_FORCED", (Object)Boolean.TRUE);
            Where where = new Where(tableCmdFElt.getField("ID_COMMANDE"), cmd);
            build.setWhere(where);
        }
        if (!root.contains("FABRICANT")) {
            createTableEtat = new SQLCreateTable(root, "FABRICANT");
            createTableEtat.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("FABRICANT");
            root.getSchema().updateVersion();
            AlterTable alterA = new AlterTable(root.getTable("ARTICLE"));
            alterA.addForeignColumn("ID_FABRICANT", root.findTable("FABRICANT"));
            root.getBase().getDataSource().execute(alterA.asString());
            root.refetchTable("ARTICLE");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ETAT_DEMANDE_ACHAT_ELEMENT")) {
            createTableEtat = new SQLCreateTable(root, "ETAT_DEMANDE_ACHAT_ELEMENT");
            createTableEtat.addVarCharColumn("NOM", 256);
            createTableEtat.addIntegerColumn("COLOR", null, true);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("ETAT_DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
            rowVals = new SQLRowValues(root.getTable("ETAT_DEMANDE_ACHAT_ELEMENT"));
            rowVals.put("NOM", "En attente");
            rowVals.insert();
            rowVals.put("NOM", "Demande de prix");
            rowVals.insert();
            rowVals.put("NOM", "En commande");
            rowVals.insert();
            rowVals.put("NOM", "R\u00e9ceptionn\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "R\u00e9ception partielle");
            rowVals.insert();
            rowVals.put("NOM", "A relancer");
            rowVals.insert();
        }
        if (!root.contains("DEMANDE_ACHAT_ELEMENT")) {
            createTableDmd = new SQLCreateTable(root, "DEMANDE_ACHAT_ELEMENT");
            createTableDmd.addVarCharColumn("CODE", 256);
            createTableDmd.addVarCharColumn("NOM", 256);
            createTableDmd.addIntegerColumn("QTE", 1);
            createTableDmd.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            createTableDmd.addVarCharColumn("REPERE", 256);
            createTableDmd.addVarCharColumn("REFERENCE", 256);
            createTableDmd.addForeignColumn("FABRICANT");
            createTableDmd.addColumn("DATE", "date");
            createTableDmd.addForeignColumn("ETAT_DEMANDE_ACHAT_ELEMENT");
            createTableDmd.addForeignColumn("UNITE_VENTE");
            createTableDmd.addForeignColumn("ARTICLE");
            createTableDmd.addForeignColumn("FAMILLE_ARTICLE");
            createTableDmd.addForeignColumn("FOURNISSEUR");
            createTableDmd.addBooleanColumn("EN_STOCK", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(createTableDmd.asString());
            InstallationPanel.insertUndef(createTableDmd);
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ETAT_DEMANDE_PRIX")) {
            createTableEtat = new SQLCreateTable(root, "ETAT_DEMANDE_PRIX");
            createTableEtat.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("ETAT_DEMANDE_PRIX");
            root.getSchema().updateVersion();
            rowVals = new SQLRowValues(root.getTable("ETAT_DEMANDE_PRIX"));
            rowVals.put("NOM", "En attente");
            rowVals.insert();
            rowVals.put("NOM", "Refus\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "Accept\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "En cours");
            rowVals.insert();
        }
        if (!root.contains("DEMANDE_PRIX")) {
            createTableDmd = new SQLCreateTable(root, "DEMANDE_PRIX");
            createTableDmd.addVarCharColumn("NUMERO", 256);
            createTableDmd.addVarCharColumn("OBJET", 1024);
            createTableDmd.addForeignColumn("FOURNISSEUR");
            createTableDmd.addColumn("DATE", "date");
            createTableDmd.addColumn("DATE_BUTOIRE", "date");
            createTableDmd.addColumn("T_HT", "bigint DEFAULT 0");
            createTableDmd.addColumn("T_TVA", "bigint DEFAULT 0");
            createTableDmd.addColumn("T_TTC", "bigint DEFAULT 0");
            createTableDmd.addForeignColumn("COMMERCIAL");
            createTableDmd.addForeignColumn("ETAT_DEMANDE_PRIX");
            createTableDmd.addVarCharColumn("INFOS", 1024);
            root.getBase().getDataSource().execute(createTableDmd.asString());
            InstallationPanel.insertUndef(createTableDmd);
            root.refetchTable("DEMANDE_PRIX");
            root.getSchema().updateVersion();
            SQLCreateTable createTableDemandeMElt = new SQLCreateTable(root, "DEMANDE_PRIX_ELEMENT");
            createTableDemandeMElt.addVarCharColumn("NOM", 512);
            createTableDemandeMElt.addForeignColumn("DEMANDE_PRIX");
            createTableDemandeMElt.addForeignColumn("ID_TAXE", root.getTable("TAXE").getSQLName(), root.getTable("TAXE").getKey().getName(), "2");
            createTableDemandeMElt.addIntegerColumn("QTE", 0);
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_3", "real DEFAULT 0");
            createTableDemandeMElt.addColumn("PRIX_METRIQUE_VT_3", "bigint DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PA_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_2", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_1", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_PA_TTC", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_1", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("T_PA_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("T_POIDS", "real DEFAULT 0");
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_2", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_3", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_VT_2", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_VT_1", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_PV_TTC", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_1", root.findTable("METRIQUE"));
            SQLTable findTable = root.findTable("MODE_VENTE_ARTICLE");
            createTableDemandeMElt.addForeignColumn("ID_MODE_VENTE_ARTICLE", findTable.getSQLName(), findTable.getKey().getName(), String.valueOf(5));
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_3", root.findTable("METRIQUE"));
            createTableDemandeMElt.addForeignColumn("ID_STYLE", root.findTable("STYLE"));
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_2", root.findTable("METRIQUE"));
            createTableDemandeMElt.addIntegerColumn("QTE_ACHAT", 1);
            createTableDemandeMElt.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            createTableDemandeMElt.addForeignColumn("ID_FAMILLE_ARTICLE", root.findTable("FAMILLE_ARTICLE"));
            createTableDemandeMElt.addVarCharColumn("CODE", 256);
            createTableDemandeMElt.addColumn("SERVICE", "boolean DEFAULT false");
            createTableDemandeMElt.addDecimalColumn("T_PV_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PV_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("POIDS", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PA_DEVISE", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PA_DEVISE_T", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE"));
            createTableDemandeMElt.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            createTableDemandeMElt.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE"));
            createTableDemandeMElt.addVarCharColumn("DESCRIPTIF", 2048);
            createTableDemandeMElt.addIntegerColumn("NIVEAU", 1);
            createTableDemandeMElt.addForeignColumn("ID_ECO_CONTRIBUTION", root.findTable("ECO_CONTRIBUTION"));
            createTableDemandeMElt.addDecimalColumn("ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(createTableDemandeMElt.asString());
            InstallationPanel.insertUndef(createTableDemandeMElt);
            root.refetchTable("DEMANDE_PRIX_ELEMENT");
            root.getSchema().updateVersion();
            AlterTable alterNumero = new AlterTable(root.getTable("NUMEROTATION_AUTO"));
            alterNumero.addVarCharColumn("DMD_PRIX_FORMAT", 128);
            alterNumero.addIntegerColumn("DMD_PRIX_START", 1);
            root.getBase().getDataSource().execute(alterNumero.asString());
            root.refetchTable("NUMEROTATION_AUTO");
            root.getSchema().updateVersion();
            AlterTable alterCmd = new AlterTable(root.getTable("COMMANDE_ELEMENT"));
            alterCmd.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(alterCmd.asString());
            root.refetchTable("COMMANDE_ELEMENT");
            root.getSchema().updateVersion();
            AlterTable alterF = new AlterTable(root.getTable("FACTURE_FOURNISSEUR_ELEMENT"));
            alterF.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(alterF.asString());
            root.refetchTable("FACTURE_FOURNISSEUR_ELEMENT");
            root.getSchema().updateVersion();
            alterB5 = new AlterTable(root.getTable("BON_RECEPTION_ELEMENT"));
            ((ChangeTable)alterB5).addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(((ChangeTable)alterB5).asString());
            root.refetchTable("BON_RECEPTION_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!(tableDmdAChat = root.findTable("DEMANDE_ACHAT_ELEMENT")).contains("ID_FAMILLE_ARTICLE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_FAMILLE_ARTICLE", root.findTable("FAMILLE_ARTICLE"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_COMMANDE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_COMMANDE", root.findTable("COMMANDE"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_BON_RECEPTION")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_BON_RECEPTION", root.findTable("BON_RECEPTION"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("REPRISE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addBooleanColumn("REPRISE", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("IMPORT")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addBooleanColumn("IMPORT", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("QTE_RECUE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addIntegerColumn("QTE_RECUE", 0);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("REPERE_SOURCE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addVarCharColumn("REPERE_SOURCE", 128);
            alterB4.addVarCharColumn("CODE_SOURCE", 128);
            alterB4.addVarCharColumn("NOM_SOURCE", 128);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!(tableEtatDmdAChat = root.findTable("ETAT_DEMANDE_ACHAT_ELEMENT")).contains("COLOR")) {
            alterB3 = new AlterTable(tableEtatDmdAChat);
            alterB3.addIntegerColumn("COLOR", null, true);
            root.getBase().getDataSource().execute(alterB3.asString());
            root.refetchTable("ETAT_DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("T_HT")) {
            alterB3 = new AlterTable(tableDmdAChat);
            alterB3.addVarCharColumn("NUMERO_SE", 128);
            alterB3.addVarCharColumn("DESCRIPTIF_SE", 512);
            alterB3.addVarCharColumn("REVISION", 48);
            alterB3.addDecimalColumn("P_HT", 16, 6, BigDecimal.ZERO, false);
            alterB3.addDecimalColumn("T_HT", 16, 6, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB3.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("FACTURATION_COMMANDE_CLIENT")) {
            SQLCreateTable createTableEtat2 = new SQLCreateTable(root, "FACTURATION_COMMANDE_CLIENT");
            createTableEtat2.addVarCharColumn("NOM", 256);
            createTableEtat2.addIntegerColumn("TYPE_FACTURE", TypeFactureCommandeClient.GLOBALE.getId());
            createTableEtat2.addBooleanColumn("CHOICE", Boolean.FALSE, false);
            createTableEtat2.addForeignColumn("TYPE_REGLEMENT");
            createTableEtat2.addForeignColumn("COMMANDE_CLIENT");
            createTableEtat2.addForeignColumn("SAISIE_VENTE_FACTURE");
            createTableEtat2.addForeignColumn("MODELE");
            createTableEtat2.addIntegerColumn("AJOURS", 0);
            createTableEtat2.addDecimalColumn("MONTANT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat2.addDecimalColumn("POURCENT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat2.addBooleanColumn("COMPTANT", Boolean.FALSE, false);
            createTableEtat2.addColumn("DATE_PREVISIONNELLE", "date");
            root.getBase().getDataSource().execute(createTableEtat2.asString());
            InstallationPanel.insertUndef(createTableEtat2);
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableFacturationCmd = root.getTable("FACTURATION_COMMANDE_CLIENT")).contains("FIN_MOIS")) {
            alt = new AlterTable(tableFacturationCmd);
            alt.addBooleanColumn("FIN_MOIS", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alt.asString());
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!tableFacturationCmd.contains("LENJOUR")) {
            alt = new AlterTable(tableFacturationCmd);
            alt.addIntegerColumn("LENJOUR", 0);
            root.getBase().getDataSource().execute(alt.asString());
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CHIFFRAGE_COMMANDE_CLIENT")) {
            SQLCreateTable createTableEtat3 = new SQLCreateTable(root, "CHIFFRAGE_COMMANDE_CLIENT");
            createTableEtat3.addVarCharColumn("NOM", 256);
            createTableEtat3.addForeignColumn("COMMANDE_CLIENT");
            createTableEtat3.addForeignColumn("UNITE_VENTE");
            createTableEtat3.addForeignColumn("FAMILLE_ARTICLE");
            createTableEtat3.addDecimalColumn("QTE", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("PA_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("PV_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("T_PV_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("T_PA_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("MARGE", 16, 8, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTableEtat3.asString());
            InstallationPanel.insertUndef(createTableEtat3);
            root.refetchTable("CHIFFRAGE_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableVarSal = root.findTable("VARIABLE_SALARIE")).contains("HEURE_ABS_DEFAULT_VAL")) {
            AlterTable alterB6 = new AlterTable(root.getTable("VARIABLE_SALARIE"));
            for (SQLField sqlField : tableVarSal.getContentFields()) {
                String field = sqlField.getName();
                if (field.equalsIgnoreCase("ID_USER_COMMON_CREATE") || field.equalsIgnoreCase("ID_USER_COMMON_MODIFY") || field.equalsIgnoreCase("MODIFICATION_DATE") || field.equalsIgnoreCase("CREATION_DATE") || field.equalsIgnoreCase("HEURE_TRAV")) continue;
                alterB6.addColumn(String.valueOf(field) + "_DEFAULT_VAL", "real DEFAULT 0");
            }
            root.getBase().getDataSource().execute(alterB6.asString());
            root.refetchTable("VARIABLE_SALARIE");
            root.getSchema().updateVersion();
        }
        if (!(tableFpaye = root.findTable("FICHE_PAYE")).contains("TAXE_CM_SAL")) {
            AlterTable alterB7 = new AlterTable(tableFpaye);
            alterB7.addDecimalColumn("SAL_BASE_BRUT", 16, 2, BigDecimal.ZERO, false);
            alterB7.addDecimalColumn("TAXE_CM_SAL", 16, 2, BigDecimal.ZERO, false);
            alterB7.addDecimalColumn("TAXE_CM_PAT", 16, 2, BigDecimal.ZERO, false);
            alterB7.addDecimalColumn("SAL_BRUT_COTISABLE", 16, 2, BigDecimal.ZERO, false);
            alterB7.addDecimalColumn("SAL_BRUT_TAXABLE", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB7.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
            SQLTable tableElementPaye = root.getTable("FICHE_PAYE_ELEMENT");
            AlterTable tEltPaye = new AlterTable(tableElementPaye);
            tEltPaye.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(512)", "''", false);
            tableElementPaye.getBase().getDataSource().execute(tEltPaye.asString());
            tableElementPaye.getSchema().updateVersion();
            tableElementPaye.fetchFields();
        }
        if (!(tableCpaye = root.findTable("CUMULS_PAYE")).contains("TAXE_CM_SAL_C")) {
            alterB5 = new AlterTable(tableCpaye);
            ((ChangeTable)alterB5).addDecimalColumn("TAXE_CM_SAL_C", 16, 2, BigDecimal.ZERO, false);
            ((ChangeTable)alterB5).addDecimalColumn("TAXE_CM_PAT_C", 16, 2, BigDecimal.ZERO, false);
            ((ChangeTable)alterB5).addDecimalColumn("SAL_BRUT_COTISABLE_C", 16, 2, BigDecimal.ZERO, false);
            ((ChangeTable)alterB5).addDecimalColumn("SAL_BRUT_TAXABLE_C", 16, 2, BigDecimal.ZERO, false);
            ((ChangeTable)alterB5).addDecimalColumn("SAL_BASE_BRUT_C", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(((ChangeTable)alterB5).asString());
            root.refetchTable("CUMULS_PAYE");
            root.getSchema().updateVersion();
        }
        if (!(tableEtatCivil = root.findTable("ETAT_CIVIL")).contains("NATIONNALITE")) {
            AlterTable alterB8 = new AlterTable(tableEtatCivil);
            alterB8.addVarCharColumn("NATIONNALITE", 256);
            alterB8.addVarCharColumn("CNPS", 256);
            alterB8.addVarCharColumn("TYPE_PIECE_IDENTITE", 256);
            alterB8.addVarCharColumn("NUMERO_PIECE", 256);
            alterB8.addVarCharColumn("NOM_PERE", 256);
            alterB8.addVarCharColumn("NOM_MERE", 256);
            alterB8.addVarCharColumn("CONJOINT_NOM", 256);
            alterB8.addColumn("CONJOINT_DATE_NAISSANCE", "date");
            alterB8.addVarCharColumn("CONJOINT_LIEU_NAISSANCE", 256);
            alterB8.addVarCharColumn("CONJOINT_PROFESSION", 256);
            alterB8.addColumn("DATE_DEBUT_PIECE", "date");
            alterB8.addColumn("DATE_FIN_PIECE", "date");
            root.getBase().getDataSource().execute(alterB8.asString());
            root.refetchTable("ETAT_CIVIL");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ARTICLE_CODE_CLIENT")) {
            SQLCreateTable createTableEtat4 = new SQLCreateTable(root, "ARTICLE_CODE_CLIENT");
            createTableEtat4.addVarCharColumn("NOM", 512);
            createTableEtat4.addVarCharColumn("CODE", 512);
            createTableEtat4.addForeignColumn("CLIENT");
            createTableEtat4.addForeignColumn("ARTICLE");
            root.getBase().getDataSource().execute(createTableEtat4.asString());
            InstallationPanel.insertUndef(createTableEtat4);
            root.refetchTable("ARTICLE_CODE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableClient = root.getTable("CLIENT")).contains("CODE_FOURNISSEUR")) {
            AlterTable alter5 = new AlterTable(tableClient);
            alter5.addVarCharColumn("CODE_FOURNISSEUR", 256);
            tableCompte.getBase().getDataSource().execute(alter5.asString());
            tableCompte.getSchema().updateVersion();
            tableCompte.fetchFields();
        }
        if (!(tableArticle = root.getTable("ARTICLE")).contains("TARE")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addDecimalColumn("TARE", 16, 8, BigDecimal.ZERO, true);
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!tableArticle.contains("IFCO")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addIntegerColumn("IFCO", 0);
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!(tableFournisseur = root.getTable("FOURNISSEUR")).contains("NUMERO_TVA")) {
            AlterTable alter6 = new AlterTable(tableFournisseur);
            alter6.addVarCharColumn("NUMERO_TVA", 128);
            alter6.addVarCharColumn("SIRET", 128);
            tableFournisseur.getBase().getDataSource().execute(alter6.asString());
            tableFournisseur.getSchema().updateVersion();
            tableFournisseur.fetchFields();
        }
        SQLTable caisseT = root.getTable("CAISSE");
        String registerLogTableName = "CAISSE_JOURNAL";
        if (!root.contains("CAISSE_JOURNAL")) {
            SQLTable receiptT = root.getTable("TICKET_CAISSE");
            SQLTable userT = root.findTable("USER_COMMON", true);
            SQLCreateTable createLogT = new SQLCreateTable(caisseT.getDBRoot(), "CAISSE_JOURNAL");
            createLogT.setCreateOrder(false);
            AddMDFields.addFields(createLogT, userT);
            createLogT.addForeignColumn("ID_CAISSE", caisseT);
            createLogT.addDateAndTimeColumn("DATE");
            createLogT.addForeignColumn("ID_USER", userT);
            createLogT.addVarCharColumn("EVT", 128);
            createLogT.addVarCharColumn("CREATOR", 128);
            createLogT.addVarCharColumn("CREATOR_VERSION", 128);
            createLogT.addUniqueConstraint("logSequence", Arrays.asList("ID_CAISSE", "DATE"));
            SQLCreateTable createClotureT = new SQLCreateTable(caisseT.getDBRoot(), "CAISSE_CLOTURE");
            createClotureT.setCreateOrder(false);
            AddMDFields.addFields(createClotureT, userT);
            createClotureT.addForeignColumn("ID_ENTREE_JOURNAL", createLogT);
            createClotureT.addVarCharColumn("PERIODE", 32);
            String dateType = createClotureT.getSyntax().getTypeNames(Date.class).iterator().next();
            createClotureT.addColumn("DEBUT", dateType, null, false);
            createClotureT.addColumn("FIN", dateType, null, false);
            createClotureT.addDecimalColumn("TOTAL_TTC", 16, 6, BigDecimal.ZERO, false);
            createClotureT.addVarCharColumn("PREMIER_TICKET", 64, false, "null", true);
            createClotureT.addVarCharColumn("PREMIER_TICKET_HASH", 128, false, "null", true);
            createClotureT.addVarCharColumn("DERNIER_TICKET", 64, false, "null", true);
            createClotureT.addVarCharColumn("DERNIER_TICKET_HASH", 128, false, "null", true);
            createClotureT.addUniqueConstraint("uniqueness", Arrays.asList("ID_ENTREE_JOURNAL"));
            AlterTable alterRegister = new AlterTable(caisseT);
            alterRegister.addForeignColumn("ID_DERNIERE_ENTREE_JOURNAL", createLogT);
            alterRegister.addForeignColumn("ID_DERNIERE_CLOTURE", createClotureT);
            AlterTable alterReceipt = new AlterTable(receiptT);
            alterReceipt.addVarCharColumn("FILE_HASH", 128, false, "null", true);
            alterReceipt.addVarCharColumn("FILE_HASH_PREVIOUS", 128, false, "null", true);
            alterReceipt.addUniqueConstraint("uniqueNumber", new UniqueConstraintCreatorHelper((List)Arrays.asList("NUMERO"), TicketCaisseSQLElement.UNARCHIVED_WHERE){

                @Override
                public Object getObject(SQLSyntax s) {
                    if (s.getSystem() == SQLSystem.H2) {
                        return TicketCaisseSQLElement.UniqueNumber_PartialUniqueTrigger.class;
                    }
                    return super.getObject(s);
                }
            });
            alterReceipt.addUniqueConstraint("uniqueDate", new UniqueConstraintCreatorHelper((List)Arrays.asList("ID_CAISSE", "DATE"), TicketCaisseSQLElement.DATE_WHERE){

                @Override
                public Object getObject(SQLSyntax s) {
                    if (s.getSystem() == SQLSystem.H2) {
                        return TicketCaisseSQLElement.UniqueDate_PartialUniqueTrigger.class;
                    }
                    return super.getObject(s);
                }
            });
            root.createTables(createLogT, createClotureT);
            root.getDBSystemRoot().getDataSource().execute(alterRegister.asString());
            root.getDBSystemRoot().getDataSource().execute(alterReceipt.asString());
            caisseT.getSchema().updateVersion();
            alterRegister.getTable().fetchFields();
            alterReceipt.getTable().fetchFields();
        }
        if (!(tableArt = root.getTable("ARTICLE")).contains("MASQUE_CAISSE")) {
            alterArt = new AlterTable(tableArt);
            alterArt.addBooleanColumn("MASQUE_CAISSE", Boolean.FALSE, false);
            tableArt.getBase().getDataSource().execute(alterArt.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        if (!tableArt.contains("ADDITIONAL_TICKET_COPY")) {
            alterArt = new AlterTable(tableArt);
            alterArt.addBooleanColumn("ADDITIONAL_TICKET_COPY", Boolean.FALSE, false);
            tableArt.getBase().getDataSource().execute(alterArt.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        if (!(tableDevisAcompte = root.getTable("DEVIS")).contains("T_ACOMPTE")) {
            alterB2 = new AlterTable(tableDevisAcompte);
            alterB2.addLongColumn("T_ACOMPTE", 0L, false);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("DEVIS");
            root.getSchema().updateVersion();
            SQLTable tableEncaisse = root.getTable("ENCAISSER_MONTANT");
            AlterTable alterC = new AlterTable(tableEncaisse);
            alterC.addBooleanColumn("ACOMPTE", Boolean.FALSE, false);
            alterC.addForeignColumn("ID_DEVIS", tableDevisAcompte);
            root.getBase().getDataSource().execute(alterC.asString());
            root.refetchTable("ENCAISSER_MONTANT");
            root.getSchema().updateVersion();
            SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
            AlterTable alterF = new AlterTable(tableVF);
            alterF.addLongColumn("T_ACOMPTE", 0L, false);
            root.getBase().getDataSource().execute(alterF.asString());
            root.refetchTable("SAISIE_VENTE_FACTURE");
            root.getSchema().updateVersion();
        }
        if (!tableFpaye.contains("ALLEGEMENT_COTISATION")) {
            alterB2 = new AlterTable(tableFpaye);
            alterB2.addDecimalColumn("ALLEGEMENT_COTISATION", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("CICE", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("AVANTAGE_NATURE", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("HEURE_TRAV", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
            AlterTable alterC = new AlterTable(tableCpaye);
            alterC.addDecimalColumn("ALLEGEMENT_COTISATION_C", 16, 2, BigDecimal.ZERO, false);
            alterC.addDecimalColumn("CICE_C", 16, 2, BigDecimal.ZERO, false);
            alterC.addDecimalColumn("AVANTAGE_NATURE_C", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterC.asString());
            root.refetchTable("CUMULS_PAYE");
            root.getSchema().updateVersion();
        }
        if (!tableFpaye.contains("DETAILS_CONGES")) {
            alterB2 = new AlterTable(tableFpaye);
            alterB2.addVarCharColumn("DETAILS_CONGES", 512);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
        }
        if (!(tableFPayeElt = root.getTable("FICHE_PAYE_ELEMENT")).contains("ID_STYLE")) {
            alterB = new AlterTable(tableFPayeElt);
            alterB.addForeignColumn("ID_STYLE", root.getTable("STYLE"));
            root.getBase().getDataSource().execute(alterB.asString());
            root.refetchTable("FICHE_PAYE_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableVarSal.contains("IJSS_BRUT")) {
            alterB = new AlterTable(tableVarSal);
            List<String> f = Arrays.asList("IJSS_BRUT", "IJSS_NET", "FRAIS_PRO", "RBT_TRANSPORT");
            for (String field : f) {
                alterB.addColumn(field, "real DEFAULT 0");
                alterB.addColumn(String.valueOf(field) + "_DEFAULT_VAL", "real DEFAULT 0");
            }
            root.getBase().getDataSource().execute(alterB.asString());
            root.refetchTable(tableVarSal.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableDevis = root.getTable("DEVIS")).contains("ID_TAXE_PORT")) {
            AlterTable alterB9 = new AlterTable(tableDevis);
            alterB9.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
            root.getBase().getDataSource().execute(alterB9.asString());
            root.refetchTable(tableDevis.getName());
            root.getSchema().updateVersion();
        }
        List<String> tableRemiseF = Arrays.asList("COMMANDE", "BON_RECEPTION", "FACTURE_FOURNISSEUR");
        for (String t8 : tableRemiseF) {
            SQLTable tableCommande = root.getTable(t8);
            AlterTable tCommande = new AlterTable(tableCommande);
            boolean updateCmd = false;
            if (!tableCommande.contains("ID_TAXE_PORT")) {
                updateCmd = true;
                tCommande.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
            }
            if (!tableCommande.contains("PORT_HT")) {
                updateCmd = true;
                tCommande.addLongColumn("PORT_HT", 0L, false);
            }
            if (!tableCommande.contains("REMISE_HT")) {
                updateCmd = true;
                tCommande.addLongColumn("REMISE_HT", 0L, false);
            }
            if (!updateCmd) continue;
            tableCommande.getBase().getDataSource().execute(tCommande.asString());
            tableCommande.getSchema().updateVersion();
            tableCommande.fetchFields();
        }
        List<String> tableElement = Arrays.asList("FACTURE_FOURNISSEUR_ELEMENT", "COMMANDE_ELEMENT", "BON_RECEPTION_ELEMENT", "DEMANDE_PRIX_ELEMENT");
        for (String tableName : tableElement) {
            SQLTable table3 = root.getTable(tableName);
            if (table3.contains("ID_FAMILLE_ARTICLE")) continue;
            AlterTable t9 = new AlterTable(table3);
            t9.addForeignColumn("ID_FAMILLE_ARTICLE", root.getTable("FAMILLE_ARTICLE"));
            table3.getBase().getDataSource().execute(t9.asString());
            root.refetchTable(table3.getName());
            root.getSchema().updateVersion();
        }
        SQLTable tableBlElt = root.getTable("BON_RECEPTION_ELEMENT");
        if (!tableBlElt.contains("QTE_ORIGINE")) {
            AlterTable t10 = new AlterTable(tableBlElt);
            t10.addIntegerColumn("QTE_ORIGINE", null, true);
            tableBlElt.getBase().getDataSource().execute(t10.asString());
            root.refetchTable(tableBlElt.getName());
            root.getSchema().updateVersion();
        }
        if (!root.getTable("CAISSE_JOURNAL").contains("HOST_NAME")) {
            AlterTable alterRegisterLog = new AlterTable(root.getTable("CAISSE_JOURNAL"));
            alterRegisterLog.addVarCharColumn("HOST_NAME", 128, true, null, true);
            alterRegisterLog.addVarCharColumn("HOST_USER", 128, true, null, true);
            AlterTable alterRegister = new AlterTable(caisseT);
            alterRegister.dropColumn("ID_DERNIERE_ENTREE_JOURNAL");
            for (String sql : ChangeTable.cat(Arrays.asList(alterRegisterLog, alterRegister))) {
                root.getDBSystemRoot().getDataSource().execute(sql);
            }
            caisseT.getSchema().updateVersion();
            alterRegisterLog.getTable().fetchFields();
            alterRegister.getTable().fetchFields();
        }
        if (!(table = root.findTable("PREFS_COMPTE")).getFieldsName().contains("ID_JOURNAL_AN")) {
            t = new AlterTable(table);
            t.addForeignColumn("ID_JOURNAL_AN", root.getTable("JOURNAL"));
            t.addBooleanColumn("CREATE_NUL_SOLDE_ECR", Boolean.TRUE, false);
            table.getBase().getDataSource().execute(t.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!table.getFieldsName().contains("AUTO_LETTRAGE")) {
            t = new AlterTable(table);
            t.addBooleanColumn("AUTO_LETTRAGE", Boolean.FALSE, false);
            table.getBase().getDataSource().execute(t.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!(tableEcr = root.getTable("ECRITURE")).contains("CLOTURE")) {
            AlterTable alter7 = new AlterTable(tableEcr);
            alter7.addBooleanColumn("CLOTURE", Boolean.FALSE, false);
            alter7.addBooleanColumn("RAN", Boolean.FALSE, false);
            tableEcr.getBase().getDataSource().execute(alter7.asString());
            tableEcr.getSchema().updateVersion();
            tableEcr.fetchFields();
        }
        if (!(tkmElt = root.getTable("SAISIE_KM_ELEMENT")).contains("JOUR")) {
            AlterTable alterKmElt = new AlterTable(tkmElt);
            alterKmElt.addIntegerColumn("JOUR", 1);
            tkmElt.getBase().getDataSource().execute(alterKmElt.asString());
            tkmElt.getSchema().updateVersion();
            tkmElt.fetchFields();
        }
        for (SQLTable bankT : Arrays.asList(tableFournisseur, tClient)) {
            if (bankT.contains("IBAN")) continue;
            alter = new AlterTable(bankT);
            alter.addVarCharColumn("IBAN", 128);
            alter.addVarCharColumn("BIC", 128);
            bankT.getDBSystemRoot().getDataSource().execute(alter.asString());
            bankT.getSchema().updateVersion();
            bankT.fetchFields();
        }
        SQLTable typeReglT = root.getTable("TYPE_REGLEMENT");
        if (typeReglT.getRow(10) == null) {
            SQLRowValues directDebitVals = new SQLRowValues(typeReglT).put("NOM", "Pr\u00e9l\u00e8vement");
            directDebitVals.put("COMPTANT", Boolean.FALSE).put("ECHEANCE", Boolean.FALSE);
            directDebitVals.setID(10).insertVerbatim();
        }
        if (!tableClient.contains("ACCEPTE_EMAIL")) {
            AlterTable alter8 = new AlterTable(tableClient);
            alter8.addBooleanColumn("ACCEPTE_EMAIL", Boolean.FALSE, false);
            alter8.addBooleanColumn("ACCEPTE_COURRIER", Boolean.FALSE, false);
            alter8.addBooleanColumn("ACCEPTE_SMS", Boolean.FALSE, false);
            alter8.addBooleanColumn("ACCEPTE_TEL", Boolean.FALSE, false);
            Updater_1_5.exec(alter8);
        }
        if (!(contactT = root.getTable("CONTACT")).contains("DATE_NAISSANCE")) {
            alter = new AlterTable(contactT);
            alter.addColumn("DATE_NAISSANCE", "date");
            Updater_1_5.exec(alter);
        }
        if ((createSDDMsgTable = SDDMessageSQLElement.getCreateTable(root)) != null) {
            SQLCreateTable createMandate = SEPAMandateSQLElement.getCreateTable(root);
            root.createTables(createSDDMsgTable, createMandate);
            SQLTable msgT = root.getTable(createSDDMsgTable.getName());
            SQLTable mandateT = root.getTable(createMandate.getName());
            AlterTable alterFact = new AlterTable(root.getTable("SAISIE_VENTE_FACTURE"));
            alterFact.addForeignColumn("ID_SDD_MESSAGE", msgT);
            alterFact.addVarCharColumn("SDD_EndToEndId", 35);
            AlterTable alterModeRegl = new AlterTable(root.getTable("MODE_REGLEMENT"));
            alterModeRegl.addForeignColumn(null, mandateT);
            for (String sql : ChangeTable.cat(Arrays.asList(alterFact, alterModeRegl))) {
                root.getDBSystemRoot().getDataSource().execute(sql);
            }
            root.getSchema().updateVersion();
            root.refetch(CollectionUtils.createSet(alterFact.getName(), alterModeRegl.getName()));
            root.setMetadata("SDD_MESSAGE_SERIAL", "0");
        }
        if (!(vcT = root.getTable("SAISIE_VENTE_COMPTOIR")).contains("ID_COMPTE_PCE_PRODUIT")) {
            AlterTable alter9 = new AlterTable(vcT);
            alter9.addForeignColumn("ID_COMPTE_PCE_PRODUIT", root.getTable("COMPTE_PCE"));
            alter9.addForeignColumn("ID_COMPTE_PCE_SERVICE", root.getTable("COMPTE_PCE"));
            Updater_1_5.exec(alter9);
        }
    }

    public static void exec(AlterTable alter) throws SQLException {
        alter.getTable().getDBSystemRoot().getDataSource().execute(alter.asString());
        alter.getTable().getSchema().updateVersion();
        alter.getTable().fetchFields();
    }
}

