/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ExtensionMimeDetector
extends MimeDetector {
    private static Logger log = Logger.getLogger(ExtensionMimeDetector.class.getName());
    private static Map extMimeTypes;

    public ExtensionMimeDetector() {
        ExtensionMimeDetector.initMimeTypes();
    }

    @Override
    public String getDescription() {
        return "Get the mime types of file extensions";
    }

    public Collection getMimeTypesFile(File file) throws MimeException {
        return this.getMimeTypesFileName(file.getName());
    }

    public Collection getMimeTypesURL(URL url) throws MimeException {
        return this.getMimeTypesFileName(url.getPath());
    }

    public Collection getMimeTypesFileName(String fileName) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        String fileExtension = MimeUtil.getExtension(fileName);
        while (fileExtension.length() != 0) {
            String types = null;
            types = (String)extMimeTypes.get(fileExtension);
            if (types != null) {
                String[] mimeTypeArray = types.split(",");
                int i = 0;
                while (i < mimeTypeArray.length) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                    ++i;
                }
                return mimeTypes;
            }
            if (mimeTypes.isEmpty() && (types = (String)extMimeTypes.get(fileExtension.toLowerCase())) != null) {
                String[] mimeTypeArray = types.split(",");
                int i = 0;
                while (i < mimeTypeArray.length) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                    ++i;
                }
                return mimeTypes;
            }
            fileExtension = MimeUtil.getExtension(fileExtension);
        }
        return mimeTypes;
    }

    /*
     * Unable to fully structure code
     */
    private static void initMimeTypes() {
        is = null;
        ExtensionMimeDetector.extMimeTypes = new Properties();
        try {
            block34: {
                block32: {
                    block30: {
                        try {
                            try {
                                is = MimeUtil.class.getClassLoader().getResourceAsStream("eu/medsea/mimeutil/mime-types.properties");
                                if (is != null) {
                                    ((Properties)ExtensionMimeDetector.extMimeTypes).load(is);
                                }
                            }
                            catch (Exception e) {
                                ExtensionMimeDetector.log.severe("Error loading internal mime-types.properties");
                                is = ExtensionMimeDetector.closeStream(is);
                                break block30;
                            }
                        }
                        catch (Throwable var2_6) {
                            is = ExtensionMimeDetector.closeStream(is);
                            throw var2_6;
                        }
                        is = ExtensionMimeDetector.closeStream(is);
                    }
                    try {
                        try {
                            f = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".mime-types.properties");
                            if (f.exists() && (is = new FileInputStream(f)) != null) {
                                ExtensionMimeDetector.log.info("Found a custom .mime-types.properties file in the users home directory.");
                                props = new Properties();
                                props.load(is);
                                if (props.size() > 0) {
                                    ExtensionMimeDetector.extMimeTypes.putAll(props);
                                }
                                ExtensionMimeDetector.log.info("Successfully parsed .mime-types.properties from users home directory.");
                            }
                        }
                        catch (Exception e) {
                            ExtensionMimeDetector.log.severe("Failed to parse .magic.mime file from users home directory. File will be ignored.");
                            is = ExtensionMimeDetector.closeStream(is);
                            break block32;
                        }
                    }
                    catch (Throwable var3_8) {
                        is = ExtensionMimeDetector.closeStream(is);
                        throw var3_8;
                    }
                    is = ExtensionMimeDetector.closeStream(is);
                }
                try {
                    try {
                        e = MimeUtil.class.getClassLoader().getResources("mime-types.properties");
                        while (e.hasMoreElements()) {
                            url = e.nextElement();
                            props = new Properties();
                            try {
                                is = url.openStream();
                                if (is == null) continue;
                                props.load(is);
                                if (props.size() <= 0) continue;
                                ExtensionMimeDetector.extMimeTypes.putAll(props);
                            }
                            catch (Exception ex) {
                                ExtensionMimeDetector.log.severe("Failed while loading custom mime-type.properties file [" + url + "] from classpath. File will be ignored.");
                            }
                        }
                    }
                    catch (Exception e) {
                        ExtensionMimeDetector.log.severe("Problem while processing mime-types.properties files(s) from classpath. Files will be ignored.");
                        is = ExtensionMimeDetector.closeStream(is);
                        break block34;
                    }
                }
                catch (Throwable var5_12) {
                    is = ExtensionMimeDetector.closeStream(is);
                    throw var5_12;
                }
                is = ExtensionMimeDetector.closeStream(is);
            }
            try {
                try {
                    fname = System.getProperty("mime-mappings");
                    if (fname != null && fname.length() != 0 && (is = new FileInputStream(fname)) != null) {
                        ExtensionMimeDetector.log.info("Found a custom mime-mappings property defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                        props = new Properties();
                        props.load(is);
                        if (props.size() > 0) {
                            ExtensionMimeDetector.extMimeTypes.putAll(props);
                        }
                        ExtensionMimeDetector.log.info("Successfully loaded the mime mappings file from property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                    }
                }
                catch (Exception ex) {
                    ExtensionMimeDetector.log.severe("Failed to load the mime-mappings file defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                    is = ExtensionMimeDetector.closeStream(is);
                }
            }
            catch (Throwable var3_10) {
                is = ExtensionMimeDetector.closeStream(is);
                throw var3_10;
            }
            is = ExtensionMimeDetector.closeStream(is);
        }
        finally {
            it = ExtensionMimeDetector.extMimeTypes.values().iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            types = ((String)it.next()).split(",");
            i = 0;
            while (i < types.length) {
                MimeUtil.addKnownMimeType(types[i]);
                ++i;
            }
            continue;
        }
lbl99:
        // 1 sources

    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from streams.");
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from byte arrays.");
    }
}

