/*
 * Decompiled with CFR 0.152.
 */
package ds.desktop.notify;

import ds.desktop.notify.DesktopNotify;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.swing.ImageIcon;

public class NotifyTheme {
    protected Font titleFont;
    protected Font contentFont;
    protected Color borderColor;
    protected Color titleColor;
    protected Color contentColor;
    protected Color[] bgGrad;
    protected Image[] iconSet;
    public static final NotifyTheme Dark;
    public static final NotifyTheme Light;
    public static final Image[] defaultIconSet;

    public Color[] getBgGrad() {
        return new Color[]{this.bgGrad[0], this.bgGrad[21]};
    }

    public void setBgGrad(Color base, Color highlight) {
        this.bgGrad = new Color[22];
        this.bgGrad[0] = base;
        for (int i = 0; i < this.bgGrad.length - 1; ++i) {
            this.bgGrad[i + 1] = new Color(base.getRed() + (int)((float)((highlight.getRed() - base.getRed()) * i) / 20.0f), base.getGreen() + (int)((float)((highlight.getGreen() - base.getGreen()) * i) / 20.0f), base.getBlue() + (int)((float)((highlight.getBlue() - base.getBlue()) * i) / 20.0f), 120 + (int)((float)(135 * i) / 20.0f));
        }
    }

    public Font getContentFont() {
        return this.contentFont;
    }

    public void setContentFont(Font contentFont) {
        this.contentFont = contentFont;
    }

    public Image[] getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(Image[] iconSet) {
        if (iconSet.length < 8) {
            throw new IllegalArgumentException("The supplied array of images must contain 8 icons!");
        }
        this.iconSet = iconSet;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color notifBorder) {
        this.borderColor = notifBorder;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    static {
        defaultIconSet = new Image[8];
        for (int i = 0; i < defaultIconSet.length; ++i) {
            NotifyTheme.defaultIconSet[i] = new ImageIcon(DesktopNotify.class.getResource("img/" + (i + 1) + ".png")).getImage();
        }
        Dark = new DarkTheme();
        Light = new LightTheme();
    }

    public static class LightTheme
    extends NotifyTheme {
        public LightTheme() {
            this.titleFont = new Font("Verdana", 1, 14);
            this.contentFont = new Font("Verdana", 0, 12);
            this.borderColor = new Color(200, 200, 200);
            this.titleColor = Color.BLACK;
            this.contentColor = Color.BLACK;
            this.iconSet = defaultIconSet;
            this.setBgGrad(new Color(240, 240, 240), new Color(169, 185, 201));
        }
    }

    public static class DarkTheme
    extends NotifyTheme {
        public DarkTheme() {
            this.titleFont = new Font("Verdana", 1, 14);
            this.contentFont = new Font("Verdana", 0, 12);
            this.borderColor = new Color(50, 50, 50);
            this.titleColor = Color.WHITE;
            this.contentColor = Color.WHITE;
            this.iconSet = defaultIconSet;
            this.setBgGrad(new Color(50, 50, 50), new Color(59, 75, 91));
        }
    }
}

