/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.sync.FileProperty;
import org.openconcerto.utils.sync.HashWriter;
import org.openconcerto.utils.sync.MoveOperation;
import org.openconcerto.utils.sync.MoveOperationList;
import org.openconcerto.utils.sync.Range;
import org.openconcerto.utils.sync.RangeList;
import org.openconcerto.utils.sync.RollingChecksum32;
import org.openconcerto.utils.sync.StreamUtils;

public class SyncClient {
    private long byteSent;
    private long byteReceived;
    private long byteSyncDownload;
    private long byteSyncUpload;
    private long filesSyncDownload;
    private long filesSyncUpload;
    private String baseUrl = "http://127.0.0.1:80";
    private boolean verifyHost = true;
    public static final HostnameVerifier HostnameNonVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            SyncClient.printUsage();
            return;
        }
        String token = "";
        SyncClient c = new SyncClient();
        String command = args[0];
        if (command.equalsIgnoreCase("put")) {
            String from = args[1];
            String to = args[2];
            String remotePath = c.setServerUrlFrom(to);
            if (remotePath != null) {
                File localFile = new File(from);
                if (!localFile.exists()) {
                    System.out.println(String.valueOf(localFile.getAbsolutePath()) + " does not exist");
                    return;
                }
                if (!localFile.isDirectory()) {
                    String remoteName = to.endsWith("/") ? localFile.getName() : to.substring(to.lastIndexOf("/") + 1);
                    c.sendFile(localFile, remotePath, remoteName);
                } else {
                    c.sendDirectory(localFile, remotePath);
                }
                c.dumpStat();
            }
            return;
        }
        if (command.equalsIgnoreCase("get")) {
            String rPath = c.setServerUrlFrom(args[1]);
            String to = args[2];
            File dir = new File(to);
            if (dir.isFile()) {
                System.out.println(String.valueOf(dir.getAbsolutePath()) + " is not a directory");
                return;
            }
            dir.mkdirs();
            if (rPath.endsWith("/")) {
                c.retrieveDirectory(dir, rPath, token);
                c.dumpStat();
            } else {
                String remoteName = rPath;
                String remotePath = "/";
                if (rPath.contains("/")) {
                    int i = rPath.lastIndexOf(47);
                    remotePath = rPath.substring(0, i);
                    remoteName = rPath.substring(i + 1);
                }
                try {
                    c.retrieveFile(dir, remotePath, remoteName, token);
                    c.dumpStat();
                }
                catch (FileNotFoundException e) {
                    System.out.println("The file you are trying to download does not exists. If you are trying to download a directory, just add a / ");
                }
            }
            return;
        }
        if (command.equalsIgnoreCase("list")) {
            String url = args[1];
            if (!url.startsWith("http://")) {
                System.out.println(String.valueOf(url) + " is not an http url, exiting.");
                return;
            }
            int n = url.substring(7).indexOf(47);
            if (n <= 2) {
                System.out.println("invalid url " + url);
                return;
            }
            c.baseUrl = url.substring(0, 7 + n);
            String remothPath = url.substring(7 + n);
            try {
                c.listDirectory(remothPath, token);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(remothPath) + " does not exist on the server");
            }
            return;
        }
        if (command.equalsIgnoreCase("del") || command.equalsIgnoreCase("rm") || command.equalsIgnoreCase("delete") || command.equalsIgnoreCase("remove")) {
            System.out.println("My coder said I'm not allowed to delete files today. Sorry.");
            return;
        }
        System.out.println("Only commands put, get and list are allowed.");
        SyncClient.printUsage();
    }

    private void sendDirectory(File localDir, String remotePath) throws Exception {
        if (!remotePath.endsWith("/")) {
            remotePath = String.valueOf(remotePath) + "/";
        }
        File[] fl = localDir.listFiles();
        int i = 0;
        while (i < fl.length) {
            File file = fl[i];
            if (file.isDirectory()) {
                this.sendDirectory(file, String.valueOf(remotePath) + file.getName());
            } else {
                this.sendFile(file, remotePath, file.getName());
            }
            ++i;
        }
    }

    public SyncClient() {
    }

    public SyncClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private String setServerUrlFrom(String url) {
        if (!url.startsWith("http://") || !url.startsWith("https://")) {
            System.out.println(String.valueOf(url) + " is not an http url, exiting.");
            return null;
        }
        int n = url.substring(7).indexOf(47);
        if (n <= 2) {
            System.out.println("invalid url " + url);
            return null;
        }
        this.baseUrl = url.substring(0, 7 + n);
        String remothPath = url.substring(7 + n);
        return remothPath;
    }

    private static void printUsage() {
        System.out.println("SyncClient usage examples:");
        System.out.println("Upload");
        System.out.println("To upload a file:           java -jar sync.jar put  /etc/fstab http://16.105.9.190:80/backup/fstabOk");
        System.out.println("To upload a directory:      java -jar sync.jar put  /etc/      http://16.105.9.190:80/backup/etc/");
        System.out.println("Download");
        System.out.println("To download a file:         java -jar sync.jar get  http://16.105.9.190:80/backup/fstabOk /tmp/");
        System.out.println("To download a directory:    java -jar sync.jar get  http://16.105.9.190:80/backup/        /tmp/");
        System.out.println("To list a remote directory: java -jar sync.jar list http://16.105.9.190:80/backup/");
        System.out.println("Note: directory synchronization is recursive");
    }

    public void dumpStat() {
        System.out.println("SyncClient statistics");
        System.out.println("Download:");
        System.out.println("- files received: " + this.filesSyncDownload);
        System.out.println("- bytes sync'ed :" + this.byteSyncDownload);
        System.out.print("- bytes received: " + this.byteReceived);
        if (this.byteSyncDownload > 0L) {
            System.out.println(" (" + 100.0f * (float)this.byteReceived / (float)this.byteSyncDownload + "%)");
        } else {
            System.out.println();
        }
        System.out.println("Upload:");
        System.out.println("- files sent: " + this.filesSyncUpload);
        System.out.println("- bytes sync'ed :" + this.byteSyncUpload);
        System.out.print("- bytes sent: " + this.byteSent);
        if (this.byteSyncUpload > 0L) {
            System.out.println(" (" + 100.0f * (float)this.byteSent / (float)this.byteSyncUpload + "%)");
        } else {
            System.out.println();
        }
    }

    public void sendFile(File localFile, String remotePath, String remoteName) throws Exception {
        this.sendFile(localFile, remotePath, remoteName, null);
    }

    public void sendFile(File localFile, String remotePath, String remoteName, String token) throws Exception {
        if (localFile == null) {
            throw new IllegalArgumentException("null file");
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException(String.valueOf(localFile.getAbsolutePath()) + " does not exist");
        }
        ++this.filesSyncUpload;
        String data = String.valueOf(URLEncoder.encode("rp", "UTF-8")) + "=" + URLEncoder.encode(remotePath, "UTF-8");
        data = String.valueOf(data) + "&" + URLEncoder.encode("rn", "UTF-8") + "=" + URLEncoder.encode(remoteName, "UTF-8");
        if (token != null) {
            data = String.valueOf(data) + "&" + URLEncoder.encode("tk", "UTF-8") + "=" + URLEncoder.encode(token, "UTF-8");
        }
        this.byteSent += (long)data.getBytes().length;
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/getHash");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        wr.close();
        byte[] localFileHash = null;
        int localFileSize = (int)localFile.length();
        RangeList rangesOk = new RangeList(localFileSize);
        MoveOperationList moves = new MoveOperationList();
        this.byteSyncUpload = localFileSize;
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
            int remoteFileSize = in.readInt();
            this.byteReceived += 4L;
            float a = (float)remoteFileSize / 1024.0f;
            int nb = (int)Math.ceil(a);
            HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>(nb * 2 + 1);
            HashMap<Integer, Integer> mapBlock = new HashMap<Integer, Integer>(nb * 2 + 1);
            int i = 0;
            while (i < nb) {
                byte[] b = new byte[16];
                int r32 = in.readInt();
                in.read(b);
                this.byteReceived += 20L;
                map.put(r32, b);
                mapBlock.put(r32, i);
                ++i;
            }
            byte[] remoteFileHash = new byte[32];
            in.read(remoteFileHash);
            this.byteReceived += 32L;
            in.close();
            if (localFileSize == remoteFileSize && HashWriter.compareHash(localFileHash = HashWriter.getHash(localFile), remoteFileHash)) {
                return;
            }
            if (localFileSize > 0) {
                RollingChecksum32 checksum = new RollingChecksum32();
                byte[] buffer = new byte[1024];
                BufferedInputStream fb = new BufferedInputStream(new FileInputStream(localFile));
                int read = fb.read(buffer);
                this.byteReceived += (long)read;
                checksum.check(buffer, 0, read);
                int v = 0;
                int start = 0;
                MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                do {
                    int r32;
                    byte[] md5;
                    if ((md5 = (byte[])map.get(r32 = checksum.getValue())) != null) {
                        md5Digest.reset();
                        md5Digest.update(buffer);
                        byte[] localMd5 = md5Digest.digest();
                        if (HashWriter.compareHash(md5, localMd5)) {
                            int offset = (Integer)mapBlock.get(r32) * 1024;
                            MoveOperation m = new MoveOperation(offset, start, 1024);
                            moves.add(m);
                            rangesOk.add(new Range(start, start + 1024));
                        }
                    }
                    v = fb.read();
                    ++start;
                    System.arraycopy(buffer, 1, buffer, 0, buffer.length - 1);
                    buffer[buffer.length - 1] = (byte)v;
                    checksum.roll((byte)v);
                } while (v >= 0);
                fb.close();
            }
        }
        catch (FileNotFoundException in) {
            // empty catch block
        }
        if (localFileHash == null) {
            localFileHash = HashWriter.getHash(localFile);
        }
        try {
            this.sendDelta(localFile, remotePath, remoteName, moves, rangesOk.getUnusedRanges(), localFileHash, token);
        }
        catch (Exception e) {
            System.err.println("SyncClient.sendFile() Unable to send delta: " + localFile.getAbsolutePath() + " to " + remoteName + " " + moves);
            rangesOk.dump();
            try {
                System.err.println("SyncClient.sendFile() sending complete file");
                this.sendCompleteFile(localFile, remotePath, remoteName, token);
            }
            catch (Exception e2) {
                System.err.println("SyncClient.sendFile() Unable to send complete file");
                throw e2;
            }
        }
    }

    private void sendCompleteFile(File localFile, String remotePath, String remoteName, String token) throws Exception {
        byte[] localFileHash = HashWriter.getHash(localFile);
        MoveOperationList noMoves = new MoveOperationList();
        ArrayList<Range> rangesToSend = new ArrayList<Range>(1);
        rangesToSend.add(new Range(0, (int)localFile.length()));
        this.sendDelta(localFile, remotePath, remoteName, noMoves, rangesToSend, localFileHash, token);
    }

    private void sendDelta(File localFile, String remotePath, String remoteName, MoveOperationList moves, List<Range> rangesToSend, byte[] localFileHash, String token) throws IOException {
        if (token == null) {
            token = "";
        }
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/putFile");
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(conn.getOutputStream())){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                SyncClient syncClient = SyncClient.this;
                syncClient.byteSent = syncClient.byteSent + (long)len;
                super.write(b, off, len);
            }

            @Override
            public synchronized void write(int b) throws IOException {
                SyncClient syncClient = SyncClient.this;
                syncClient.byteSent = syncClient.byteSent + 1L;
                super.write(b);
            }
        });
        wr.writeUTF(remotePath);
        wr.writeUTF(remoteName);
        wr.writeUTF(token);
        wr.write(localFileHash);
        wr.writeInt((int)localFile.length());
        moves.write(wr);
        wr.writeInt(rangesToSend.size());
        RandomAccessFile rIn = new RandomAccessFile(localFile, "r");
        for (Range r : rangesToSend) {
            rIn.seek(r.getStart());
            byte[] buffer = new byte[r.getStop() - r.getStart()];
            rIn.readFully(buffer);
            wr.writeInt(r.getStart());
            wr.writeInt(r.getStop());
            wr.write(buffer);
        }
        rIn.close();
        wr.flush();
        wr.close();
        DataInputStream in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        this.byteReceived += 32L;
        byte[] rHash = new byte[32];
        in.read(rHash);
        in.close();
        if (!HashWriter.compareHash(localFileHash, rHash)) {
            throw new IllegalStateException("Hash error");
        }
    }

    public void retrieveDirectory(File dir, String remotePath, String token) throws Exception {
        ArrayList<FileProperty> list = null;
        try {
            list = this.getList(remotePath, token);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve the file list of " + remotePath, e);
        }
        int i = 0;
        while (i < list.size()) {
            FileProperty fp = list.get(i);
            if (!fp.isDirectory()) {
                this.retrieveFile(dir, remotePath, fp.getName(), fp.getSize(), fp.getSha256(), token);
            } else {
                File dir2 = new File(dir, fp.getName());
                dir2.mkdirs();
                this.retrieveDirectory(dir2, String.valueOf(remotePath) + "/" + fp.getName(), token);
            }
            ++i;
        }
    }

    public void listDirectory(String remotePath, String token) throws Exception {
        ArrayList<FileProperty> list = this.getList(remotePath, token);
        Collections.sort(list);
        int size = list.size();
        int maxSize = -1;
        int i = 0;
        while (i < size) {
            int s = list.get(i).getSize();
            if (s > maxSize) {
                maxSize = s;
            }
            ++i;
        }
        int lSize = (" " + maxSize).length();
        if (maxSize < 0) {
            lSize = 0;
        }
        SimpleDateFormat spd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i2 = 0;
        while (i2 < size) {
            FileProperty fp = list.get(i2);
            if (lSize > 0) {
                if (fp.getSize() >= 0) {
                    System.out.print(SyncClient.rightAlign(String.valueOf(fp.getSize()), lSize));
                } else {
                    System.out.print(SyncClient.rightAlign("", lSize));
                }
                System.out.print(" " + spd.format(fp.getDate()));
                System.out.println(" " + fp.getName());
            } else {
                System.out.println(fp.getName());
            }
            ++i2;
        }
    }

    public static String rightAlign(String s, int width) {
        String r = s;
        int n = width - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(' ') + r;
            ++i;
        }
        return r;
    }

    public ArrayList<FileProperty> getList(String remotePath, String token) throws UnsupportedEncodingException, MalformedURLException, IOException {
        String data = "rp=" + URLEncoder.encode(remotePath, "UTF-8");
        if (token != null) {
            data = String.valueOf(data) + "&tk=" + URLEncoder.encode(token, "UTF-8");
        }
        this.byteSent += (long)data.getBytes().length;
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/getDir");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        wr.close();
        DataInputStream in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        int fileCount = in.readInt();
        this.byteReceived += 4L;
        ArrayList<FileProperty> list = new ArrayList<FileProperty>();
        int i = 0;
        while (i < fileCount) {
            String fileName = in.readUTF();
            this.byteReceived += (long)fileName.getBytes().length;
            int fileSize = in.readInt();
            this.byteReceived += 4L;
            long fileDate = in.readLong();
            this.byteReceived += 8L;
            byte[] sha256 = new byte[32];
            if (fileSize >= 0) {
                in.read(sha256);
                this.byteReceived += 32L;
            }
            FileProperty fp = new FileProperty(fileName, fileSize, fileDate, sha256);
            list.add(fp);
            ++i;
        }
        in.close();
        return list;
    }

    public void retrieveFile(File dir, String remotePath, String remoteName, String token) throws Exception {
        String data = "rp=" + URLEncoder.encode(remotePath, "UTF-8");
        data = String.valueOf(data) + "&rn=" + URLEncoder.encode(remoteName, "UTF-8");
        data = String.valueOf(data) + "&shaOnly=" + URLEncoder.encode("true", "UTF-8");
        if (token != null) {
            data = String.valueOf(data) + "&tk=" + URLEncoder.encode(token, "UTF-8");
        }
        this.byteSent += (long)data.getBytes().length;
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/getHash");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        wr.close();
        DataInputStream in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        int fileSize = in.readInt();
        this.byteReceived += 4L;
        byte[] fileHash = new byte[32];
        in.read(fileHash);
        this.byteReceived += 32L;
        in.close();
        this.retrieveFile(dir, remotePath, remoteName, fileSize, fileHash, token);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveFile(File dir, String remotePath, String remoteName, int fileSize, byte[] fileHash, String token) throws IOException, Exception {
        byte[] fileLocalHash;
        ++this.filesSyncDownload;
        this.byteSyncDownload += (long)fileSize;
        File localFile = this.resolveFile(dir, remoteName);
        if (!localFile.exists()) {
            this.downloadFile(localFile, remotePath, remoteName, fileSize, token);
            byte[] fileLocalHash2 = HashWriter.getHash(localFile);
            if (HashWriter.compareHash(fileHash, fileLocalHash2)) return;
            throw new IllegalStateException("Full download failed. Hash error");
        }
        boolean needToResync = false;
        if (localFile.length() != (long)fileSize) {
            needToResync = true;
        } else {
            fileLocalHash = HashWriter.getHash(localFile);
            if (!HashWriter.compareHash(fileHash, fileLocalHash)) {
                needToResync = true;
            }
        }
        if (!needToResync) return;
        if (localFile.length() > 1024L) {
            try {
                this.retrieveFileWithDelta(localFile, remotePath, remoteName, token);
                return;
            }
            catch (Exception e) {
                System.err.println("SyncClient.retrieveFile() failed for " + remotePath + " " + remoteName);
                System.err.println("SyncClient.retrieveFile() fallback to plain download");
                this.downloadFile(localFile, remotePath, remoteName, fileSize, token);
                byte[] fileLocalHash3 = HashWriter.getHash(localFile);
                if (HashWriter.compareHash(fileHash, fileLocalHash3)) return;
                throw new IllegalStateException("Full download failed. Hash error");
            }
        } else {
            this.downloadFile(localFile, remotePath, remoteName, fileSize, token);
            fileLocalHash = HashWriter.getHash(localFile);
            if (HashWriter.compareHash(fileHash, fileLocalHash)) return;
            throw new IllegalStateException("Full download failed. Hash error");
        }
    }

    private void retrieveFileWithDelta(File localFile, String remotePath, String remoteName, String token) throws Exception {
        String data = String.valueOf(URLEncoder.encode("rp", "UTF-8")) + "=" + URLEncoder.encode(remotePath, "UTF-8");
        data = String.valueOf(data) + "&" + URLEncoder.encode("rn", "UTF-8") + "=" + URLEncoder.encode(remoteName, "UTF-8");
        if (token != null) {
            data = String.valueOf(data) + "&tk=" + URLEncoder.encode(token, "UTF-8");
        }
        this.byteSent += (long)data.getBytes().length;
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/getHash");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        wr.close();
        DataInputStream in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        int fileSize = in.readInt();
        this.byteReceived += 4L;
        this.byteSyncDownload = fileSize;
        float a = (float)fileSize / 1024.0f;
        int nb = (int)Math.ceil(a);
        HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>(nb * 2 + 1);
        HashMap<Integer, Integer> mapBlock = new HashMap<Integer, Integer>(nb * 2 + 1);
        int i = 0;
        while (i < nb) {
            byte[] b = new byte[16];
            int r32 = in.readInt();
            in.read(b);
            this.byteReceived += 20L;
            map.put(r32, b);
            mapBlock.put(r32, i);
            ++i;
        }
        byte[] fileHash = new byte[32];
        in.read(fileHash);
        this.byteReceived += 32L;
        in.close();
        File newFile = this.createEmptyFile(localFile.getParentFile(), fileSize);
        RandomAccessFile rNewFile = new RandomAccessFile(newFile, "rw");
        RollingChecksum32 checksum = new RollingChecksum32();
        byte[] buffer = new byte[1024];
        BufferedInputStream fb = new BufferedInputStream(new FileInputStream(localFile));
        int read = fb.read(buffer);
        checksum.check(buffer, 0, read);
        int v = 0;
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        RangeList rangesOk = new RangeList(fileSize);
        do {
            int r32;
            byte[] md5;
            if ((md5 = (byte[])map.get(r32 = checksum.getValue())) != null) {
                md5Digest.reset();
                md5Digest.update(buffer);
                byte[] localMd5 = md5Digest.digest();
                if (HashWriter.compareHash(md5, localMd5)) {
                    int offset = (Integer)mapBlock.get(r32) * 1024;
                    rNewFile.seek(offset);
                    rNewFile.write(buffer);
                    rangesOk.add(new Range(offset, offset + 1024));
                }
            }
            v = fb.read();
            System.arraycopy(buffer, 1, buffer, 0, buffer.length - 1);
            buffer[buffer.length - 1] = (byte)v;
            checksum.roll((byte)v);
        } while (v >= 0);
        fb.close();
        rangesOk.dump();
        List<Range> unusedRanges = rangesOk.getUnusedRanges();
        DataInputStream zIn = this.getContent(remotePath, remoteName, unusedRanges, token);
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(localFile));
        int size = unusedRanges.size();
        int i2 = 0;
        while (i2 < size) {
            Range range = unusedRanges.get(i2);
            rNewFile.seek(range.getStart());
            byte[] b = new byte[range.size()];
            zIn.readFully(b);
            rNewFile.write(b);
            ++i2;
        }
        fOut.close();
        zIn.close();
        rNewFile.close();
        byte[] fileLocalHash = HashWriter.getHash(newFile);
        if (!HashWriter.compareHash(fileHash, fileLocalHash)) {
            throw new IllegalStateException("Partial download failed. Hash error");
        }
        FileUtils.rm(localFile);
        FileUtils.mv(newFile, localFile);
    }

    private File createEmptyFile(File dir, int fileSize) throws FileNotFoundException, IOException {
        Random r = new Random();
        File newFile = new File(dir, "sync." + r.nextInt());
        BufferedOutputStream bOut = new BufferedOutputStream(new FileOutputStream(newFile));
        int l = fileSize;
        byte[] emptyBuffer = new byte[4096];
        while (l > 0) {
            bOut.write(emptyBuffer, 0, Math.min(4096, l));
            l -= 4096;
        }
        bOut.close();
        return newFile;
    }

    private void downloadFile(File localFile, String remotePath, String remoteName, int fileSize, String token) throws IOException {
        ArrayList<Range> list = new ArrayList<Range>(1);
        list.add(new Range(0, fileSize));
        DataInputStream zIn = this.getContent(remotePath, remoteName, list, token);
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(localFile));
        StreamUtils.copy((InputStream)zIn, fOut);
        fOut.close();
        zIn.close();
    }

    private DataInputStream getContent(String remotePath, String remoteName, List<Range> list, String token) throws MalformedURLException, IOException, UnsupportedEncodingException {
        URLConnection conn = this.getConnection(String.valueOf(this.baseUrl) + "/getFile");
        conn.setDoOutput(true);
        ByteArrayOutputStream bOutputStream = new ByteArrayOutputStream();
        DataOutputStream wr = new DataOutputStream(bOutputStream);
        wr.writeInt(list.size());
        for (Range range : list) {
            wr.writeInt(range.getStart());
            wr.writeInt(range.getStop());
        }
        wr.close();
        String data = "rp=" + URLEncoder.encode(remotePath, "UTF-8");
        data = String.valueOf(data) + "&rn=" + URLEncoder.encode(remoteName, "UTF-8");
        data = String.valueOf(data) + "&ra=" + URLEncoder.encode(Base64.encodeBytes(bOutputStream.toByteArray()), "UTF-8");
        if (token != null) {
            data = String.valueOf(data) + "&tk=" + URLEncoder.encode(token, "UTF-8");
        }
        this.byteSent += (long)data.getBytes().length;
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
        osw.write(data);
        osw.flush();
        osw.close();
        BufferedInputStream inputStream = new BufferedInputStream(conn.getInputStream()){

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                SyncClient syncClient = SyncClient.this;
                syncClient.byteReceived = syncClient.byteReceived + (long)len;
                return super.read(b, off, len);
            }
        };
        GZIPInputStream zIn = new GZIPInputStream(inputStream);
        return new DataInputStream(zIn);
    }

    List<Date> getVersions(String remotePath, String remoteName) {
        ArrayList<Date> l = new ArrayList<Date>();
        return l;
    }

    public File resolveFile(File dir, String remoteName) {
        if (remoteName.contains("..")) {
            return null;
        }
        if (remoteName.contains("/") || remoteName.contains("\\")) {
            return null;
        }
        return new File(dir, remoteName);
    }

    public void clearStat() {
        this.byteSent = 0L;
        this.byteReceived = 0L;
        this.byteSyncDownload = 0L;
        this.byteSyncUpload = 0L;
        this.filesSyncDownload = 0L;
        this.filesSyncUpload = 0L;
    }

    URLConnection getConnection(String strUrl) throws IOException {
        URL url = new URL(strUrl);
        URLConnection conn = url.openConnection();
        if (!this.verifyHost && strUrl.startsWith("https")) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)conn;
            httpsCon.setHostnameVerifier(HostnameNonVerifier);
        }
        return conn;
    }

    public void setVerifyHost(boolean verify) {
        this.verifyHost = verify;
    }
}

