/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.cc.ITransformerExn;

@ThreadSafe
public class Memoizer<A, V, X extends Exception>
implements ITransformerExn<A, V, X> {
    private final ConcurrentMap<A, Future<V>> cache;
    private final ITransformerExn<A, V, X> c;

    public Memoizer(ITransformerExn<A, V, X> c) {
        this(c, new ConcurrentHashMap());
    }

    public Memoizer(ITransformerExn<A, V, X> c, ConcurrentMap<A, Future<V>> cache) {
        this.c = c;
        this.cache = cache;
    }

    public final Set<A> getCachedItems() {
        return this.cache.keySet();
    }

    @Override
    public final V transformChecked(final A arg) throws X {
        while (true) {
            FutureTask ft;
            FutureTask res;
            if ((res = (FutureTask)this.cache.get(arg)) == null && (res = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return Memoizer.this.c.transformChecked(arg);
                }
            }))) == null) {
                res = ft;
                ft.run();
            }
            try {
                return res.get();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (CancellationException e) {
                this.cache.remove(arg, res);
                continue;
            }
            catch (ExecutionException e) {
                Exception cause = (Exception)e.getCause();
                throw cause;
            }
            break;
        }
    }
}

