/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.utils.IScheduledFutureTask;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cache.CacheTimeOut;
import org.openconcerto.utils.cache.CacheWatcher;
import org.openconcerto.utils.cache.CacheWatcherFactory;

public final class ICacheSupport<D> {
    private final String name;
    private final ScheduledThreadPoolExecutor timer;
    @GuardedBy(value="this")
    private CacheWatcherFactory<? super D> watcherFactory;
    @GuardedBy(value="this")
    private final Map<D, CacheWatcher<? super D>> watchers;

    public ICacheSupport(String name) {
        this(name, 2L, TimeUnit.MINUTES);
    }

    public ICacheSupport(String name, long amout, TimeUnit unit) {
        this.name = name;
        this.timer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread res = new Thread(r, "cache timeout thread for " + ICacheSupport.this.getName());
                res.setDaemon(true);
                res.setPriority(1);
                return res;
            }
        }){

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
                return new IScheduledFutureTask<V>(task).setInnerRunnable(runnable);
            }

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
                return new IScheduledFutureTask<V>(task).setInnerCallable(callable);
            }
        };
        this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ICacheSupport.this.purgeWatchers();
            }
        }, amout, amout, unit);
        this.watcherFactory = null;
        this.watchers = new HashMap<D, CacheWatcher<? super D>>();
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean die() {
        List<Runnable> runnables;
        boolean didDie;
        ICacheSupport iCacheSupport = this;
        synchronized (iCacheSupport) {
            didDie = !this.isDying();
            runnables = didDie ? this.getTimer().shutdownNow() : null;
        }
        if (didDie) {
            for (Runnable r : runnables) {
                IScheduledFutureTask sft = (IScheduledFutureTask)r;
                if (!(sft.getInner() instanceof CacheTimeOut)) continue;
                sft.getInnerRunnable().run();
            }
            iCacheSupport = this;
            synchronized (iCacheSupport) {
                this.purgeWatchers();
                assert (this.watchers.isEmpty()) : String.valueOf(this.watchers.size()) + " item(s) were not removed : " + this.watchers.values();
            }
        }
        return didDie;
    }

    public final boolean isDying() {
        return this.getTimer().isShutdown();
    }

    final ScheduledExecutorService getTimer() {
        return this.timer;
    }

    public final void purgeTimer() {
        this.timer.purge();
    }

    public synchronized void setWatcherFactory(CacheWatcherFactory<? super D> watcherFactory) {
        if (watcherFactory == null) {
            throw new NullPointerException("Null factory");
        }
        if (this.watcherFactory != null) {
            throw new IllegalStateException("Already set to " + this.watcherFactory);
        }
        this.watcherFactory = watcherFactory;
    }

    final synchronized CacheWatcher<? super D> watch(D data, CacheItem<?, ?, D> item) {
        if (this.watcherFactory == null) {
            return null;
        }
        if (this.isDying()) {
            throw new RejectedExecutionException("Dead support");
        }
        CacheWatcher<D> watcher = this.watchers.get(data);
        if (watcher == null) {
            try {
                watcher = this.watcherFactory.createWatcher(data);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't create watcher for " + data, e);
            }
            this.watchers.put(data, watcher);
        }
        watcher.add(item);
        return watcher;
    }

    final synchronized Map<D, CacheWatcher<? super D>> watch(Set<? extends D> data, CacheItem<?, ?, D> item) {
        LinkedHashMap<D, CacheWatcher<D>> res = new LinkedHashMap<D, CacheWatcher<D>>(data.size(), 1.0f);
        for (D d : data) {
            CacheWatcher<D> watcher = this.watch(d, item);
            if (watcher == null) continue;
            res.put(d, watcher);
        }
        return Collections.unmodifiableMap(res);
    }

    public final synchronized int getWatchersCount() {
        return this.watchers.size();
    }

    public final synchronized int purgeWatchers() {
        Iterator<Map.Entry<D, CacheWatcher<D>>> iter = this.watchers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<D, CacheWatcher<D>> e = iter.next();
            if (!e.getValue().isEmpty()) continue;
            iter.remove();
        }
        return this.getWatchersCount();
    }

    final synchronized boolean dependsOn(D data) {
        return this.watchers.containsKey(data) && !this.watchers.get(data).isEmpty();
    }
}

