/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import org.openconcerto.utils.CompareUtils;

public abstract class Value<V> {
    private static final Value NONE = new Value(false){

        public Object getValue() {
            throw new IllegalStateException(this.toString());
        }

        public String toString() {
            return "No Value";
        }
    };
    private static final Value NULL_VALUE = new Some<Object>(null);
    private final boolean hasValue;

    public static <V> Value<V> getNone() {
        return NONE;
    }

    public static <V> Value<V> getNullValue() {
        return NULL_VALUE;
    }

    public static <V> Value<V> getSome(V value) {
        return value == null ? Value.getNullValue() : new Some<V>(value);
    }

    public static final boolean hasValue(Value<?> v) {
        return v != null && v.hasValue();
    }

    public static <V> Value<V> fromNonNull(V value) {
        return value == null ? Value.getNone() : Value.getSome(value);
    }

    private Value(boolean hasValue) {
        this.hasValue = hasValue;
    }

    public final boolean hasValue() {
        return this.hasValue;
    }

    public abstract V getValue() throws IllegalStateException;

    public final V getValue(V def) {
        if (this.hasValue()) {
            return this.getValue();
        }
        return def;
    }

    public final V toNonNull() throws IllegalStateException {
        if (!this.hasValue()) {
            return null;
        }
        V res = this.getValue();
        if (res == null) {
            throw new IllegalStateException("Null value");
        }
        return res;
    }

    public final <T> Value<T> cast(Class<T> clazz) {
        if (this.hasValue()) {
            clazz.cast(this.getValue());
        }
        return this;
    }

    public int hashCode() {
        return this.hasValue ? 1231 : 1237;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hasValue == ((Value)obj).hasValue;
    }

    /* synthetic */ Value(boolean bl, Value value) {
        this(bl);
    }

    private static final class Some<V>
    extends Value<V> {
        private final V val;

        public Some(V val) {
            super(true, null);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        public String toString() {
            return "Value <" + this.getValue() + '>';
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.val == null ? 0 : this.val.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Some other = (Some)obj;
            return CompareUtils.equals(this.val, other.val);
        }
    }
}

