/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.openconcerto.utils.StringUtils;

public class StreamUtils {
    public static final OutputStream NULL_OS = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
        }
    };

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtils.copy(in, out, 524288);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        StreamUtils.copy(in, out, bufferSize, -1L);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long length) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long totalCount = 0L;
        boolean copyAll = length < 0L;
        while (copyAll || totalCount < length) {
            long toRead;
            long l = toRead = copyAll ? (long)buffer.length : Math.min(length - totalCount, (long)buffer.length);
            assert (0L <= toRead && toRead <= Integer.MAX_VALUE);
            int count = in.read(buffer, 0, (int)toRead);
            if (count == -1) break;
            totalCount += (long)count;
            out.write(buffer, 0, count);
        }
        assert (copyAll || totalCount <= length);
        return totalCount;
    }

    public static void copy(InputStream ins, File out) throws IOException {
        try (BufferedOutputStream ous = new BufferedOutputStream(new FileOutputStream(out));){
            StreamUtils.copy(ins, ous);
        }
    }

    public static byte[] read(InputStream ins) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        StreamUtils.copy(ins, out);
        return out.toByteArray();
    }

    public static void writeln(String s, OutputStream out) throws IOException {
        StreamUtils.write(String.valueOf(s) + "\n", out);
    }

    public static void write(String s, OutputStream out) throws IOException {
        StreamUtils.write(s, out, StringUtils.UTF8);
    }

    public static void write(String s, OutputStream out, Charset charset) throws IOException {
        out.write(s.getBytes(charset));
    }

    public static BufferedWriter createXMLWriter(OutputStream outs) throws IOException {
        return new BufferedWriter(StreamUtils.createXMLUnbufferedWriter(outs));
    }

    public static Writer createXMLUnbufferedWriter(OutputStream outs) throws IOException {
        OutputStreamWriter res = new OutputStreamWriter(outs, StringUtils.UTF8);
        res.write("<?xml version='1.0' encoding='UTF-8' ?>\n");
        return res;
    }
}

