/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    public static final Properties createFromMap(Map<String, String> map) {
        return PropertiesUtils.loadFromMap(new Properties(), map);
    }

    public static final Properties loadFromMap(Properties res, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            if (key == null) {
                throw new NullPointerException("Null key : " + e);
            }
            String val = e.getValue();
            if (val == null) continue;
            res.setProperty(key, val);
        }
        return res;
    }

    public static final Map<String, String> toMap(Properties props) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            assert (value != null);
            res.put(key, value);
        }
        return res;
    }

    public static final Properties createFromFile(File f) throws IOException {
        return PropertiesUtils.create(new BufferedInputStream(new FileInputStream(f)));
    }

    public static final Properties createFromResource(Class<?> ctxt, String rsrc) throws IOException {
        return PropertiesUtils.create(ctxt.getResourceAsStream(rsrc));
    }

    protected static final Properties create(InputStream stream) throws IOException {
        return PropertiesUtils.create(stream, true);
    }

    public static final Properties create(InputStream stream, boolean close) throws IOException {
        if (stream != null) {
            try {
                Properties res = new Properties();
                res.load(stream);
                Properties properties = res;
                return properties;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        return null;
    }

    public static final void load(Properties props, Properties toLoad) {
        for (String key : toLoad.stringPropertyNames()) {
            String value = toLoad.getProperty(key);
            assert (value != null);
            props.setProperty(key, value);
        }
    }
}

