/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.tree;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openconcerto.ui.list.RJLTransferable;

public class ReorderableJTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private final DragSource dragSource = new DragSource();
    private MutableTreeNode dropTargetNode = null;
    private MutableTreeNode draggedNode = null;

    public ReorderableJTree() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(clickPoint.x, clickPoint.y);
        if (path == null) {
            return;
        }
        this.draggedNode = (MutableTreeNode)path.getLastPathComponent();
        RJLTransferable trans = new RJLTransferable(this.draggedNode);
        this.dragSource.startDrag(dge, new Cursor(12), trans, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.setCursor(Cursor.getDefaultCursor());
        this.dropTargetNode = null;
        this.draggedNode = null;
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point dragPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dragPoint.x, dragPoint.y);
        if (path == null) {
            return;
        }
        this.dropTargetNode = (MutableTreeNode)path.getLastPathComponent();
        if (this.dropTargetNode == null || this.draggedNode.equals(this.dropTargetNode)) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.dropTargetNode.getParent();
        if (parent == null || this.draggedNode.getParent() == null) {
            return;
        }
        if (((DefaultMutableTreeNode)this.dropTargetNode).isNodeAncestor(this.draggedNode)) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(this.draggedNode);
        if (this.dropTargetNode.getAllowsChildren()) {
            defaultTreeModel.insertNodeInto(this.draggedNode, this.dropTargetNode, 0);
        } else {
            int index = parent.getIndex(this.dropTargetNode);
            defaultTreeModel.insertNodeInto(this.draggedNode, parent, index);
        }
        this.setSelectionPath(new TreePath(defaultTreeModel.getPathToRoot(this.draggedNode)));
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TreeDemo");
        frame.setDefaultCloseOperation(3);
        ReorderableJTree tree = new ReorderableJTree();
        frame.add(tree);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("The Java Series");
        int i = 0;
        while (i < 10) {
            DefaultMutableTreeNode r = new DefaultMutableTreeNode("Item" + i);
            root.add(r);
            if (i == 3) {
                int j = 0;
                while (j < 3) {
                    r.add(new DefaultMutableTreeNode("Item" + i + ":" + j));
                    ++j;
                }
            }
            ++i;
        }
        tree.setModel(new DefaultTreeModel(root));
        frame.pack();
        frame.setVisible(true);
    }
}

