/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.touch;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.ui.touch.AnimatorManager;
import org.openconcerto.ui.touch.ScrollAnimator;

public class ScrollableList
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ListDataListener {
    private static final long serialVersionUID = 8176007217030710406L;
    private ListModel model;
    int offsetY = 0;
    private int cellHeight;
    private int mousePressedY;
    private int selectedIndex = -1;
    private ScrollAnimator a;
    private int lastMouseY;
    private boolean hasScrolled;
    private List<ListSelectionListener> selectionListeners = new ArrayList<ListSelectionListener>();

    public ScrollableList(ListModel model) {
        this.a = new ScrollAnimator(this);
        this.model = model;
        this.cellHeight = 60;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        model.addListDataListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int minIndex = this.getMinVisibleIndex();
        int maxIndex = this.getMaxVisibleIndex();
        int drawY = this.getYFromIndex(minIndex);
        int i = minIndex;
        while (i <= maxIndex) {
            this.paintCell(g, this.model.getElementAt(i), i, i == this.selectedIndex, drawY);
            drawY += this.cellHeight;
            ++i;
        }
    }

    public int getMinVisibleIndex() {
        int minIndex = this.getIndexFromY(0);
        if (minIndex < 0) {
            minIndex = 0;
        }
        return minIndex;
    }

    public int getMinFullyVisibleIndex() {
        int minIndex = this.getIndexFromY(0);
        if (minIndex < 0) {
            minIndex = 0;
        }
        if (minIndex * this.cellHeight - this.offsetY < 0) {
            ++minIndex;
        }
        return minIndex;
    }

    public int getMaxVisibleIndex() {
        int maxIndex = this.getIndexFromY(this.getHeight());
        if (maxIndex >= this.model.getSize()) {
            maxIndex = this.model.getSize() - 1;
        }
        return maxIndex;
    }

    public int getMaxFullyVisibleIndex() {
        int maxIndex = this.getIndexFromY(this.getHeight());
        if (maxIndex >= this.model.getSize()) {
            maxIndex = this.model.getSize() - 1;
        }
        if (this.getHeight() % this.cellHeight > 0) {
            --maxIndex;
        }
        return maxIndex;
    }

    public void paintCell(Graphics g, Object object, int index, boolean selected, int posY) {
        g.setColor(Color.WHITE);
        g.fillRect(0, posY, this.getWidth(), this.cellHeight);
        g.setColor(Color.GRAY);
        g.drawLine(0, posY + this.cellHeight - 1, this.getWidth(), posY + this.cellHeight - 1);
        if (selected) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.GRAY);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g.setFont(new Font("Arial", 1, 38));
        g.drawString(object.toString(), 14, posY + 43);
    }

    public int getIndexFromY(int y) {
        return (this.offsetY + y) / this.cellHeight;
    }

    public int getYFromIndex(int index) {
        return index * this.cellHeight - this.offsetY;
    }

    public void setFixedCellHeight(int h) {
        this.cellHeight = h;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setOffsetY(int y) {
        if (this.offsetY != y) {
            this.offsetY = y;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMouseY = this.mousePressedY = e.getY();
        this.hasScrolled = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        long targetOffset = (long)this.cellHeight * Math.round((double)this.offsetY / (double)this.cellHeight);
        if (!this.hasScrolled) {
            this.setSelectedIndex(this.getIndexFromY(e.getY()));
        } else {
            this.scrollToOffset(targetOffset);
        }
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean scroll) {
        if (index != this.selectedIndex) {
            this.selectedIndex = index;
            if (scroll) {
                this.scrollToSelectedIndex();
            }
            this.fireSelectionChanged();
        }
        this.repaint();
    }

    public Object getSelectedValue() {
        if (this.selectedIndex < 0 || this.selectedIndex > this.model.getSize() - 1) {
            return null;
        }
        return this.model.getElementAt(this.selectedIndex);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.model.getSize() <= this.getHeight() / this.cellHeight) {
            return;
        }
        int dy = e.getY() - this.lastMouseY;
        this.setOffsetY(this.offsetY - dy);
        this.lastMouseY = e.getY();
        if (Math.abs(this.lastMouseY - this.mousePressedY) > 10) {
            this.hasScrolled = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        long targetOffset = (long)this.cellHeight * Math.round((double)this.offsetY / (double)this.cellHeight);
        this.scrollToOffset(targetOffset += (long)(e.getWheelRotation() * this.cellHeight * 2));
    }

    public void scrollToOffset(long targetOffset) {
        int max = this.model.getSize() * this.cellHeight - this.getHeight();
        if (targetOffset > (long)max) {
            targetOffset = max;
        }
        if (targetOffset < 0L) {
            targetOffset = 0L;
        }
        this.a.stop();
        this.a.setStart(this.offsetY);
        this.a.setStop(targetOffset);
        AnimatorManager.getInstance().start(this.a);
    }

    public void scrollToSelectedIndex() {
        if (this.selectedIndex < 0 || this.selectedIndex > this.model.getSize() - 1) {
            return;
        }
        if (this.selectedIndex < this.getMinFullyVisibleIndex()) {
            this.scrollToOffset(this.selectedIndex * this.cellHeight);
        } else if (this.selectedIndex > this.getMaxFullyVisibleIndex()) {
            int targetOffset = (this.selectedIndex + 1) * this.cellHeight - this.getHeight();
            this.scrollToOffset(targetOffset);
        } else if (this.offsetY < 0) {
            this.scrollToOffset(0L);
        }
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        this.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel<String> model1 = new DefaultListModel<String>();
                int i = 0;
                while (i < 20) {
                    model1.addElement("Item" + i);
                    ++i;
                }
                DefaultListModel<String> model2 = new DefaultListModel<String>();
                int i2 = 0;
                while (i2 < 3) {
                    model2.addElement("Item" + i2);
                    ++i2;
                }
                final ScrollableList l1 = new ScrollableList(model1);
                final ScrollableList l2 = new ScrollableList(model2);
                JFrame f = new JFrame();
                JPanel p = new JPanel();
                p.setLayout(new GridLayout(1, 3));
                p.add(l1);
                JButton comp = new JButton("ScrollToSelected");
                p.add(comp);
                p.add(l2);
                f.setContentPane(p);
                f.setSize(600, 400);
                f.setLocation(10, 80);
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
                comp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        l1.scrollToSelectedIndex();
                        l2.scrollToSelectedIndex();
                    }
                });
            }
        });
    }

    public void clearSelection() {
        if (this.selectedIndex != -1) {
            this.selectedIndex = -1;
            this.fireSelectionChanged();
            this.repaint();
        }
    }

    public boolean setSelectedValue(Object obj, boolean scroll) {
        if (obj == null) {
            this.clearSelection();
            return true;
        }
        int size = this.model.getSize();
        int i = 0;
        while (i < size) {
            Object o = this.model.getElementAt(i);
            if (o.equals(obj)) {
                this.setSelectedIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addListSelectionListener(ListSelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    void fireSelectionChanged() {
        int size = this.selectionListeners.size();
        int i = 0;
        while (i < size) {
            this.selectionListeners.get(i).valueChanged(new ListSelectionEvent(this, this.selectedIndex, this.selectedIndex, false));
            ++i;
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.offsetY = 0;
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }
}

