/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.ui.PopupMouseListener;
import org.openconcerto.utils.cc.ITransformer;

public final class TablePopupMouseListener
extends PopupMouseListener {
    public static void add(JTable t, ITransformer<MouseEvent, JPopupMenu> popup) {
        t.addMouseListener(new TablePopupMouseListener(popup));
    }

    private TablePopupMouseListener(ITransformer<MouseEvent, JPopupMenu> popup) {
        super(popup);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            this.adjustSelection(e);
        }
        super.mousePressed(e);
    }

    @Override
    protected JPopupMenu createPopup(MouseEvent e) {
        this.adjustSelection(e);
        return super.createPopup(e);
    }

    private void adjustSelection(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        int row = table.rowAtPoint(e.getPoint());
        if (!table.getSelectionModel().isSelectedIndex(row)) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
    }
}

