/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIButton;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIButtonWithSelectionContext
extends LightUIButton {
    RowSelectionSpec tableSelection;

    public LightUIButtonWithSelectionContext(JSONObject json) {
        super(json);
    }

    public LightUIButtonWithSelectionContext(String id, RowSelectionSpec tableSelection) {
        super(id, 24);
        this.tableSelection = tableSelection;
    }

    public LightUIButtonWithSelectionContext(LightUIButtonWithSelectionContext button) {
        super(button);
    }

    public RowSelectionSpec getTableSelection() {
        return this.tableSelection;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIButtonWithSelectionContext)) {
            throw new InvalidClassException(LightUIButtonWithSelectionContext.class.getName(), element.getClassName(), element.getId());
        }
        LightUIButtonWithSelectionContext button = (LightUIButtonWithSelectionContext)element;
        this.tableSelection = button.tableSelection;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.tableSelection = JSONConverter.getParameterFromJSON(json, "table-selection", RowSelectionSpec.class);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("table-selection", this.tableSelection.toJSON());
        return json;
    }
}

