/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.text;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class TextBehaviour {
    public static final String REVERT_ACTION_KEY = "action map key to revert value";
    private final JTextComponent comp;
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;

    public static final TextBehaviour manage(JTextComponent comp) {
        return new TextBehaviour(comp);
    }

    private TextBehaviour(JTextComponent comp) {
        this.comp = comp;
        this.comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextBehaviour.this.gained = true;
                TextBehaviour.this.initialText = TextBehaviour.this.comp.getText();
                if (!TextBehaviour.this.mousePressed) {
                    TextBehaviour.this.comp.selectAll();
                }
            }
        });
        this.comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TextBehaviour.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TextBehaviour.this.gained && TextBehaviour.this.comp.getSelectedText() == null) {
                    TextBehaviour.this.comp.selectAll();
                }
                TextBehaviour.this.gained = false;
                TextBehaviour.this.mousePressed = false;
            }
        });
        this.comp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), REVERT_ACTION_KEY);
        if (this.comp.getActionMap().get(REVERT_ACTION_KEY) == null) {
            this.comp.getActionMap().put(REVERT_ACTION_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextBehaviour.this.comp.setText(TextBehaviour.this.initialText);
                    TextBehaviour.this.comp.selectAll();
                }
            });
        }
    }
}

