/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceState;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.IPredicate;

public abstract class SQLTableModelLinesSource {
    private final ITableModel model;
    private final PropertyChangeListener reqListener;
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private IPredicate<SQLRowValues> filter = null;

    protected SQLTableModelLinesSource(ITableModel model) {
        this.model = model;
        this.reqListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLTableModelLinesSource.this.fireChanged(evt);
            }
        };
    }

    void live() {
        this.getParent().getReq().addWhereListener(this.reqListener);
    }

    void die() {
        this.getParent().getReq().rmWhereListener(this.reqListener);
    }

    public final ITableModel getModel() {
        return this.model;
    }

    public abstract SQLTableModelSource getParent();

    public final ListSQLRequest getUpdateQueueReq() {
        return this.getModel().getUpdateQ().getState().getReq();
    }

    public abstract List<ListSQLLine> getAll();

    public abstract Value<ListSQLLine> get(int var1);

    public int compare(ListSQLLine l1, ListSQLLine l2) {
        return ListSQLLine.compareLikeRequest(l1, l2);
    }

    public boolean isCellEditable(ListSQLLine line, int colIndex, SQLTableModelColumn col) {
        return true;
    }

    public abstract Future<?> moveBy(List<? extends SQLRowAccessor> var1, int var2);

    public abstract Future<?> moveTo(List<? extends Number> var1, int var2);

    public final void setFilter(IPredicate<SQLRowValues> filter) {
        this.filter = filter;
        this.fireChanged(new PropertyChangeEvent(this, "filter", null, this.filter));
    }

    public final IPredicate<SQLRowValues> getFilter() {
        return this.filter;
    }

    public final void addListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public final void rmListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    protected final void fireChanged(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    protected final ListSQLLine createLine(SQLRowValues v) {
        return this.createLine(v, null);
    }

    protected final ListSQLLine createLine(SQLRowValues v, Number passedID) {
        int id;
        if (v == null || this.filter != null && !this.filter.evaluateChecked(v)) {
            return null;
        }
        if (passedID != null) {
            id = passedID.intValue();
        } else if (v.hasID()) {
            id = v.getID();
        } else {
            throw new IllegalArgumentException("No ID for " + v);
        }
        ListSQLLine res = new ListSQLLine(this, v, id, this.getModel().getUpdateQ().getState());
        this.lineCreated(res);
        return res;
    }

    protected void lineCreated(ListSQLLine res) {
    }

    final void colsChanged(SQLTableModelSourceState beforeState, SQLTableModelSourceState afterState) {
        this.model.getUpdateQ().stateChanged(beforeState, afterState);
    }

    public abstract void commit(ListSQLLine var1, Path var2, SQLRowValues var3) throws SQLException;
}

