/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.column;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.view.column.Column;
import org.openconcerto.sql.view.column.ColumnFooterRenderer;
import org.openconcerto.sql.view.column.ColumnHeaderRenderer;
import org.openconcerto.sql.view.column.ColumnPanelFetcher;
import org.openconcerto.sql.view.column.ColumnRowRenderer;
import org.openconcerto.sql.view.column.ColumnView;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PopupMouseListener;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ColumnPanel
extends JPanel {
    private ColumnPanelFetcher fetcher;
    private List<Column> columns;
    private int colunmWidth;
    private List<ColumnView> columnViews;
    private final ColumnRowRenderer cRenderer;
    private final ColumnFooterRenderer fRenderer;
    private boolean loading;
    private ColumnHeaderRenderer headerRenderer;

    public ColumnPanel(int colunmWidth, ColumnRowRenderer cRenderer, ColumnFooterRenderer fRenderer) {
        this.colunmWidth = colunmWidth;
        this.cRenderer = cRenderer;
        this.fRenderer = fRenderer;
        JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction("Mettre \u00e0 jour"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnPanel.this.reload();
            }
        });
        this.addMouseListener(new PopupMouseListener(menu));
    }

    public void setHeaderRenderer(ColumnHeaderRenderer r) {
        this.headerRenderer = r;
    }

    public synchronized void setFetch(ColumnPanelFetcher fetcher) {
        this.fetcher = fetcher;
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                ColumnPanel.this.loadColumnHeader();
            }
        });
        Set<SQLTable> tables = this.fetcher.getFecthTables();
        for (SQLTable sqlTable : tables) {
            sqlTable.addTableModifiedListener(new SQLTableModifiedListener(){

                @Override
                public void tableModified(SQLTableEvent evt) {
                    SwingThreadUtils.invoke(new Runnable(){

                        @Override
                        public void run() {
                            ColumnPanel.this.reload();
                        }
                    });
                }
            });
        }
    }

    public void reload() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalAccessError("not in EventDispatchThread");
        }
        if (!this.loading) {
            this.removeAll();
            this.loadColumnHeader();
            this.revalidate();
        }
    }

    private synchronized void loadColumnHeader() {
        this.loading = true;
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                ColumnPanel.this.fetcher.clear();
                int cCount = ColumnPanel.this.fetcher.getColumnCount();
                List<String> names = ColumnPanel.this.fetcher.getColumnName();
                ColumnPanel.this.columns = new ArrayList(cCount);
                int i = 0;
                while (i < cCount) {
                    ColumnPanel.this.columns.add(new Column(names.get(i)));
                    ++i;
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur de chargement des colonnes", e);
                }
                ColumnPanel.this.layoutColumns();
                ColumnPanel.this.loadColumnsContent();
            }
        };
        worker.execute();
    }

    protected void layoutColumns() {
        int size = this.columns.size();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        if (this.headerRenderer != null) {
            c.gridwidth = size * 2 - 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 0;
            this.add((Component)this.headerRenderer, c);
            ++c.gridy;
            c.gridwidth = 1;
        }
        c.insets = new Insets(0, 3, 0, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.anchor = 18;
        this.columnViews = new ArrayList<ColumnView>(size);
        int i = 0;
        while (i < size) {
            c.weightx = 1.0;
            Column column = this.columns.get(i);
            ColumnView cView = new ColumnView(column, this.colunmWidth, this.cRenderer, this.fRenderer);
            cView.setOpaque(false);
            this.columnViews.add(cView);
            this.add((Component)cView, c);
            ++c.gridx;
            c.weightx = 0.0;
            if (i < size - 1) {
                this.add((Component)new JSeparator(1), c);
            }
            ++i;
        }
        this.revalidate();
    }

    private void loadColumnsContent() {
        SwingWorker<Object, Integer> worker = new SwingWorker<Object, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                int cCount = ColumnPanel.this.columns.size();
                ArrayList<? extends SQLRowAccessor> allRows = new ArrayList<SQLRowAccessor>();
                int i = 0;
                while (i < cCount) {
                    List<? extends SQLRowAccessor> rows = ColumnPanel.this.fetcher.getRowsForColumn(i);
                    ((Column)ColumnPanel.this.columns.get(i)).setRows(rows);
                    allRows.addAll(rows);
                    ++i;
                }
                if (ColumnPanel.this.headerRenderer != null) {
                    ColumnPanel.this.headerRenderer.setContent(allRows);
                }
                return cCount;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    for (ColumnView col : ColumnPanel.this.columnViews) {
                        col.updateContent();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur de mise \u00e0 jour des colonnes", e);
                }
                ColumnPanel.this.revalidate();
                ColumnPanel.this.loading = false;
            }
        };
        worker.execute();
    }
}

