/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.RightSQLElement;
import org.openconcerto.sql.users.rights.UserRightGroup;
import org.openconcerto.sql.users.rights.UserRightSQLComponent;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.i18n.I18nUtils;

public class UserRightSQLElement
extends ConfSQLElement {
    public static final String TABLE_NAME = "USER_RIGHT";

    public static List<SQLCreateTable> getCreateTables(SQLTable userT) {
        DBRoot root = userT.getDBRoot();
        SQLTable t = root.findTable(TABLE_NAME, false);
        if (t != null) {
            return Collections.emptyList();
        }
        ArrayList<SQLCreateTable> res = new ArrayList<SQLCreateTable>();
        SQLCreateTable create = new SQLCreateTable(root, TABLE_NAME);
        create.addForeignColumn(userT.getName());
        if (root.contains("RIGHT")) {
            create.addForeignColumn("RIGHT");
        } else {
            SQLCreateTable createRight = RightSQLElement.getCreateTable(root);
            res.add(createRight);
            create.addForeignColumn(createRight);
        }
        create.addColumn("OBJECT", "varchar(150) NULL DEFAULT NULL");
        create.addColumn("HAVE_RIGHT", "boolean NOT NULL");
        res.add(create);
        return res;
    }

    public UserRightSQLElement() {
        super(TABLE_NAME);
        this.setL18nPackageName(I18nUtils.getPackageName(TM.class));
        UserRightGroup group = new UserRightGroup();
        GlobalMapper.getInstance().map(UserRightSQLComponent.ID, group);
        this.setDefaultGroup(group);
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("ID_RIGHT", "OBJECT", "HAVE_RIGHT");
    }

    @Override
    protected List<String> getComboFields() {
        return this.getListFields();
    }

    @Override
    protected String getParentFFName() {
        return "ID_USER_COMMON";
    }

    @Override
    public Set<String> getReadOnlyFields() {
        return Collections.singleton("ID_USER_COMMON");
    }

    @Override
    public SQLComponent createComponent() {
        return new UserRightSQLComponent(this);
    }
}

