/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLSyntax;

public abstract class SQLSearchMode {
    public static final SQLSearchMode EQUALS = new SQLSearchMode(){

        @Override
        public String generateSQL(SQLSyntax s, String term) {
            return " = " + s.quoteString(term);
        }

        @Override
        public List<SQLSearchMode> getHigherModes() {
            return Collections.emptyList();
        }
    };
    public static final SQLSearchMode STARTS_WITH = new SQLSearchMode(){

        @Override
        public String generateSQL(SQLSyntax s, String term) {
            return " like " + s.quoteString(String.valueOf(s.getLitteralLikePattern(term)) + "%");
        }

        @Override
        public List<SQLSearchMode> getHigherModes() {
            return Collections.singletonList(EQUALS);
        }
    };
    public static final SQLSearchMode ENDS_WITH = new SQLSearchMode(){

        @Override
        public String generateSQL(SQLSyntax s, String term) {
            return " like " + s.quoteString("%" + s.getLitteralLikePattern(term));
        }

        @Override
        public List<SQLSearchMode> getHigherModes() {
            return Collections.singletonList(EQUALS);
        }
    };
    private static final List<SQLSearchMode> CONTAINS_HIGHER_MODES = Arrays.asList(EQUALS, STARTS_WITH);
    public static final SQLSearchMode CONTAINS = new SQLSearchMode(){

        @Override
        public String generateSQL(SQLSyntax s, String term) {
            return " like " + s.quoteString("%" + s.getLitteralLikePattern(term) + "%");
        }

        @Override
        public List<SQLSearchMode> getHigherModes() {
            return CONTAINS_HIGHER_MODES;
        }
    };

    public final String generateSQL(DBRoot r, String term) {
        return this.generateSQL(SQLSyntax.get(r), term);
    }

    public abstract String generateSQL(SQLSyntax var1, String var2);

    public abstract List<SQLSearchMode> getHigherModes();
}

