/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.TableRef;

public class SQLFunctionField
implements FieldRef {
    private final SQLFunction function;
    private final FieldRef field;

    public SQLFunctionField(SQLFunction function, FieldRef field) {
        this.function = function;
        this.field = field;
    }

    public SQLFunction getFunction() {
        return this.function;
    }

    @Override
    public SQLField getField() {
        return this.field.getField();
    }

    @Override
    public String getAlias() {
        return this.field.getAlias();
    }

    @Override
    public String getFieldRef() {
        return String.valueOf(this.getFunction().getSQL()) + "(" + this.field.getFieldRef() + ")";
    }

    @Override
    public TableRef getTableRef() {
        return this.field.getTableRef();
    }

    public static class SQLFunction {
        public static final SQLFunction LOWER = new SQLFunction("LOWER");
        public static final SQLFunction UPPER = new SQLFunction("UPPER");
        public static final SQLFunction COUNT = new SQLFunction("COUNT");
        public static final SQLFunction SUM = new SQLFunction("SUM");
        private final String sqlString;

        public SQLFunction(String sqlString) {
            this.sqlString = sqlString;
        }

        public String getSQL() {
            return this.sqlString;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getSQL();
        }
    }
}

