/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.util.List;
import org.openconcerto.map.model.MapPoint;
import org.openconcerto.map.model.Region;
import org.openconcerto.utils.ArrayListOfInt;

public class RegionPointsCache {
    private Region region;
    public int[] absX;
    public int[] absY;
    final ArrayListOfInt pointsX;
    final ArrayListOfInt pointsY;

    RegionPointsCache(Region r, double zoom) {
        this.region = r;
        int size = r.getPoints().size();
        this.pointsX = new ArrayListOfInt(size);
        this.pointsY = new ArrayListOfInt(size);
        List<MapPoint> points2 = r.getPoints();
        int regionPoints = points2.size();
        int lastX = -1;
        int lastY = -1;
        int lastlastX = -1;
        int lastlastY = -1;
        int j = 0;
        while (j < regionPoints) {
            MapPoint p = points2.get(j);
            int currentX = (int)((double)p.getX() / zoom);
            int currentY = (int)((double)p.getY() / zoom);
            if (currentX != lastX || currentY != lastY) {
                if (lastlastX == currentX && lastlastY == currentY) {
                    this.removeLast();
                    lastX = currentX;
                    lastY = currentY;
                } else {
                    lastlastX = lastX;
                    lastlastY = lastY;
                    lastX = currentX;
                    lastY = currentY;
                    this.add(currentX, currentY);
                }
            }
            ++j;
        }
        this.absX = this.pointsX.toArray();
        this.absY = this.pointsY.toArray();
    }

    private final void add(int currentX, int currentY) {
        this.pointsX.add(currentX);
        this.pointsY.add(currentY);
    }

    private void removeLast() {
        int size = this.pointsX.size();
        if (size > 0) {
            this.pointsX.remove(size - 1);
            this.pointsY.remove(size - 1);
        }
    }

    public long getMaxX() {
        return this.region.getMaxX();
    }

    public long getMaxY() {
        return this.region.getMaxY();
    }

    public long getMinX() {
        return this.region.getMinX();
    }

    public long getMinY() {
        return this.region.getMinY();
    }

    public int size() {
        return this.pointsX.size();
    }

    public Region getRegion() {
        return this.region;
    }
}

