/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils.correct;

import java.sql.SQLException;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class FindEmptyMouvement
extends Changer<DBRoot> {
    private boolean completelyEmpty;

    public FindEmptyMouvement(DBSystemRoot b) {
        super(b);
        this.setCompletelyEmpty(false);
    }

    public void setCompletelyEmpty(boolean completelyEmpty) {
        this.completelyEmpty = completelyEmpty;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.setCompletelyEmpty(Boolean.getBoolean("findMvt.completelyEmpty"));
    }

    @Override
    protected void changeImpl(DBRoot societeRoot) throws SQLException {
        SQLTable ecritureT = societeRoot.getTable("ECRITURE");
        SQLField ecritureMvtFF = ecritureT.getField("ID_MOUVEMENT");
        SQLTable mvtT = ecritureT.getForeignTable(ecritureMvtFF.getName());
        SQLSelect sel = new SQLSelect();
        sel.addSelect(mvtT.getKey(), "count");
        sel.addBackwardJoin("LEFT", null, ecritureMvtFF, null);
        sel.setArchivedPolicy(ecritureT, this.completelyEmpty ? SQLSelect.ArchiveMode.BOTH : SQLSelect.ArchiveMode.UNARCHIVED);
        sel.setWhere(Where.isNull(ecritureT.getKey()));
        Number count = (Number)this.getDS().executeScalar(sel.asString());
        this.getStream().println("Found " + count + (this.completelyEmpty ? " completely " : "") + " empty " + mvtT.getName());
    }
}

