/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.plaf.FontUIResource;
import org.openconcerto.erp.preferences.DefaultLocalPreferencePanel;
import org.openconcerto.laf.LAFUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;

public class UIPreferencePanel
extends DefaultLocalPreferencePanel {
    private static final String UI_PROPERTIES = "ui.properties";
    private static final String ALTERNATE_COLOR_BLUE = "ui.list.alternate.color.blue";
    private static final String ALTERNATE_COLOR_GREEN = "ui.list.alternate.color.green";
    private static final String ALTERNATE_COLOR_RED = "ui.list.alternate.color.red";
    private static final String UI_DPI = "ui.default.dpi";
    private static final String UI_LOOK = "ui.look";
    private JLabel selectedButton;
    private JComboBox comboLook;
    private JComboBox comboDPI;

    public UIPreferencePanel() {
        super("Interface graphique", UI_PROPERTIES);
    }

    @Override
    public void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.add((Component)new JLabel("Look"), c);
        this.comboLook = new JComboBox<String>(new String[]{"natif du syst\u00e8me", "Nimbus"});
        String look = this.properties.getProperty(UI_LOOK);
        if (look != null && !look.equals("system")) {
            this.comboLook.setSelectedIndex(1);
        } else {
            this.comboLook.setSelectedIndex(0);
        }
        ++c.gridx;
        this.add((Component)this.comboLook, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("High DPI"), c);
        this.comboDPI = new JComboBox<String>(new String[]{"D\u00e9sactiv\u00e9", "x1.3", "x2", "x3", "x4"});
        String dpi = this.properties.getProperty(UI_DPI);
        if (dpi != null && !dpi.equals("1")) {
            this.comboDPI.setSelectedIndex(Float.valueOf(dpi).intValue());
        }
        ++c.gridx;
        this.add((Component)this.comboDPI, c);
        JLabel labelAlternate = new JLabel("Couleur de fond dans les liste pour l'alternance");
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        this.add((Component)labelAlternate, c);
        ArrayList<Color> colors = new ArrayList<Color>();
        int col = 245;
        colors.add(new Color(col, col, col));
        colors.add(new Color(col -= 10, col, col));
        colors.add(new Color(col -= 10, col, col));
        colors.add(new Color(col -= 10, col, col));
        colors.add(new Color(232, 232, 240));
        colors.add(new Color(206, 206, 222));
        colors.add(new Color(180, 180, 205));
        colors.add(new Color(154, 154, 188));
        colors.add(new Color(224, 240, 247));
        colors.add(new Color(190, 222, 239));
        colors.add(new Color(155, 205, 230));
        colors.add(new Color(120, 188, 221));
        colors.add(new Color(217, 240, 247));
        colors.add(new Color(173, 222, 239));
        colors.add(new Color(130, 205, 230));
        colors.add(new Color(87, 188, 221));
        colors.add(new Color(224, 247, 240));
        colors.add(new Color(190, 239, 222));
        colors.add(new Color(155, 230, 205));
        colors.add(new Color(120, 221, 188));
        colors.add(new Color(240, 217, 232));
        colors.add(new Color(222, 173, 206));
        colors.add(new Color(205, 130, 180));
        colors.add(new Color(188, 87, 154));
        colors.add(new Color(240, 224, 217));
        colors.add(new Color(222, 190, 173));
        colors.add(new Color(205, 155, 130));
        colors.add(new Color(188, 120, 87));
        JPanel colorPanel = new JPanel();
        colorPanel.setBorder(new LineBorder(Color.white, 2));
        colorPanel.setOpaque(true);
        colorPanel.setBackground(Color.WHITE);
        colorPanel.setLayout(new GridLayout(colors.size() / 4, 4, 2, 2));
        JLabel[] buttonsAlternate = new JLabel[colors.size()];
        int i = 0;
        while (i < colors.size()) {
            Color color = (Color)colors.get(i);
            final JLabel button = new JLabel("    label test   ");
            button.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
            buttonsAlternate[i] = button;
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    UIPreferencePanel.this.selectButton(button);
                }
            });
            button.setOpaque(true);
            button.setBackground(color);
            colorPanel.add(button);
            ++i;
        }
        ++c.gridy;
        String cRed = this.properties.getProperty(ALTERNATE_COLOR_RED);
        String cGreen = this.properties.getProperty(ALTERNATE_COLOR_GREEN);
        String cBlue = this.properties.getProperty(ALTERNATE_COLOR_BLUE);
        int r = -1;
        int g = -1;
        int b = -1;
        if (cRed != null) {
            r = Integer.parseInt(cRed);
        }
        if (cGreen != null) {
            g = Integer.parseInt(cGreen);
        }
        if (cBlue != null) {
            b = Integer.parseInt(cBlue);
        }
        this.selectButton(buttonsAlternate[1]);
        if (r >= 0 && g >= 0 && b >= 0) {
            Color expectedColor = new Color(r, g, b);
            int i2 = 0;
            while (i2 < buttonsAlternate.length) {
                JLabel jLabel = buttonsAlternate[i2];
                if (jLabel.getBackground().equals(expectedColor)) {
                    this.selectButton(jLabel);
                    break;
                }
                ++i2;
            }
        }
        this.add((Component)colorPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        this.add((Component)new JLabelWarning("Les modifications d'interface n\u00e9cessitent un red\u00e9marrage du logiciel."), c);
    }

    private void selectButton(JLabel button) {
        if (button != this.selectedButton) {
            if (this.selectedButton != null) {
                this.selectedButton.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
            }
            button.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
            this.selectedButton = button;
        }
    }

    @Override
    public void storeValues() {
        Color background = this.selectedButton.getBackground();
        this.properties.setProperty(ALTERNATE_COLOR_RED, String.valueOf(background.getRed()));
        this.properties.setProperty(ALTERNATE_COLOR_GREEN, String.valueOf(background.getGreen()));
        this.properties.setProperty(ALTERNATE_COLOR_BLUE, String.valueOf(background.getBlue()));
        AlternateTableCellRenderer.setDefaultMap(Collections.singletonMap(Color.WHITE, background));
        if (this.comboLook.getSelectedIndex() == 0) {
            this.properties.setProperty(UI_LOOK, "system");
        } else {
            this.properties.setProperty(UI_LOOK, "nimbus");
        }
        if (this.comboDPI.getSelectedIndex() == 1) {
            this.properties.setProperty(UI_DPI, "1.3");
        } else if (this.comboDPI.getSelectedIndex() == 2) {
            this.properties.setProperty(UI_DPI, "2");
        } else if (this.comboDPI.getSelectedIndex() == 3) {
            this.properties.setProperty(UI_DPI, "3");
        } else if (this.comboDPI.getSelectedIndex() == 4) {
            this.properties.setProperty(UI_DPI, "4");
        } else {
            this.properties.setProperty(UI_DPI, "1");
        }
        super.storeValues();
    }

    private static void useNimbusLF() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIPreferencePanel.getNimbusClassName());
        UIManager.put("control", new Color(240, 240, 240));
        UIManager.put("Table.showGrid", Boolean.TRUE);
        UIManager.put("FormattedTextField.background", new Color(240, 240, 240));
        UIManager.put("Table.alternateRowColor", Color.WHITE);
    }

    public static String getNimbusClassName() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(info.getName())) {
                return info.getClassName();
            }
            ++n2;
        }
        return null;
    }

    public static void initUIFromPreferences() {
        try {
            Properties properties = UIPreferencePanel.getPropertiesFromFile(UI_PROPERTIES);
            String cRed = properties.getProperty(ALTERNATE_COLOR_RED);
            String cGreen = properties.getProperty(ALTERNATE_COLOR_GREEN);
            String cBlue = properties.getProperty(ALTERNATE_COLOR_BLUE);
            int r = -1;
            int g = -1;
            int b = -1;
            if (cRed != null) {
                r = Integer.parseInt(cRed);
            }
            if (cGreen != null) {
                g = Integer.parseInt(cGreen);
            }
            if (cBlue != null) {
                b = Integer.parseInt(cBlue);
            }
            if (r >= 0 && g >= 0 && b >= 0) {
                AlternateTableCellRenderer.setDefaultMap(Collections.singletonMap(Color.WHITE, new Color(r, g, b)));
            }
            String look = properties.getProperty(UI_LOOK);
            String nimbusClassName = UIPreferencePanel.getNimbusClassName();
            if (look != null && look.equals("system")) {
                UIPreferencePanel.useSystemLF();
            } else if (look != null && look.equals("nimbus")) {
                UIPreferencePanel.useNimbusLF();
            } else if (nimbusClassName == null || !System.getProperty("os.name", "??").toLowerCase().contains("linux")) {
                UIPreferencePanel.useSystemLF();
            } else {
                UIPreferencePanel.useNimbusLF();
            }
            String dpi = properties.getProperty(UI_DPI);
            if (dpi != null && dpi.length() > 0 && !dpi.equalsIgnoreCase("1")) {
                UIPreferencePanel.setUIFont(Float.valueOf(dpi).floatValue());
                UIManager.put("dpi.scale", Float.valueOf(dpi));
            } else {
                UIManager.put("dpi.scale", Float.valueOf(1.0f));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Unable to restore UI preferences", e);
        }
    }

    public static void setUIFont(float factor) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource r = (FontUIResource)value;
            UIManager.put(key, r.deriveFont((float)r.getSize() * factor));
        }
    }

    private static void useSystemLF() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        LAFUtils.setLookAndFeel();
    }
}

