/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.BalanceSheet;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivreSheetXML;
import org.openconcerto.erp.core.finance.accounting.report.JournauxSheetXML;
import org.openconcerto.erp.core.humanresources.payroll.report.EtatChargesPayeSheet;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSheetXML;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;
import org.openconcerto.erp.generationDoc.DefaultCloudTemplateProvider;
import org.openconcerto.erp.generationDoc.DefaultLocalTemplateProvider;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.AbstractGenerationDocumentPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.preferences.TemplateProps;
import org.openconcerto.utils.StreamUtils;

public class TemplateNXProps
extends TemplateProps {
    private static final String societeBaseName = ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName();

    @Override
    protected String getPropsFileName() {
        InputStream fConf;
        File f = Configuration.getInstance().getConfDir();
        File f2 = new File(f, "Configuration" + File.separator + "Template.properties");
        if (!f2.exists() && (fConf = ComptaBasePropsConfiguration.getStreamStatic("/Configuration/Template.properties")) != null) {
            try {
                StreamUtils.copy(fConf, f2);
                fConf.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Impossible de copier le fichier de configuration de l'emplacement des mod\u00e9les\ndepuis le serveur, veuillez d\u00e9finir l'emplacement des mod\u00e9les manuellement.");
                e.printStackTrace();
            }
        }
        if (f2.exists()) {
            return f2.getAbsolutePath();
        }
        try {
            f2.getParentFile().mkdirs();
            f2.createNewFile();
        }
        catch (IOException e) {
            System.err.println(f2);
            e.printStackTrace();
        }
        return f2.getAbsolutePath();
    }

    @Override
    public String getPropertySuffix() {
        return societeBaseName;
    }

    @Override
    public String getDefaultStringValue() {
        Configuration conf = ComptaPropsConfiguration.getInstance();
        SQLRow rowSociete = ((ComptaPropsConfiguration)conf).getRowSociete();
        return String.valueOf(conf.getWD().getAbsolutePath()) + File.separator + rowSociete.getString("NOM") + "-" + rowSociete.getID();
    }

    public void initDocumentLocalStorage() {
        String propertyAtt;
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        String propertyDefaultDirectory = this.getProperty("DefaultOO");
        if (propertyDefaultDirectory == null) {
            System.out.println("Warning: no default directory stored for document output");
            propertyDefaultDirectory = this.getDefaultStringValue();
        }
        storage.setDocumentDefaultDirectory(new File(propertyDefaultDirectory));
        String propertyDefaultPDFDirectory = this.getProperty("DefaultPDF");
        if (propertyDefaultPDFDirectory == null) {
            System.out.println("Warning: no default directory stored for PFD output");
            propertyDefaultPDFDirectory = propertyDefaultDirectory;
        }
        if ((propertyAtt = this.getProperty("EDMdirectory")) != null && propertyAtt.trim().length() > 0) {
            storage.addDocumentDirectory("EDMdirectory", new File(propertyAtt));
        }
        storage.setPDFDefaultDirectory(new File(propertyDefaultPDFDirectory));
        this.register(DemandePrixSheetXML.TEMPLATE_ID, DemandePrixSheetXML.TEMPLATE_PROPERTY_NAME, AbstractGenerationDocumentPreferencePanel.getLabelFromTable("DEMANDE_PRIX"));
        this.register("Devis", "LocationDevis", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("DEVIS"));
        this.register("VenteFacture", "LocationFacture", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("SAISIE_VENTE_FACTURE"));
        this.register("CommandeClient", "LocationCmdCli", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE_CLIENT"));
        this.register("BonLivraison", "LocationBon", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("BON_DE_LIVRAISON"));
        this.register("Avoir", "LocationAvoir", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("AVOIR_CLIENT"));
        this.register("AvoirF", "LocationAvoirF", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("AVOIR_FOURNISSEUR"));
        this.register("BonReception", "LocationBonR", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("BON_RECEPTION"));
        this.register("FactureFournisseur", "LocationFactureFournisseur", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("FACTURE_FOURNISSEUR"));
        this.register("Commande", "LocationCmd", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE"));
        this.register("FicheArticle", "LocationFicheArticle", "Fiche article");
        this.register("EtatVentes", "Default", null);
        this.register("FicheClient", "LocationFicheClient", "Fiche client");
        this.register("FicheRelance", "Default", null);
        this.register("ReleveCheque", "LocationReleveChequeCli", null);
        this.register("ListeVentes", "Default", null);
        this.register(BalanceSheet.TEMPLATE_ID, BalanceSheet.TEMPLATE_PROPERTY_NAME, BalanceSheet.TEMPLATE_ID);
        this.register(GrandLivreSheetXML.TEMPLATE_ID, GrandLivreSheetXML.TEMPLATE_PROPERTY_NAME, GrandLivreSheetXML.TEMPLATE_ID);
        this.register(JournauxSheetXML.TEMPLATE_ID, JournauxSheetXML.TEMPLATE_PROPERTY_NAME, JournauxSheetXML.TEMPLATE_ID);
        this.register(EtatChargesPayeSheet.TEMPLATE_ID, EtatChargesPayeSheet.TEMPLATE_PROPERTY_NAME, "Etat des charges");
        this.register("FichePayeSimplifiee", "LocationFichePaye", "Fiche paye");
        this.register("Livre de paye", "LocationLivrePaye", "Livre paye");
        this.register("Courrier", "LocationCourrier", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE"));
        this.register("Pointage", "Default", null);
        this.register("Relance", "LocationRelance", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("RELANCE"));
        this.register("VenteComptoir", "LocationVenteComptoir", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("SAISIE_VENTE_COMPTOIR"));
        this.register("ReleveChequeEmis", "LocationReleveCheque", null);
        storage.dump();
    }

    public void preventecRegister(String path, String templateId, String defaultSubFolder) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        if (TemplateManager.getInstance().isKnwonTemplate(templateId)) {
            System.err.println("Warning: registering known template id : " + templateId);
        }
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        if (defaultSubFolder != null) {
            storage.addDocumentDirectory(templateId, new File(path, defaultSubFolder));
            storage.addPDFDirectory(templateId, new File(path, defaultSubFolder));
        } else {
            storage.addDocumentDirectory(templateId, new File(path));
            storage.addPDFDirectory(templateId, new File(path));
        }
    }

    public void register(String templateId, String propertyBaseName, String defaultSubFolder) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        if (propertyBaseName == null) {
            throw new IllegalArgumentException("null propertyBaseName");
        }
        if (TemplateManager.getInstance().isKnwonTemplate(templateId)) {
            System.err.println("Warning: registering known template id : " + templateId + " with property base name: " + propertyBaseName);
        }
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        String propertyOO = this.getProperty(String.valueOf(propertyBaseName) + "OO");
        if (propertyOO != null) {
            storage.addDocumentDirectory(templateId, new File(propertyOO));
        } else if (defaultSubFolder != null && defaultSubFolder.trim().length() > 0) {
            storage.addDocumentDirectory(templateId, new File(storage.getDocumentOutputDirectory("default"), defaultSubFolder));
        }
        String propertyPDF = this.getProperty(String.valueOf(propertyBaseName) + "PDF");
        if (propertyPDF != null) {
            storage.addPDFDirectory(templateId, new File(propertyPDF));
        } else if (defaultSubFolder != null && defaultSubFolder.trim().length() > 0) {
            storage.addDocumentDirectory(templateId, new File(storage.getPDFOutputDirectory("default"), defaultSubFolder));
        }
    }

    public static synchronized TemplateProps getInstance() {
        if (instance == null) {
            instance = new TemplateNXProps();
            ((TemplateNXProps)instance).initDocumentLocalStorage();
            ((TemplateNXProps)instance).initDefaulTemplateProvider();
        }
        return instance;
    }

    private void initDefaulTemplateProvider() {
        AbstractLocalTemplateProvider provider;
        String property = this.getProperty("LocationTemplate");
        ComptaPropsConfiguration configuration = (ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance();
        if (!configuration.isOnCloud()) {
            provider = new DefaultLocalTemplateProvider();
            if (property != null) {
                File storage = new File(property);
                ((DefaultLocalTemplateProvider)provider).setBaseDirectory(storage);
            }
        } else {
            provider = new DefaultCloudTemplateProvider(configuration.getSocieteID());
        }
        TemplateManager.getInstance().setDefaultProvider(provider);
        TemplateManager.getInstance().dump();
    }
}

