/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportCCMX
extends AbstractExport {
    private final DecimalFormat decimalFormat = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.UK));
    private List<Object[]> data;

    private String formatCents(Number n) {
        return this.decimalFormat.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportCCMX(DBRoot rootSociete) {
        super(rootSociete, "CCMX", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, StringUtils.Cp1252);
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");
        int ligne = 1;
        for (Object[] array : this.data) {
            bufOut.write(String.valueOf(ligne));
            bufOut.write(",");
            bufOut.write(dateFormat.format((Date)array[2]));
            bufOut.write(",");
            bufOut.write(this.removeComma(String.valueOf(array[0])));
            bufOut.write(",");
            String numeroCompte = String.valueOf(array[3]);
            bufOut.write(this.removeComma(numeroCompte));
            bufOut.write(",");
            String libelleCompte = this.removeComma(String.valueOf(array[4]));
            if (libelleCompte.length() > 34) {
                libelleCompte = libelleCompte.substring(0, 34);
            }
            bufOut.write(libelleCompte);
            bufOut.write(",");
            String libelleEcriture = this.removeComma(String.valueOf(array[6]));
            if (libelleEcriture.length() > 39) {
                libelleEcriture = libelleEcriture.substring(0, 34);
            }
            bufOut.write(libelleEcriture);
            bufOut.write(",");
            bufOut.write(",");
            long debit = ((Number)array[7]).longValue();
            bufOut.write(this.formatCents(debit));
            bufOut.write(",");
            long credit = ((Number)array[8]).longValue();
            bufOut.write(this.formatCents(credit));
            bufOut.write(",");
            bufOut.write("\r\n");
            ((Writer)bufOut).flush();
            ++ligne;
        }
    }

    private String removeComma(String str) {
        StringBuilder b = new StringBuilder(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c != ',') {
                b.append(c);
            } else {
                b.append(' ');
            }
            ++i;
        }
        return b.toString();
    }
}

