/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.utils.Tuple2;

public abstract class AbstractExport {
    private final DBRoot rootSociete;
    private final String type;
    private final String extension;
    private boolean used;
    private int nbCharCpt = 0;
    private int nbCharLimitCpt = 0;

    protected AbstractExport(DBRoot rootSociete, String type, String extension) {
        this.rootSociete = rootSociete;
        this.type = type;
        this.extension = extension;
        this.used = false;
    }

    public String getFormattedCompte(String s) {
        String result = s;
        if (s != null) {
            if (this.nbCharCpt > 0 && s.trim().length() > 0) {
                StringBuilder res = new StringBuilder(this.nbCharCpt);
                int i = 0;
                while (i < Math.max(this.nbCharCpt, s.length())) {
                    if (i < s.length()) {
                        res.append(s.charAt(i));
                    } else {
                        res.append("0");
                    }
                    ++i;
                }
                result = res.toString();
            }
            if (this.nbCharLimitCpt > 0 && result.length() > this.nbCharLimitCpt) {
                result = result.substring(0, this.nbCharLimitCpt);
            }
        }
        return result;
    }

    public void setNbCharCpt(int nbCharCpt) {
        this.nbCharCpt = nbCharCpt;
    }

    public void setNbCharLimitCpt(int nbCharLimitCpt) {
        this.nbCharLimitCpt = nbCharLimitCpt;
    }

    public int getNbCharCpt() {
        return this.nbCharCpt;
    }

    public int getNbCharLimitCpt() {
        return this.nbCharLimitCpt;
    }

    protected final DBRoot getRootSociete() {
        return this.rootSociete;
    }

    protected final SQLDataSource getDS() {
        return this.getRootSociete().getDBSystemRoot().getDataSource();
    }

    protected final SQLTable getEcritureT() {
        return this.getRootSociete().getTable("ECRITURE");
    }

    protected final Where getWhere(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        SQLTable tableEcriture = this.getEcritureT();
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), from, (Object)to);
        if (selectedJournal != null && !selectedJournal.isUndefined()) {
            w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "=", selectedJournal.getID()));
        }
        if (onlyNew) {
            w = w.and(Where.isNull(tableEcriture.getField("DATE_EXPORT")));
        }
        return w;
    }

    protected SQLSelect createSelect(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        SQLSelect sel = new SQLSelect();
        SQLTable tableEcriture = this.getRootSociete().getTable("ECRITURE");
        sel.addFrom(tableEcriture);
        sel.addJoin("LEFT", tableEcriture.getField("ID_JOURNAL"));
        sel.addJoin("LEFT", tableEcriture.getField("ID_COMPTE_PCE"));
        SQLSelectJoin mvtJoin = sel.addJoin("LEFT", tableEcriture.getField("ID_MOUVEMENT"));
        sel.addJoin("LEFT", mvtJoin.getJoinedTable().getField("ID_PIECE"));
        sel.setWhere(this.getWhere(from, to, selectedJournal, onlyNew));
        return sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tuple2<File, Number> export(File selectedFile, Date from, Date to, SQLRow selectedJournal, boolean onlyNew) throws Exception {
        AbstractExport abstractExport = this;
        synchronized (abstractExport) {
            if (this.used) {
                throw new IllegalStateException("Already used");
            }
            this.used = true;
        }
        File directory = selectedFile;
        if (directory == null) {
            throw new IllegalArgumentException("Dossier s\u00e9lectionn\u00e9 incorrect");
        }
        if (!directory.isDirectory()) {
            directory = directory.getParentFile();
        }
        if (!directory.canWrite()) {
            throw new IllegalArgumentException("Vous n'avez pas les droits pour \u00e9crire dans le dossier " + directory.getAbsolutePath());
        }
        int count = this.fetchData(from, to, selectedJournal, onlyNew);
        if (count == 0) {
            return Tuple2.create(null, count);
        }
        Date now = new Date();
        SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat uniqueDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        File fOut = new File(directory, "ExportOC_" + fileDateFormat.format(from) + "-" + fileDateFormat.format(to) + "_" + this.type + "." + uniqueDateFormat.format(now) + this.extension);
        try (BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(fOut.getAbsolutePath()));){
            this.export(bufOut);
        }
        UpdateBuilder update = new UpdateBuilder(this.getEcritureT());
        update.set("DATE_EXPORT", this.getEcritureT().getField("DATE_EXPORT").getType().toString(now));
        update.setWhere(this.getWhere(from, to, selectedJournal, true));
        this.getDS().execute(update.asString());
        return Tuple2.create(fOut, count);
    }

    protected abstract int fetchData(Date var1, Date var2, SQLRow var3, boolean var4);

    protected abstract void export(OutputStream var1) throws IOException;

    public static final String fixedLengthLeftAlign(String str, int fixedWidth) {
        if (str.length() >= fixedWidth) {
            return str.substring(0, fixedWidth);
        }
        StringBuilder b = new StringBuilder();
        b.append(str);
        int paddingSize = fixedWidth - str.length();
        int i = 0;
        while (i < paddingSize) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }

    public static final String fixedLengthRightAlign(String str, int fixedWidth) {
        if (str.length() >= fixedWidth) {
            return str.substring(0, fixedWidth);
        }
        StringBuilder b = new StringBuilder();
        int paddingSize = fixedWidth - str.length();
        int i = 0;
        while (i < paddingSize) {
            b.append(' ');
            ++i;
        }
        b.append(str);
        return b.toString();
    }
}

