/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.panel.ITreeSelectionNode;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public class ITreeSelection
extends JTree
implements MouseListener,
EmptyObj,
ValueWrapper<Integer>,
RowItemViewComponent {
    private SQLElement element;
    private ITreeSelectionNode rootNode;
    private DefaultTreeModel model;
    private Map<Integer, ITreeSelectionNode> mapNode = new HashMap<Integer, ITreeSelectionNode>();
    protected static final int EMPTY_ID = -1;
    private final EmptyChangeSupport helper;
    private final PropertyChangeSupport supp;

    public ITreeSelection() {
        this((SQLElement)null);
    }

    public ITreeSelection(SQLElement element) {
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.setRowHeight(FontUtils.getPreferredRowHeight(this));
        this.getSelectionModel().setSelectionMode(1);
        this.element = element;
        this.supp = new PropertyChangeSupport(this);
        this.helper = new EmptyChangeSupport(this);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ITreeSelection.this.supp.firePropertyChange("value", null, ITreeSelection.this.getValue());
                ITreeSelection.this.helper.fireEmptyChange(ITreeSelection.this.isEmpty());
            }
        });
    }

    private void initTree() {
        if (this.element == null) {
            this.rootNode = new ITreeSelectionNode(null);
        } else {
            SQLRowValues row = UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.element.getTable());
            this.rootNode = new ITreeSelectionNode(row);
        }
        this.model = new DefaultTreeModel(this.rootNode);
        this.setModel(this.model);
        this.loadTree();
        this.setTableListener();
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath path = this.getSelectionPath();
        if (path != null && e.getButton() == 3) {
            final int idSelect = this.getSelectedID();
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction("Ajouter un \u00e9l\u00e9ment"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ITreeSelection.this.addElement(idSelect);
                }
            });
            if (idSelect > 1) {
                menu.add(new AbstractAction("Modifier"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ITreeSelection.this.modifyElement(idSelect);
                    }
                });
                menu.add(new AbstractAction("Supprimer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ITreeSelection.this.removeElement(idSelect);
                    }
                });
            }
            menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    public int getSelectedID() {
        Object o;
        TreePath path = this.getSelectionPath();
        int id = 1;
        if (path != null && (o = path.getLastPathComponent()) instanceof ITreeSelectionNode) {
            ITreeSelectionNode nodeSelect = (ITreeSelectionNode)o;
            id = nodeSelect.getId();
        }
        return id;
    }

    public void addElement(int idRoot) {
        EditFrame frameAdd = new EditFrame(this.element, EditFrame.CREATION);
        SQLRowValues rowVals = new SQLRowValues(this.element.getTable());
        if (idRoot > 1) {
            rowVals.put("ID_" + this.element.getTable().getName() + "_PERE", idRoot);
            frameAdd.getSQLComponent().select(rowVals);
        }
        FrameUtil.showPacked(frameAdd);
    }

    public void removeElement(int id) {
        if (id > 1) {
            try {
                this.element.archive(id);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void modifyElement(int id) {
        if (id > 1) {
            EditFrame frameModFamille = new EditFrame(this.element, EditFrame.MODIFICATION);
            frameModFamille.selectionId(id, 1);
            FrameUtil.showPacked(frameModFamille);
        }
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public void resetValue() {
        this.setValue(1);
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.helper.removeEmptyListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    @Override
    public Integer getValue() {
        Object o;
        int id = 1;
        TreePath path = this.getSelectionPath();
        if (path != null && (o = path.getLastPathComponent()) instanceof ITreeSelectionNode) {
            ITreeSelectionNode nodeSelect = (ITreeSelectionNode)o;
            id = nodeSelect.getId();
        }
        return id;
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() <= -1;
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void init(SQLRowItemView v) {
        if (this.element == null) {
            SQLTable foreignTable = v.getField().getTable().getDBSystemRoot().getGraph().getForeignTable(v.getField());
            this.element = Configuration.getInstance().getDirectory().getElement(foreignTable);
        }
        this.initTree();
    }

    @Override
    public void setValue(Integer val) {
        ITreeSelectionNode v;
        if (val == null) {
            val = -1;
        }
        if ((v = this.mapNode.get(val)).getId() == val.intValue()) {
            this.setExpandsSelectedPaths(true);
            this.setSelectionPath(new TreePath(v.getPath()));
        }
    }

    private void loadTree() {
        new SwingWorker<List<SQLRow>, Object>(){

            @Override
            protected List<SQLRow> doInBackground() throws Exception {
                SQLTable table = ITreeSelection.this.element.getTable();
                SQLSelect sel = new SQLSelect();
                sel.addSelectStar(table);
                return SQLRowListRSH.execute(sel);
            }

            @Override
            protected void done() {
                try {
                    List l = (List)this.get();
                    if (l != null) {
                        SQLRow row;
                        HashMap<Integer, SQLRow> familles = new HashMap<Integer, SQLRow>();
                        int i = 0;
                        while (i < l.size()) {
                            row = (SQLRow)l.get(i);
                            familles.put(row.getID(), row);
                            ++i;
                        }
                        i = 0;
                        while (i < l.size()) {
                            row = (SQLRow)l.get(i);
                            ITreeSelection.this.addNewNode(familles, row, row.getInt("ID_" + ITreeSelection.this.element.getTable().getName() + "_PERE"));
                            ++i;
                        }
                        ITreeSelection.this.expandRow(0);
                    }
                }
                catch (InterruptedException e) {
                    ExceptionHandler.handle("", e);
                }
                catch (ExecutionException e) {
                    ExceptionHandler.handle("", e);
                }
            }
        }.execute();
    }

    private void addNewNode(Map<Integer, SQLRow> familles, SQLRow row, int idPere) {
        if (row != null && this.mapNode.get(row.getID()) == null) {
            ITreeSelectionNode nodePere = this.mapNode.get(idPere);
            if (idPere > 1 && nodePere == null && familles != null) {
                SQLRow rowPere = familles.get(idPere);
                if (rowPere.getID() != row.getID()) {
                    this.addNewNode(familles, rowPere, rowPere.getInt("ID_" + this.element.getTable().getName() + "_PERE"));
                }
                nodePere = this.mapNode.get(idPere);
            }
            ITreeSelectionNode newNode = new ITreeSelectionNode(row);
            this.mapNode.put(row.getID(), newNode);
            if (!row.isUndefined()) {
                if (nodePere != null && idPere > 1) {
                    this.addNode(newNode, nodePere);
                } else if (idPere == 1) {
                    this.addNode(newNode, this.rootNode);
                }
            }
        }
    }

    private void addNode(ITreeSelectionNode nodeToAdd, ITreeSelectionNode nodeParent) {
        int n = 0;
        int childCount = nodeParent.getChildCount();
        while (n < childCount) {
            if (nodeToAdd.toString().compareToIgnoreCase(nodeParent.getChildAt(n).toString()) < 0) break;
            ++n;
        }
        this.model.insertNodeInto(nodeToAdd, nodeParent, n);
    }

    private void modifyNode(SQLRow row, ITreeSelectionNode node) {
        if (row.isArchived() && node.getParent() != null) {
            this.model.removeNodeFromParent(node);
        } else {
            node.setRow(row);
            this.model.nodeChanged(node);
        }
    }

    private void removeNode(SQLRow row, ITreeSelectionNode nodeParent) {
        int childCount = nodeParent.getChildCount();
        int i = 0;
        while (i < childCount) {
            ITreeSelectionNode v = (ITreeSelectionNode)nodeParent.getChildAt(i);
            if (v.getId() == row.getID()) {
                this.model.removeNodeFromParent(v);
            }
            ++i;
        }
    }

    private void setTableListener() {
        SQLTableListener listener = new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                ITreeSelectionNode node = (ITreeSelectionNode)ITreeSelection.this.mapNode.get(id);
                if (node != null) {
                    ITreeSelection.this.modifyNode(table.getRow(id), node);
                }
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                SQLRow row = table.getRow(id);
                int idPere = row.getInt("ID_" + ITreeSelection.this.element.getTable().getName() + "_PERE");
                ITreeSelection.this.addNewNode(null, row, idPere);
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                ITreeSelectionNode node = (ITreeSelectionNode)ITreeSelection.this.mapNode.get(id);
                int i = 0;
                while (i < node.getChildCount()) {
                    ITreeSelection.this.removeNode(table.getRow(id), node);
                    ++i;
                }
            }
        };
        this.element.getTable().addTableListener(listener);
    }
}

